/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.asn1.x509;

import com.maverick.crypto.asn1.ASN1EncodableVector;
import com.maverick.crypto.asn1.ASN1Sequence;
import com.maverick.crypto.asn1.ASN1TaggedObject;
import com.maverick.crypto.asn1.DERBitString;
import com.maverick.crypto.asn1.DEREncodable;
import com.maverick.crypto.asn1.DERInputStream;
import com.maverick.crypto.asn1.DERObject;
import com.maverick.crypto.asn1.DERSequence;
import com.maverick.crypto.asn1.x509.AlgorithmIdentifier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Enumeration;

public class SubjectPublicKeyInfo
implements DEREncodable {
    private AlgorithmIdentifier b;
    private DERBitString c;

    public static SubjectPublicKeyInfo getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return SubjectPublicKeyInfo.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static SubjectPublicKeyInfo getInstance(Object object) {
        if (object instanceof SubjectPublicKeyInfo) {
            return (SubjectPublicKeyInfo)object;
        }
        if (object instanceof ASN1Sequence) {
            return new SubjectPublicKeyInfo((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public SubjectPublicKeyInfo(AlgorithmIdentifier algorithmIdentifier, DEREncodable dEREncodable) {
        this.c = new DERBitString(dEREncodable);
        this.b = algorithmIdentifier;
    }

    public SubjectPublicKeyInfo(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        this.c = new DERBitString(byArray);
        this.b = algorithmIdentifier;
    }

    public SubjectPublicKeyInfo(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.b = AlgorithmIdentifier.getInstance(enumeration.nextElement());
        this.c = (DERBitString)enumeration.nextElement();
    }

    public AlgorithmIdentifier getAlgorithmId() {
        return this.b;
    }

    public DERObject getPublicKey() throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.c.getBytes());
        DERInputStream dERInputStream = new DERInputStream(byteArrayInputStream);
        return dERInputStream.readObject();
    }

    public DERBitString getPublicKeyData() {
        return this.c;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        return new DERSequence(aSN1EncodableVector);
    }
}

