/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.asn1.x509;

import com.maverick.crypto.asn1.ASN1Encodable;
import com.maverick.crypto.asn1.ASN1EncodableVector;
import com.maverick.crypto.asn1.ASN1Sequence;
import com.maverick.crypto.asn1.ASN1TaggedObject;
import com.maverick.crypto.asn1.DERBoolean;
import com.maverick.crypto.asn1.DERInteger;
import com.maverick.crypto.asn1.DERObject;
import com.maverick.crypto.asn1.DERSequence;
import java.math.BigInteger;

public class BasicConstraints
extends ASN1Encodable {
    DERBoolean \u00c7 = new DERBoolean(false);
    DERInteger \u00c8 = null;

    public static BasicConstraints getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return BasicConstraints.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static BasicConstraints getInstance(Object object) {
        if (object == null || object instanceof BasicConstraints) {
            return (BasicConstraints)object;
        }
        if (object instanceof ASN1Sequence) {
            return new BasicConstraints((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public BasicConstraints(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() == 0) {
            this.\u00c7 = null;
            this.\u00c8 = null;
        } else {
            this.\u00c7 = (DERBoolean)aSN1Sequence.getObjectAt(0);
            if (aSN1Sequence.size() > 1) {
                this.\u00c8 = (DERInteger)aSN1Sequence.getObjectAt(1);
            }
        }
    }

    public BasicConstraints(boolean bl, int n) {
        if (bl) {
            this.\u00c7 = new DERBoolean(bl);
            this.\u00c8 = new DERInteger(n);
        } else {
            this.\u00c7 = null;
            this.\u00c8 = null;
        }
    }

    public BasicConstraints(boolean bl) {
        this.\u00c7 = bl ? new DERBoolean(true) : null;
        this.\u00c8 = null;
    }

    public BasicConstraints(int n) {
        this.\u00c7 = new DERBoolean(true);
        this.\u00c8 = new DERInteger(n);
    }

    public boolean isCA() {
        return this.\u00c7 != null && this.\u00c7.isTrue();
    }

    public BigInteger getPathLenConstraint() {
        if (this.\u00c8 != null) {
            return this.\u00c8.getValue();
        }
        return null;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.\u00c7 != null) {
            aSN1EncodableVector.add(this.\u00c7);
            if (this.\u00c8 != null) {
                aSN1EncodableVector.add(this.\u00c8);
            }
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public String toString() {
        if (this.\u00c8 == null) {
            if (this.\u00c7 == null) {
                return "BasicConstraints: isCa(false)";
            }
            return "BasicConstraints: isCa(" + this.isCA() + ")";
        }
        return "BasicConstraints: isCa(" + this.isCA() + "), pathLenConstraint = " + this.\u00c8.getValue();
    }
}

