/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.asn1;

import com.maverick.crypto.asn1.ASN1OctetString;
import com.maverick.crypto.asn1.ASN1TaggedObject;
import com.maverick.crypto.asn1.DERObject;
import com.maverick.crypto.asn1.DEROutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;

public class DERGeneralizedTime
extends DERObject {
    String z;

    public static DERGeneralizedTime getInstance(Object object) {
        if (object == null || object instanceof DERGeneralizedTime) {
            return (DERGeneralizedTime)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERGeneralizedTime(((ASN1OctetString)object).getOctets());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERGeneralizedTime getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERGeneralizedTime.getInstance(aSN1TaggedObject.getObject());
    }

    public DERGeneralizedTime(String string) {
        this.z = string;
    }

    public DERGeneralizedTime(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        this.z = simpleDateFormat.format(date);
    }

    DERGeneralizedTime(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int i = 0; i != cArray.length; ++i) {
            cArray[i] = (char)(byArray[i] & 0xFF);
        }
        this.z = new String(cArray);
    }

    public String getTime() {
        if (this.z.charAt(this.z.length() - 1) == 'Z') {
            return this.z.substring(0, this.z.length() - 1) + "GMT+00:00";
        }
        int n = this.z.length() - 5;
        char c = this.z.charAt(n);
        if (c == '-' || c == '+') {
            return this.z.substring(0, n) + "GMT" + this.z.substring(n, n + 3) + ":" + this.z.substring(n + 3);
        }
        n = this.z.length() - 3;
        c = this.z.charAt(n);
        if (c == '-' || c == '+') {
            return this.z.substring(0, n) + "GMT" + this.z.substring(n) + ":00";
        }
        return this.z;
    }

    public Date getDate() throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        return simpleDateFormat.parse(this.z);
    }

    private byte[] E() {
        char[] cArray = this.z.toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int i = 0; i != cArray.length; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        return byArray;
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.A(24, this.E());
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DERGeneralizedTime)) {
            return false;
        }
        return this.z.equals(((DERGeneralizedTime)object).z);
    }
}

