/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.asn1;

import com.maverick.crypto.asn1.ASN1OctetString;
import com.maverick.crypto.asn1.ASN1TaggedObject;
import com.maverick.crypto.asn1.DERObject;
import com.maverick.crypto.asn1.DEROutputStream;
import com.maverick.crypto.asn1.DERString;
import java.io.IOException;

public class DERGeneralString
extends DERObject
implements DERString {
    private String m;

    public static DERGeneralString getInstance(Object object) {
        if (object == null || object instanceof DERGeneralString) {
            return (DERGeneralString)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERGeneralString(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DERGeneralString.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERGeneralString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERGeneralString.getInstance(aSN1TaggedObject.getObject());
    }

    public DERGeneralString(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int i = 0; i != cArray.length; ++i) {
            cArray[i] = (char)(byArray[i] & 0xFF);
        }
        this.m = new String(cArray);
    }

    public DERGeneralString(String string) {
        this.m = string;
    }

    public String getString() {
        return this.m;
    }

    public byte[] getOctets() {
        char[] cArray = this.m.toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int i = 0; i != cArray.length; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        return byArray;
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.A(27, this.getOctets());
    }

    public int hashCode() {
        return this.getString().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DERGeneralString)) {
            return false;
        }
        DERGeneralString dERGeneralString = (DERGeneralString)object;
        return this.getString().equals(dERGeneralString.getString());
    }
}

