/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.asn1;

import com.maverick.crypto.asn1.ASN1OctetString;
import com.maverick.crypto.asn1.ASN1OutputStream;
import com.maverick.crypto.asn1.ASN1Sequence;
import com.maverick.crypto.asn1.ASN1Set;
import com.maverick.crypto.asn1.BERConstructedOctetString;
import com.maverick.crypto.asn1.BERConstructedSequence;
import com.maverick.crypto.asn1.BEROutputStream;
import com.maverick.crypto.asn1.DEREncodable;
import com.maverick.crypto.asn1.DEROutputStream;
import com.maverick.crypto.asn1.DERTaggedObject;
import java.io.IOException;
import java.util.Enumeration;

public class BERTaggedObject
extends DERTaggedObject {
    public BERTaggedObject(int n, DEREncodable dEREncodable) {
        super(n, dEREncodable);
    }

    public BERTaggedObject(boolean bl, int n, DEREncodable dEREncodable) {
        super(bl, n, dEREncodable);
    }

    public BERTaggedObject(int n) {
        super(false, n, new BERConstructedSequence());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void encode(DEROutputStream dEROutputStream) throws IOException {
        if (dEROutputStream instanceof ASN1OutputStream || dEROutputStream instanceof BEROutputStream) {
            dEROutputStream.write(0xA0 | this.\u00aa);
            dEROutputStream.write(128);
            if (!this.\u00b5) {
                if (!this.\u00a5) {
                    if (this.\u00ba instanceof ASN1OctetString) {
                        Enumeration enumeration;
                        if (this.\u00ba instanceof BERConstructedOctetString) {
                            enumeration = ((BERConstructedOctetString)this.\u00ba).getObjects();
                        } else {
                            ASN1OctetString aSN1OctetString = (ASN1OctetString)this.\u00ba;
                            BERConstructedOctetString bERConstructedOctetString = new BERConstructedOctetString(aSN1OctetString.getOctets());
                            enumeration = bERConstructedOctetString.getObjects();
                        }
                        while (enumeration.hasMoreElements()) {
                            dEROutputStream.writeObject(enumeration.nextElement());
                        }
                    } else if (this.\u00ba instanceof ASN1Sequence) {
                        Enumeration enumeration = ((ASN1Sequence)this.\u00ba).getObjects();
                        while (enumeration.hasMoreElements()) {
                            dEROutputStream.writeObject(enumeration.nextElement());
                        }
                    } else {
                        if (!(this.\u00ba instanceof ASN1Set)) throw new RuntimeException("not implemented: " + this.\u00ba.getClass().getName());
                        Enumeration enumeration = ((ASN1Set)this.\u00ba).getObjects();
                        while (enumeration.hasMoreElements()) {
                            dEROutputStream.writeObject(enumeration.nextElement());
                        }
                    }
                } else {
                    dEROutputStream.writeObject(this.\u00ba);
                }
            }
            dEROutputStream.write(0);
            dEROutputStream.write(0);
            return;
        } else {
            super.encode(dEROutputStream);
        }
    }
}

