/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.asn1;

import com.maverick.crypto.asn1.ASN1OctetString;
import com.maverick.crypto.asn1.ASN1Sequence;
import com.maverick.crypto.asn1.ASN1Set;
import com.maverick.crypto.asn1.BERConstructedSequence;
import com.maverick.crypto.asn1.BERSequence;
import com.maverick.crypto.asn1.BERSet;
import com.maverick.crypto.asn1.BERTaggedObject;
import com.maverick.crypto.asn1.DERBMPString;
import com.maverick.crypto.asn1.DERBoolean;
import com.maverick.crypto.asn1.DERConstructedSequence;
import com.maverick.crypto.asn1.DERConstructedSet;
import com.maverick.crypto.asn1.DEREncodable;
import com.maverick.crypto.asn1.DERIA5String;
import com.maverick.crypto.asn1.DERInteger;
import com.maverick.crypto.asn1.DERNull;
import com.maverick.crypto.asn1.DERObject;
import com.maverick.crypto.asn1.DERObjectIdentifier;
import com.maverick.crypto.asn1.DEROctetString;
import com.maverick.crypto.asn1.DERPrintableString;
import com.maverick.crypto.asn1.DERSequence;
import com.maverick.crypto.asn1.DERSet;
import com.maverick.crypto.asn1.DERT61String;
import com.maverick.crypto.asn1.DERTaggedObject;
import com.maverick.crypto.asn1.DERUTCTime;
import com.maverick.crypto.asn1.DERUnknownTag;
import com.maverick.crypto.asn1.DERVisibleString;
import com.maverick.crypto.encoders.Hex;
import java.util.Enumeration;

public class ASN1Dump {
    private static String A = "    ";

    public static String _dumpAsString(String string, DERObject dERObject) {
        if (dERObject instanceof ASN1Sequence) {
            StringBuffer stringBuffer = new StringBuffer();
            Enumeration enumeration = ((ASN1Sequence)dERObject).getObjects();
            String string2 = string + A;
            stringBuffer.append(string);
            if (dERObject instanceof BERConstructedSequence) {
                stringBuffer.append("BER ConstructedSequence");
            } else if (dERObject instanceof DERConstructedSequence) {
                stringBuffer.append("DER ConstructedSequence");
            } else if (dERObject instanceof DERSequence) {
                stringBuffer.append("DER Sequence");
            } else if (dERObject instanceof BERSequence) {
                stringBuffer.append("BER Sequence");
            } else {
                stringBuffer.append("Sequence");
            }
            stringBuffer.append(System.getProperty("line.separator"));
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e == null || e.equals(new DERNull())) {
                    stringBuffer.append(string2);
                    stringBuffer.append("NULL");
                    stringBuffer.append(System.getProperty("line.separator"));
                    continue;
                }
                if (e instanceof DERObject) {
                    stringBuffer.append(ASN1Dump._dumpAsString(string2, (DERObject)e));
                    continue;
                }
                stringBuffer.append(ASN1Dump._dumpAsString(string2, ((DEREncodable)e).getDERObject()));
            }
            return stringBuffer.toString();
        }
        if (dERObject instanceof DERTaggedObject) {
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = string + A;
            stringBuffer.append(string);
            if (dERObject instanceof BERTaggedObject) {
                stringBuffer.append("BER Tagged [");
            } else {
                stringBuffer.append("Tagged [");
            }
            DERTaggedObject dERTaggedObject = (DERTaggedObject)dERObject;
            stringBuffer.append(Integer.toString(dERTaggedObject.getTagNo()));
            stringBuffer.append("]");
            if (!dERTaggedObject.isExplicit()) {
                stringBuffer.append(" IMPLICIT ");
            }
            stringBuffer.append(System.getProperty("line.separator"));
            if (dERTaggedObject.isEmpty()) {
                stringBuffer.append(string3);
                stringBuffer.append("EMPTY");
                stringBuffer.append(System.getProperty("line.separator"));
            } else {
                stringBuffer.append(ASN1Dump._dumpAsString(string3, dERTaggedObject.getObject()));
            }
            return stringBuffer.toString();
        }
        if (dERObject instanceof DERConstructedSet) {
            StringBuffer stringBuffer = new StringBuffer();
            Enumeration enumeration = ((ASN1Set)dERObject).getObjects();
            String string4 = string + A;
            stringBuffer.append(string);
            stringBuffer.append("ConstructedSet");
            stringBuffer.append(System.getProperty("line.separator"));
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e == null) {
                    stringBuffer.append(string4);
                    stringBuffer.append("NULL");
                    stringBuffer.append(System.getProperty("line.separator"));
                    continue;
                }
                if (e instanceof DERObject) {
                    stringBuffer.append(ASN1Dump._dumpAsString(string4, (DERObject)e));
                    continue;
                }
                stringBuffer.append(ASN1Dump._dumpAsString(string4, ((DEREncodable)e).getDERObject()));
            }
            return stringBuffer.toString();
        }
        if (dERObject instanceof BERSet) {
            StringBuffer stringBuffer = new StringBuffer();
            Enumeration enumeration = ((ASN1Set)dERObject).getObjects();
            String string5 = string + A;
            stringBuffer.append(string);
            stringBuffer.append("BER Set");
            stringBuffer.append(System.getProperty("line.separator"));
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e == null) {
                    stringBuffer.append(string5);
                    stringBuffer.append("NULL");
                    stringBuffer.append(System.getProperty("line.separator"));
                    continue;
                }
                if (e instanceof DERObject) {
                    stringBuffer.append(ASN1Dump._dumpAsString(string5, (DERObject)e));
                    continue;
                }
                stringBuffer.append(ASN1Dump._dumpAsString(string5, ((DEREncodable)e).getDERObject()));
            }
            return stringBuffer.toString();
        }
        if (dERObject instanceof DERSet) {
            StringBuffer stringBuffer = new StringBuffer();
            Enumeration enumeration = ((ASN1Set)dERObject).getObjects();
            String string6 = string + A;
            stringBuffer.append(string);
            stringBuffer.append("DER Set");
            stringBuffer.append(System.getProperty("line.separator"));
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e == null) {
                    stringBuffer.append(string6);
                    stringBuffer.append("NULL");
                    stringBuffer.append(System.getProperty("line.separator"));
                    continue;
                }
                if (e instanceof DERObject) {
                    stringBuffer.append(ASN1Dump._dumpAsString(string6, (DERObject)e));
                    continue;
                }
                stringBuffer.append(ASN1Dump._dumpAsString(string6, ((DEREncodable)e).getDERObject()));
            }
            return stringBuffer.toString();
        }
        if (dERObject instanceof DERObjectIdentifier) {
            return string + "ObjectIdentifier(" + ((DERObjectIdentifier)dERObject).getId() + ")" + System.getProperty("line.separator");
        }
        if (dERObject instanceof DERBoolean) {
            return string + "Boolean(" + ((DERBoolean)dERObject).isTrue() + ")" + System.getProperty("line.separator");
        }
        if (dERObject instanceof DERInteger) {
            return string + "Integer(" + ((DERInteger)dERObject).getValue() + ")" + System.getProperty("line.separator");
        }
        if (dERObject instanceof DEROctetString) {
            return string + dERObject.toString() + "[" + ((ASN1OctetString)dERObject).getOctets().length + "] " + System.getProperty("line.separator");
        }
        if (dERObject instanceof DERIA5String) {
            return string + "IA5String(" + ((DERIA5String)dERObject).getString() + ") " + System.getProperty("line.separator");
        }
        if (dERObject instanceof DERPrintableString) {
            return string + "PrintableString(" + ((DERPrintableString)dERObject).getString() + ") " + System.getProperty("line.separator");
        }
        if (dERObject instanceof DERVisibleString) {
            return string + "VisibleString(" + ((DERVisibleString)dERObject).getString() + ") " + System.getProperty("line.separator");
        }
        if (dERObject instanceof DERBMPString) {
            return string + "BMPString(" + ((DERBMPString)dERObject).getString() + ") " + System.getProperty("line.separator");
        }
        if (dERObject instanceof DERT61String) {
            return string + "T61String(" + ((DERT61String)dERObject).getString() + ") " + System.getProperty("line.separator");
        }
        if (dERObject instanceof DERUTCTime) {
            return string + "UTCTime(" + ((DERUTCTime)dERObject).getTime() + ") " + System.getProperty("line.separator");
        }
        if (dERObject instanceof DERUnknownTag) {
            return string + "Unknown " + Integer.toString(((DERUnknownTag)dERObject).getTag(), 16) + " " + new String(Hex.encode(((DERUnknownTag)dERObject).getData())) + System.getProperty("line.separator");
        }
        return string + dERObject.toString() + System.getProperty("line.separator");
    }

    public static String dumpAsString(Object object) {
        if (object instanceof DERObject) {
            return ASN1Dump._dumpAsString("", (DERObject)object);
        }
        if (object instanceof DEREncodable) {
            return ASN1Dump._dumpAsString("", ((DEREncodable)object).getDERObject());
        }
        return "unknown object type " + object.toString();
    }
}

