/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.cipher;

import com.maverick.crypto.engines.CipherEngine;
import com.maverick.ssh.cipher.SshCipher;
import java.io.IOException;

public class CtrBlockCipher
extends SshCipher {
    private CipherEngine F;
    private int G;
    private byte[] D = null;
    private byte[] E = null;
    private byte[] B = null;
    private byte[] C = null;

    public CtrBlockCipher(int n, CipherEngine cipherEngine, String string) {
        super(string);
        this.E = new byte[n / 8];
        this.F = cipherEngine;
    }

    public void transform(byte[] byArray, int n, byte[] byArray2, int n2, int n3) throws IOException {
        if (n3 % this.getBlockSize() != 0) {
            throw new IOException("Input data length MUST be a multiple of the cipher block size!");
        }
        for (int i = 0; i < n3; i += this.getBlockSize()) {
            this.processBlock(byArray, n + i, byArray2, i + n2);
        }
    }

    public void init(int n, byte[] byArray, byte[] byArray2) throws IOException {
        this.G = n;
        System.arraycopy(byArray2, 0, this.E, 0, this.E.length);
        this.F.init(true, this.E);
        this.D = new byte[this.getBlockSize()];
        System.arraycopy(byArray, 0, this.D, 0, this.D.length);
        this.B = new byte[this.getBlockSize()];
        this.C = new byte[this.getBlockSize()];
        System.arraycopy(byArray, 0, this.B, 0, this.B.length);
    }

    public int getBlockSize() {
        return this.F.getBlockSize();
    }

    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws IOException {
        int n3;
        this.F.processBlock(this.B, 0, this.C, 0);
        for (n3 = 0; n3 < this.C.length; ++n3) {
            byArray2[n2 + n3] = (byte)(this.C[n3] ^ byArray[n + n3]);
        }
        n3 = 1;
        for (int i = this.B.length - 1; i >= 0; --i) {
            int n4 = (this.B[i] & 0xFF) + n3;
            n3 = n4 > 255 ? 1 : 0;
            this.B[i] = (byte)n4;
        }
        return this.B.length;
    }
}

