/*
 * Decompiled with CFR 0.152.
 */
package jnacontrib.win32;

import com.sun.jna.Pointer;
import jnacontrib.jna.Advapi32;

public abstract class Win32Service {
    protected String serviceName;
    private ServiceMain serviceMain;
    private ServiceControl serviceControl;
    private Pointer serviceStatusHandle;
    private Object waitObject = new Object();

    public Win32Service(String serviceName) {
        this.serviceName = serviceName;
    }

    public boolean install(String displayName, String description, String[] dependencies, String account, String password) {
        return this.install(displayName, description, dependencies, account, password, "java.exe -cp \"" + System.getProperty("java.class.path") + "\" -Xrs " + this.getClass().getName());
    }

    public boolean install(String displayName, String description, String[] dependencies, String account, String password, String command) {
        boolean success = false;
        String dep = "";
        if (dependencies != null) {
            for (int index = 0; index < dependencies.length; ++index) {
                String s = dependencies[index];
                dep = dep + s + "\u0000";
            }
        }
        dep = dep + "\u0000";
        Advapi32.SERVICE_DESCRIPTION desc = new Advapi32.SERVICE_DESCRIPTION();
        desc.lpDescription = description;
        Advapi32 advapi32 = Advapi32.INSTANCE;
        Pointer serviceManager = this.openServiceControlManager(null, 983103);
        if (serviceManager != null) {
            Pointer service = advapi32.CreateService(serviceManager, this.serviceName, displayName, 983551, 16, 3, 1, command, null, null, dep, account, password);
            if (service != null) {
                success = advapi32.ChangeServiceConfig2(service, 1, desc);
                advapi32.CloseServiceHandle(service);
            }
            advapi32.CloseServiceHandle(serviceManager);
        }
        return success;
    }

    public boolean uninstall() {
        boolean success = false;
        Advapi32 advapi32 = Advapi32.INSTANCE;
        Pointer serviceManager = this.openServiceControlManager(null, 983103);
        if (serviceManager != null) {
            Pointer service = advapi32.OpenService(serviceManager, this.serviceName, 983551);
            if (service != null) {
                success = advapi32.DeleteService(service);
                advapi32.CloseServiceHandle(service);
            }
            advapi32.CloseServiceHandle(serviceManager);
        }
        return success;
    }

    public boolean start() {
        boolean success = false;
        Advapi32 advapi32 = Advapi32.INSTANCE;
        Pointer serviceManager = this.openServiceControlManager(null, 0x20000000);
        if (serviceManager != null) {
            Pointer service = advapi32.OpenService(serviceManager, this.serviceName, 0x20000000);
            if (service != null) {
                success = advapi32.StartService(service, 0, null);
                advapi32.CloseServiceHandle(service);
            }
            advapi32.CloseServiceHandle(serviceManager);
        }
        return success;
    }

    public boolean stop() throws Exception {
        boolean success = false;
        Advapi32 advapi32 = Advapi32.INSTANCE;
        Pointer serviceManager = this.openServiceControlManager(null, 0x20000000);
        if (serviceManager != null) {
            Pointer service = advapi32.OpenService(serviceManager, this.serviceName, 0x20000000);
            if (service != null) {
                Advapi32.SERVICE_STATUS serviceStatus = new Advapi32.SERVICE_STATUS();
                success = advapi32.ControlService(service, 1, serviceStatus);
                advapi32.CloseServiceHandle(service);
            }
            advapi32.CloseServiceHandle(serviceManager);
        }
        return success;
    }

    public void init() {
        Advapi32.SERVICE_TABLE_ENTRY[] entries = new Advapi32.SERVICE_TABLE_ENTRY[2];
        this.serviceMain = new ServiceMain();
        Advapi32 advapi32 = Advapi32.INSTANCE;
        Advapi32.SERVICE_TABLE_ENTRY entry = new Advapi32.SERVICE_TABLE_ENTRY();
        entry.lpServiceName = this.serviceName;
        entry.lpServiceProc = this.serviceMain;
        advapi32.StartServiceCtrlDispatcher(entry.toArray(2));
    }

    private Pointer openServiceControlManager(String machine, int access) {
        Pointer handle = null;
        Advapi32 advapi32 = Advapi32.INSTANCE;
        handle = advapi32.OpenSCManager(machine, null, access);
        return handle;
    }

    private void reportStatus(int status, int win32ExitCode, int waitHint) {
        Advapi32 advapi32 = Advapi32.INSTANCE;
        Advapi32.SERVICE_STATUS serviceStatus = new Advapi32.SERVICE_STATUS();
        serviceStatus.dwServiceType = 16;
        serviceStatus.dwControlsAccepted = 5;
        serviceStatus.dwWin32ExitCode = win32ExitCode;
        serviceStatus.dwWaitHint = waitHint;
        serviceStatus.dwCurrentState = status;
        advapi32.SetServiceStatus(this.serviceStatusHandle, serviceStatus);
    }

    public abstract void onStart();

    public abstract void onStop();

    private class ServiceControl
    implements Advapi32.HandlerEx {
        private ServiceControl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int callback(int dwControl, int dwEventType, Pointer lpEventData, Pointer lpContext) {
            switch (dwControl) {
                case 1: 
                case 5: {
                    Win32Service.this.reportStatus(3, 0, 5000);
                    Win32Service.this.onStop();
                    Object object = Win32Service.this.waitObject;
                    synchronized (object) {
                        Win32Service.this.waitObject.notifyAll();
                        break;
                    }
                }
            }
            return 0;
        }
    }

    private class ServiceMain
    implements Advapi32.SERVICE_MAIN_FUNCTION {
        private ServiceMain() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void callback(int dwArgc, Pointer lpszArgv) {
            Advapi32 advapi32 = Advapi32.INSTANCE;
            Win32Service.this.serviceControl = new ServiceControl();
            Win32Service.this.serviceStatusHandle = advapi32.RegisterServiceCtrlHandlerEx(Win32Service.this.serviceName, Win32Service.this.serviceControl, null);
            Win32Service.this.reportStatus(2, 0, 3000);
            Win32Service.this.reportStatus(4, 0, 0);
            Win32Service.this.onStart();
            try {
                Object object = Win32Service.this.waitObject;
                synchronized (object) {
                    Win32Service.this.waitObject.wait();
                }
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            Win32Service.this.reportStatus(1, 0, 0);
        }
    }
}

