/*
 * Decompiled with CFR 0.152.
 */
package jnacontrib.win32;

import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.util.TreeSet;
import jnacontrib.jna.Advapi32;
import jnacontrib.jna.Kernel32b;
import jnacontrib.jna.Netapi32;

public class Accounts {
    private static Object userInfoLock = new Object();
    private static Object groupInfoLock = new Object();

    private Accounts() {
    }

    public static void main(String[] args) throws Exception {
        System.out.println("FullDomainName: " + Accounts.getFullDomainName());
        System.out.println("DomainControllerName: " + Accounts.getDomainControllerName());
        System.out.println("UserDomainGroups: " + Accounts.getUserDomainGroups("administrator"));
        System.out.println("UserLocalGroups: " + Accounts.getUserLocalGroups(null, "administrator"));
        System.out.println("AllDomainGroups: " + Accounts.getAllDomainGroups());
        System.out.println("AllDomainUsers: " + Accounts.getAllDomainUsers());
        System.out.println("AccountSidString: " + Accounts.getAccountSidString("administrator"));
        System.out.println("AccountNameBySid: " + Accounts.getAccountName(Accounts.getAccountSid("administrator")));
        System.out.println("AccountNameBySidString: " + Accounts.getAccountName(Accounts.getAccountSidString("administrator")));
    }

    public static String getFullDomainName() {
        String domain = null;
        Netapi32.DOMAIN_CONTROLLER_INFO dci = Accounts.getDomainControllerInfo();
        if (dci != null) {
            domain = dci.DomainName;
        }
        return domain;
    }

    public static String getDomainControllerName() {
        String domainController = null;
        Netapi32.DOMAIN_CONTROLLER_INFO dci = Accounts.getDomainControllerInfo();
        if (dci != null) {
            domainController = dci.DomainControllerName;
        }
        return domainController;
    }

    private static Netapi32.DOMAIN_CONTROLLER_INFO getDomainControllerInfo() {
        Netapi32.DOMAIN_CONTROLLER_INFO dci = null;
        Netapi32 netapi32 = Netapi32.INSTANCE;
        PointerByReference pDci = new PointerByReference();
        if (netapi32.DsGetDcName(null, null, null, null, 0, pDci) == 0) {
            dci = new Netapi32.DOMAIN_CONTROLLER_INFO(pDci.getValue());
            netapi32.NetApiBufferFree(pDci.getValue());
        }
        return dci;
    }

    public static TreeSet getUserDomainGroups(String userName) {
        TreeSet<String> domainGroups = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        Netapi32 netapi32 = Netapi32.INSTANCE;
        PointerByReference buf = new PointerByReference();
        IntByReference entriesread = new IntByReference();
        IntByReference totalentries = new IntByReference();
        if (netapi32.NetUserGetGroups(Accounts.getDomainControllerName(), userName, 0, buf, -1, entriesread, totalentries) == 0) {
            Netapi32.GROUP_USERS_INFO_0 group = new Netapi32.GROUP_USERS_INFO_0(buf.getValue());
            Structure[] groups = group.toArray(entriesread.getValue());
            for (int i = 0; i < entriesread.getValue(); ++i) {
                group = (Netapi32.GROUP_USERS_INFO_0)groups[i];
                domainGroups.add(group.grui0_name);
            }
            if (entriesread.getValue() > 0) {
                netapi32.NetApiBufferFree(buf.getValue());
            }
        }
        return domainGroups;
    }

    public static TreeSet getUserLocalGroups(String serverName, String userName) {
        TreeSet<String> localGroups = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        Netapi32 netapi32 = Netapi32.INSTANCE;
        PointerByReference lbuf = new PointerByReference();
        IntByReference lentriesread = new IntByReference();
        IntByReference ltotalentries = new IntByReference();
        if (netapi32.NetUserGetLocalGroups(null, userName, 0, 0, lbuf, -1, lentriesread, ltotalentries) == 0) {
            Netapi32.LOCALGROUP_USERS_INFO_0 lgroup = new Netapi32.LOCALGROUP_USERS_INFO_0(lbuf.getValue());
            Structure[] lgroups = lgroup.toArray(lentriesread.getValue());
            for (int i = 0; i < lentriesread.getValue(); ++i) {
                lgroup = (Netapi32.LOCALGROUP_USERS_INFO_0)lgroups[i];
                localGroups.add(lgroup.lgrui0_name);
            }
            if (lentriesread.getValue() > 0) {
                netapi32.NetApiBufferFree(lbuf.getValue());
            }
        }
        return localGroups;
    }

    public static TreeSet getAllDomainGroups() {
        Netapi32 netapi32 = Netapi32.INSTANCE;
        TreeSet<String> domainGroups = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        PointerByReference gbuf = new PointerByReference();
        IntByReference gentriesread = new IntByReference();
        IntByReference gtotalentries = new IntByReference();
        if (netapi32.NetGroupEnum(Accounts.getDomainControllerName(), 0, gbuf, -1, gentriesread, gtotalentries, null) == 0) {
            Netapi32.GROUP_INFO_0 ggroup = new Netapi32.GROUP_INFO_0(gbuf.getValue());
            Structure[] ggroups = ggroup.toArray(gentriesread.getValue());
            for (int i = 0; i < gentriesread.getValue(); ++i) {
                ggroup = (Netapi32.GROUP_INFO_0)ggroups[i];
                domainGroups.add(ggroup.grpi0_name);
            }
            if (gentriesread.getValue() > 0) {
                netapi32.NetApiBufferFree(gbuf.getValue());
            }
        }
        return domainGroups;
    }

    public static TreeSet getAllDomainUsers() {
        Netapi32 netapi32 = Netapi32.INSTANCE;
        TreeSet<String> domainUsers = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        PointerByReference ubuf = new PointerByReference();
        IntByReference uentriesread = new IntByReference();
        IntByReference utotalentries = new IntByReference();
        if (netapi32.NetUserEnum(Accounts.getDomainControllerName(), 0, 2, ubuf, -1, uentriesread, utotalentries, null) == 0) {
            Netapi32.USER_INFO_0 user = new Netapi32.USER_INFO_0(ubuf.getValue());
            Structure[] users = user.toArray(uentriesread.getValue());
            for (int i = 0; i < uentriesread.getValue(); ++i) {
                user = (Netapi32.USER_INFO_0)users[i];
                domainUsers.add(user.usri0_name);
            }
            if (uentriesread.getValue() > 0) {
                netapi32.NetApiBufferFree(ubuf.getValue());
            }
        }
        return domainUsers;
    }

    public static byte[] getAccountSid(String account) {
        Object sidString = null;
        Advapi32 advapi32 = Advapi32.INSTANCE;
        IntByReference cbSid = new IntByReference(0);
        IntByReference cchReferencedDomainName = new IntByReference(0);
        PointerByReference peUse = new PointerByReference();
        advapi32.LookupAccountName(null, account, null, cbSid, null, cchReferencedDomainName, peUse);
        byte[] sid = new byte[cbSid.getValue()];
        char[] referencedDomainName = new char[cchReferencedDomainName.getValue()];
        if (!advapi32.LookupAccountName(null, account, sid, cbSid, referencedDomainName, cchReferencedDomainName, peUse)) {
            sid = null;
        }
        return sid;
    }

    public static String getAccountName(byte[] sid) {
        Object sidString = null;
        Advapi32 advapi32 = Advapi32.INSTANCE;
        IntByReference cchName = new IntByReference(0);
        IntByReference cchReferencedDomainName = new IntByReference(0);
        PointerByReference peUse = new PointerByReference();
        advapi32.LookupAccountSid(null, sid, null, cchName, null, cchReferencedDomainName, peUse);
        char[] lpName = new char[cchName.getValue()];
        char[] referencedDomainName = new char[cchReferencedDomainName.getValue()];
        if (!advapi32.LookupAccountSid(null, sid, lpName, cchName, referencedDomainName, cchReferencedDomainName, peUse)) {
            lpName = null;
        }
        if (lpName != null) {
            return Native.toString((char[])lpName);
        }
        return null;
    }

    public static String getAccountSidString(String account) {
        String sidString = null;
        byte[] sid = Accounts.getAccountSid(account);
        if (sid != null) {
            sidString = Accounts.convertSidToString(sid);
        }
        return sidString;
    }

    public static String getAccountName(String sidString) {
        String name = null;
        byte[] sid = Accounts.convertStringToSid(sidString);
        if (sid != null) {
            name = Accounts.getAccountName(sid);
        }
        return name;
    }

    public static String convertSidToString(byte[] sid) {
        String sidString = null;
        Advapi32 advapi32 = Advapi32.INSTANCE;
        PointerByReference stringSid = new PointerByReference();
        if (advapi32.ConvertSidToStringSid(sid, stringSid)) {
            sidString = stringSid.getValue().getString(0L, true);
            Kernel32b.INSTANCE.LocalFree(stringSid.getValue());
        }
        return sidString;
    }

    public static byte[] convertStringToSid(String sidString) {
        byte[] sid = null;
        Advapi32 advapi32 = Advapi32.INSTANCE;
        PointerByReference pSid = new PointerByReference();
        if (advapi32.ConvertStringSidToSid(sidString, pSid)) {
            sid = pSid.getValue().getByteArray(0L, 100);
            Kernel32b.INSTANCE.LocalFree(pSid.getValue());
        }
        return sid;
    }
}

