/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.dictionary.myspell;

import java.util.HashMap;
import java.util.regex.Pattern;

public final class Conditions {
    private static HashMap readed = null;
    private static final Conditions EMPTY_CONDITIONS = new Conditions();
    private Pattern condition;

    private Conditions() {
    }

    private Conditions(String cs) {
        this.condition = Pattern.compile(cs);
    }

    public boolean match(String word) {
        if (null != this.condition) {
            return this.condition.matcher(word).matches();
        }
        return true;
    }

    public static void beginRead() {
        if (null != readed) {
            throw new IllegalStateException();
        }
        readed = new HashMap();
    }

    public static void endRead() {
        if (null == readed) {
            throw new IllegalStateException();
        }
        readed = null;
    }

    public static Conditions createFrom(String cs) {
        if (cs.equals(".")) {
            return EMPTY_CONDITIONS;
        }
        Conditions result = (Conditions)readed.get(cs);
        if (null == result) {
            result = new Conditions(cs);
            readed.put(cs, result);
        }
        return result;
    }
}

