/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.dictionary.myspell;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.retrotranslator.runtime.java.lang._Character;
import org.dts.spell.dictionary.myspell.AffixHeader;
import org.dts.spell.dictionary.myspell.Conditions;
import org.dts.spell.dictionary.myspell.GuessWord;
import org.dts.spell.dictionary.myspell.HEntry;
import org.dts.spell.dictionary.myspell.MapEntry;
import org.dts.spell.dictionary.myspell.PfxEntry;
import org.dts.spell.dictionary.myspell.ReplEntry;
import org.dts.spell.dictionary.myspell.SfxEntry;
import org.dts.spell.dictionary.myspell.Utils;
import org.dts.spell.dictionary.myspell.wordmaps.WordMap;

public class AffixMgr {
    private Map prefixesByData = new TreeMap();
    private Map suffixesByData = new TreeMap();
    private Map prefixesByName = new TreeMap();
    private Map suffixesByName = new TreeMap();
    private WordMap pHMgr;
    private String trystring = null;
    private String compound = null;
    private int cpdmin = 3;
    private ReplEntry[] reptable = null;
    private MapEntry[] maptable = null;
    private boolean nosplitsugs = false;
    private String encoding = null;
    private static final Pattern ENCODING_MICROSOFT = Pattern.compile("microsoft-cp(\\d+)");

    public AffixMgr(InputStream affStream, String encoding, WordMap ptr) throws IOException {
        this.pHMgr = ptr;
        this.parse_file(affStream, encoding);
    }

    public HEntry affix_check(String word) {
        HEntry rv = null;
        rv = this.prefix_check(word);
        if (null == rv) {
            rv = this.suffix_check(word, 0, null);
        }
        return rv;
    }

    public HEntry prefix_check(String word) {
        for (int i = 0; i <= word.length(); ++i) {
            String currPrefix = word.substring(0, i);
            List list = (List)this.prefixesByData.get(currPrefix);
            if (null == list) continue;
            Iterator i$ = list.iterator();
            while (i$.hasNext()) {
                PfxEntry pe = (PfxEntry)i$.next();
                HEntry rv = pe.check(word);
                if (rv == null) continue;
                return rv;
            }
        }
        return null;
    }

    public HEntry suffix_check(String word, int sfxopts, PfxEntry ppfx) {
        for (int i = word.length(); i >= 0; --i) {
            String currSuffix = word.substring(i, word.length());
            List list = (List)this.suffixesByData.get(currSuffix);
            if (null == list) continue;
            Iterator i$ = list.iterator();
            while (i$.hasNext()) {
                SfxEntry se = (SfxEntry)i$.next();
                HEntry rv = se.check(word, sfxopts, ppfx);
                if (rv == null) continue;
                return rv;
            }
        }
        return null;
    }

    private void expand_suffixes(String ts, String ap, List wlst) {
        int al = ap.length();
        for (int i = 0; i < al; ++i) {
            char c = ap.charAt(i);
            List list = (List)this.suffixesByName.get(_Character.valueOf((char)c));
            if (null == list) continue;
            Iterator i$ = list.iterator();
            while (i$.hasNext()) {
                SfxEntry sptr = (SfxEntry)i$.next();
                String newword = sptr.add(ts);
                if (newword == null) continue;
                wlst.add(new GuessWord(newword, sptr.allowCross()));
            }
        }
    }

    private void expand_prefixes_suffixes(String ap, List wlst) {
        int al = ap.length();
        ListIterator<GuessWord> it = wlst.listIterator();
        it.next();
        while (it.hasNext()) {
            GuessWord wlstJ = (GuessWord)it.next();
            if (!wlstJ.allow) continue;
            for (int k = 0; k < al; ++k) {
                char c = ap.charAt(k);
                List list = (List)this.prefixesByName.get(_Character.valueOf((char)c));
                if (null == list) continue;
                Iterator i$ = list.iterator();
                while (i$.hasNext()) {
                    String newword;
                    PfxEntry cptr = (PfxEntry)i$.next();
                    if (!cptr.allowCross() || (newword = cptr.add(wlstJ.word)) == null) continue;
                    it.add(new GuessWord(newword, cptr.allowCross()));
                }
            }
        }
    }

    private void expand_prefixes(String ts, String ap, List wlst) {
        int al = ap.length();
        for (int m = 0; m < al; ++m) {
            char c = ap.charAt(m);
            List list = (List)this.prefixesByName.get(_Character.valueOf((char)c));
            if (null == list) continue;
            Iterator i$ = list.iterator();
            while (i$.hasNext()) {
                PfxEntry ptr = (PfxEntry)i$.next();
                String newword = ptr.add(ts);
                if (newword == null) continue;
                wlst.add(new GuessWord(newword, ptr.allowCross()));
            }
        }
    }

    public List expand_rootword(String ts, String ap) {
        int al = ap.length();
        LinkedList<GuessWord> wlst = new LinkedList<GuessWord>();
        wlst.add(new GuessWord(ts, false));
        this.expand_suffixes(ts, ap, wlst);
        this.expand_prefixes_suffixes(ap, wlst);
        this.expand_prefixes(ts, ap, wlst);
        return wlst;
    }

    public HEntry compound_check(String word, char compound_flag) {
        int len = word.length();
        HEntry rv = null;
        if (len < this.cpdmin) {
            return null;
        }
        for (int i = this.cpdmin; i < len - (this.cpdmin - 1); ++i) {
            String st = word.substring(0, i);
            rv = this.lookup(st);
            if (rv == null) {
                rv = this.affix_check(st);
            }
            if (rv == null || !Utils.TestAff(rv.astr, compound_flag, rv.astr.length())) continue;
            String wordI = word.substring(i, word.length());
            rv = this.lookup(wordI);
            if (rv != null && Utils.TestAff(rv.astr, compound_flag, rv.astr.length())) {
                return rv;
            }
            rv = this.affix_check(wordI);
            if (rv != null && Utils.TestAff(rv.astr, compound_flag, rv.astr.length())) {
                return rv;
            }
            rv = this.compound_check(wordI, compound_flag);
            if (rv == null) continue;
            return rv;
        }
        return null;
    }

    public HEntry lookup(String word) {
        if (this.pHMgr == null) {
            return null;
        }
        return this.pHMgr.get(word);
    }

    public int get_numrep() {
        if (this.reptable != null) {
            return this.reptable.length;
        }
        return 0;
    }

    public ReplEntry[] get_reptable() {
        return this.reptable;
    }

    public int get_nummap() {
        if (this.maptable != null) {
            return this.maptable.length;
        }
        return 0;
    }

    public MapEntry[] get_maptable() {
        return this.maptable;
    }

    public String get_encoding() {
        if (this.encoding == null) {
            this.encoding = "ISO8859-1";
        }
        return this.encoding;
    }

    public String get_try_string() {
        return this.trystring;
    }

    public String get_compound() {
        return this.compound;
    }

    public boolean get_nosplitsugs() {
        return this.nosplitsugs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readEncoding(String affpath) throws IOException {
        String string;
        FileInputStream rd = null;
        try {
            rd = new FileInputStream(affpath);
            string = AffixMgr.readEncoding(rd);
        }
        catch (Throwable throwable) {
            Utils.close(rd);
            throw throwable;
        }
        Utils.close(rd);
        return string;
    }

    private static String readLine(InputStream affStream) throws IOException {
        StringBuffer builder = new StringBuffer(20);
        int r = affStream.read();
        while (-1 != r && 10 != r) {
            builder.append((char)r);
            r = affStream.read();
        }
        if (r != -1 || builder.length() > 0) {
            return builder.toString();
        }
        return null;
    }

    private static boolean canSkip(String line) {
        return (line = line.trim()).length() == 0 || line.startsWith("#");
    }

    public static String readEncoding(InputStream affStream) throws IOException {
        String line = AffixMgr.readLine(affStream);
        while (null != line && AffixMgr.canSkip(line)) {
            line = AffixMgr.readLine(affStream);
        }
        return AffixMgr.parseEncoding(line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse_file(InputStream affStream, String encoding) throws IOException {
        BufferedReader rd = new BufferedReader(new InputStreamReader(affStream, encoding));
        this.encoding = encoding;
        try {
            String line;
            Conditions.beginRead();
            while ((line = rd.readLine()) != null) {
                if (AffixMgr.canSkip(line)) continue;
                if (line.startsWith("PFX")) {
                    this.parse_pfxaffix(line, rd);
                    continue;
                }
                if (line.startsWith("SFX")) {
                    this.parse_sfxaffix(line, rd);
                    continue;
                }
                if (line.startsWith("TRY")) {
                    this.parse_try(line);
                    continue;
                }
                if (line.startsWith("SET")) {
                    this.parse_set(line);
                    continue;
                }
                if (line.startsWith("COMPOUNDFLAG")) {
                    this.parse_cpdflag(line);
                    continue;
                }
                if (line.startsWith("COMPOUNDMIN")) {
                    this.parse_cpdmin(line);
                    continue;
                }
                if (line.startsWith("REP")) {
                    this.parse_reptable(line, rd);
                    continue;
                }
                if (line.startsWith("MAP")) {
                    this.parse_maptable(line, rd);
                    continue;
                }
                if (!line.startsWith("NOSPLITSUGS")) continue;
                this.nosplitsugs = true;
            }
            this.trim_affixs();
        }
        finally {
            Conditions.endRead();
        }
    }

    private void trim_affixs() {
        this.trim_affix_collection(this.prefixesByData.values());
        this.trim_affix_collection(this.prefixesByName.values());
        this.trim_affix_collection(this.suffixesByData.values());
        this.trim_affix_collection(this.suffixesByName.values());
    }

    private void trim_affix_collection(Collection values) {
        Iterator i$ = values.iterator();
        while (i$.hasNext()) {
            List value = (List)i$.next();
            ((ArrayList)value).trimToSize();
        }
    }

    private void parse_try(String line) throws IOException {
        if (this.trystring != null) {
            Utils.throwIOException("ERROR_DUPLICATE_TRY", new Object[0]);
        }
        StringTokenizer tp = new StringTokenizer(line, " ");
        int i = 0;
        int np = 0;
        while (tp.hasMoreTokens()) {
            String piece = tp.nextToken();
            if (piece.length() == 0) continue;
            switch (i) {
                case 0: {
                    ++np;
                    break;
                }
                case 1: {
                    this.trystring = piece;
                    ++np;
                    break;
                }
            }
            ++i;
        }
        if (np != 2) {
            Utils.throwIOException("ERROR_MISSING_TRY", new Object[0]);
        }
    }

    private static String parseEncoding(String line) throws IOException {
        Matcher m;
        if (line == null) {
            Utils.throwIOException("ERROR_MISSING_SET", new Object[0]);
        }
        StringTokenizer tp = new StringTokenizer(line, " ");
        int i = 0;
        int np = 0;
        String result = null;
        while (tp.hasMoreTokens()) {
            String piece = tp.nextToken();
            if (piece.length() == 0) continue;
            switch (i) {
                case 0: {
                    ++np;
                    break;
                }
                case 1: {
                    result = piece;
                    ++np;
                    break;
                }
            }
            ++i;
        }
        if (np != 2) {
            Utils.throwIOException("ERROR_MISSING_SET", new Object[0]);
        }
        if ((m = ENCODING_MICROSOFT.matcher(result = result.trim())).matches()) {
            result = "windows-" + m.group(1);
        }
        return result;
    }

    private void parse_set(String line) throws IOException {
        if (this.encoding != null) {
            Utils.throwIOException("ERROR_DUPLICATE_SET", new Object[0]);
        }
        this.encoding = AffixMgr.parseEncoding(line);
    }

    private void parse_cpdflag(String line) throws IOException {
        if (this.compound != null) {
            Utils.throwIOException("ERROR_DUPLICATE_COMPOUND_FLAGS", new Object[0]);
        }
        StringTokenizer tp = new StringTokenizer(line, " ");
        int i = 0;
        int np = 0;
        while (tp.hasMoreTokens()) {
            String piece = tp.nextToken();
            if (piece.length() == 0) continue;
            switch (i) {
                case 0: {
                    ++np;
                    break;
                }
                case 1: {
                    this.compound = piece;
                    ++np;
                    break;
                }
            }
            ++i;
        }
        if (np != 2) {
            Utils.throwIOException("ERROR_MISSING_COMPOUND_FLAG", new Object[0]);
        }
    }

    private void parse_cpdmin(String line) throws IOException {
        StringTokenizer tp = new StringTokenizer(line, " ");
        int i = 0;
        int np = 0;
        while (tp.hasMoreTokens()) {
            String piece = tp.nextToken();
            if (piece.length() == 0) continue;
            switch (i) {
                case 0: {
                    ++np;
                    break;
                }
                case 1: {
                    this.cpdmin = Integer.parseInt(piece);
                    ++np;
                    break;
                }
            }
            ++i;
        }
        if (np != 2) {
            Utils.throwIOException("ERROR_MISSING_COMPOUND_MIN", new Object[0]);
        }
        if (this.cpdmin < 1 || this.cpdmin > 50) {
            this.cpdmin = 3;
        }
    }

    private void parse_reptable(String line, BufferedReader af) throws IOException {
        String piece;
        int numrep = this.get_numrep();
        if (numrep != 0) {
            Utils.throwIOException("ERROR_DUPLICATE_REP", new Object[0]);
        }
        StringTokenizer tp = new StringTokenizer(line, " ");
        int i = 0;
        int np = 0;
        while (tp.hasMoreTokens()) {
            piece = tp.nextToken();
            if (piece.length() == 0) continue;
            switch (i) {
                case 0: {
                    ++np;
                    break;
                }
                case 1: {
                    numrep = Integer.parseInt(piece);
                    if (numrep < 1) {
                        Utils.throwIOException("INCORRECT_NUMBER_OF_ENTRIES_REP_TABLE", new Object[0]);
                    }
                    this.reptable = new ReplEntry[numrep];
                    ++np;
                    break;
                }
            }
            ++i;
        }
        if (np != 2) {
            Utils.throwIOException("ERROR_MISSING_REP_TABLE", new Object[0]);
        }
        for (int j = 0; j < numrep; ++j) {
            tp = new StringTokenizer(af.readLine(), " ");
            i = 0;
            this.reptable[j] = new ReplEntry();
            this.reptable[j].pattern = null;
            this.reptable[j].replacement = null;
            while (tp.hasMoreTokens()) {
                piece = tp.nextToken();
                if (piece.length() == 0) continue;
                switch (i) {
                    case 0: {
                        if (piece.startsWith("REP")) break;
                        Utils.throwIOException("ERROR_REP_TABLE_CORRUPT", new Object[0]);
                        break;
                    }
                    case 1: {
                        this.reptable[j].pattern = piece;
                        break;
                    }
                    case 2: {
                        this.reptable[j].replacement = piece;
                        break;
                    }
                }
                ++i;
            }
            if (this.reptable[j].pattern != null && this.reptable[j].replacement != null) continue;
            Utils.throwIOException("ERROR_REP_TABLE_CORRUPT", new Object[0]);
        }
    }

    private void parse_maptable(String line, BufferedReader af) throws IOException {
        String piece;
        int nummap = this.get_nummap();
        if (nummap != 0) {
            Utils.throwIOException("ERROR_DUPLICATE_MAP", new Object[0]);
        }
        StringTokenizer tp = new StringTokenizer(line, " ");
        int i = 0;
        int np = 0;
        while (tp.hasMoreTokens()) {
            piece = tp.nextToken();
            if (piece.length() == 0) continue;
            switch (i) {
                case 0: {
                    ++np;
                    break;
                }
                case 1: {
                    nummap = Integer.parseInt(piece);
                    if (nummap < 1) {
                        Utils.throwIOException("ERROR_NUMBER_ENTRIES_MAP", new Object[0]);
                    }
                    this.maptable = new MapEntry[nummap];
                    ++np;
                    break;
                }
            }
            ++i;
        }
        if (np != 2) {
            Utils.throwIOException("ERROR_MISSING_MAP", new Object[0]);
        }
        for (int j = 0; j < nummap; ++j) {
            line = af.readLine();
            tp = new StringTokenizer(line, " ");
            i = 0;
            this.maptable[j] = new MapEntry();
            this.maptable[j].set = null;
            while (tp.hasMoreTokens()) {
                piece = tp.nextToken();
                if (piece.length() == 0) continue;
                switch (i) {
                    case 0: {
                        if (piece.startsWith("MAP")) break;
                        Utils.throwIOException("ERROR_MAP_CORRUPT", new Object[0]);
                        break;
                    }
                    case 1: {
                        this.maptable[j].set = piece;
                        break;
                    }
                }
                ++i;
            }
            if (this.maptable[j].set != null && this.maptable[j].set.length() != 0) continue;
            Utils.throwIOException("ERROR_MAP_CORRUPT", new Object[0]);
        }
    }

    private AffixHeader readAffxHeader(String line) throws IOException {
        AffixHeader result = new AffixHeader();
        StringTokenizer tp = new StringTokenizer(line, " ");
        try {
            result.type = tp.nextToken().charAt(0);
            result.achar = tp.nextToken().charAt(0);
            if (tp.nextToken().charAt(0) == 'Y') {
                result.ff = (short)Utils.XPRODUCT;
            }
            result.numents = Integer.parseInt(tp.nextToken());
        }
        catch (NoSuchElementException ex) {
            Utils.throwIOException("ERROR_AFFIX_HEADER", new Object[]{_Character.valueOf((char)result.achar), line});
        }
        return result;
    }

    private void parse_pfxaffix(String line, BufferedReader af) throws IOException {
        AffixHeader header = this.readAffxHeader(line);
        for (int j = 0; j < header.numents; ++j) {
            new PfxEntry(this, header, af.readLine());
        }
    }

    private void parse_sfxaffix(String line, BufferedReader af) throws IOException {
        AffixHeader header = this.readAffxHeader(line);
        for (int j = 0; j < header.numents; ++j) {
            new SfxEntry(this, header, af.readLine());
        }
    }

    void build_pfxlist(PfxEntry pfxptr) {
        List<PfxEntry> list = (ArrayList<PfxEntry>)this.prefixesByData.get(pfxptr.appnd);
        if (null == list) {
            list = new ArrayList<PfxEntry>();
            this.prefixesByData.put(pfxptr.appnd, list);
        }
        list.add(pfxptr);
        list = (List)this.prefixesByName.get(_Character.valueOf((char)pfxptr.achar));
        if (null == list) {
            list = new ArrayList();
            this.prefixesByName.put(_Character.valueOf((char)pfxptr.achar), list);
        }
        list.add(pfxptr);
    }

    void build_sfxlist(SfxEntry sfxptr) {
        List<SfxEntry> list = (ArrayList<SfxEntry>)this.suffixesByData.get(sfxptr.appnd);
        if (null == list) {
            list = new ArrayList<SfxEntry>();
            this.suffixesByData.put(sfxptr.appnd, list);
        }
        list.add(sfxptr);
        list = (List)this.suffixesByName.get(_Character.valueOf((char)sfxptr.achar));
        if (null == list) {
            list = new ArrayList();
            this.suffixesByName.put(_Character.valueOf((char)sfxptr.achar), list);
        }
        list.add(sfxptr);
    }
}

