/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell;

import java.util.List;
import java.util.ResourceBundle;
import net.sf.retrotranslator.runtime.java.lang._String;
import org.dts.spell.dictionary.SpellDictionary;
import org.dts.spell.event.SpellCheckEvent;
import org.dts.spell.finder.Word;

public class ErrorInfo {
    public static int MAX_SUGGESSTIONS = 4;
    private static String[] EMPTY_SUGGESTIONS = new String[0];
    private SuggestionsLoader loader;
    private Word badWord;
    private String description;
    private String[] suggestions;

    private ErrorInfo(SpellCheckEvent event) {
        this(event, null);
        this.loader = new SuggestionsLoader(event);
    }

    private ErrorInfo(SpellCheckEvent event, String description) {
        this.badWord = event.getCurrentWord();
        this.description = description;
        this.suggestions = null;
    }

    private ErrorInfo(SpellCheckEvent event, String description, String suggestion) {
        this.badWord = event.getCurrentWord();
        this.description = description;
        this.suggestions = new String[]{suggestion};
    }

    public Word getBadWord() {
        return this.badWord;
    }

    public String getDescription() {
        if (null == this.description) {
            this.description = this.loader.loadDescription();
        }
        return this.description;
    }

    public String[] getSuggestions() {
        if (null == this.suggestions && null != this.loader) {
            this.description = this.loader.load();
            this.loader = null;
        }
        return this.suggestions;
    }

    public static ErrorInfo getBadCaseErrorInfo(SpellCheckEvent event) {
        String word = event.getCurrentWord().getText();
        return new ErrorInfo(event, _String.format((String)ErrorInfo.getString("BAD_CASE_ERROR_INFO"), (Object[])new Object[]{word}), Word.getStartSentenceWordCase(word));
    }

    public static ErrorInfo getRepeatWordErrorInfo(SpellCheckEvent event) {
        return new ErrorInfo(event, _String.format((String)ErrorInfo.getString("REPEAT_WORD_ERROR_INFO"), (Object[])new Object[]{event.getCurrentWord()}));
    }

    public static ErrorInfo getSpellingErrorInfo(SpellCheckEvent event) {
        return new ErrorInfo(event);
    }

    private static String getString(String key) {
        return ResourceBundle.getBundle("org/dts/spell/messages").getString(key);
    }

    static /* synthetic */ String[] access$202(ErrorInfo x0, String[] x1) {
        x0.suggestions = x1;
        return x1;
    }

    private class SuggestionsLoader {
        private SpellDictionary dictionary;

        public SuggestionsLoader(SpellCheckEvent event) {
            this.dictionary = event.getDictionary();
        }

        public String load() {
            List suggentionList = this.dictionary.getSuggestions(ErrorInfo.this.badWord.getText(), MAX_SUGGESSTIONS);
            String result = !suggentionList.isEmpty() ? _String.format((String)ErrorInfo.getString("SPELL_ERROR_INFO"), (Object[])new Object[]{ErrorInfo.this.badWord, suggentionList.get(0)}) : _String.format((String)ErrorInfo.getString("SPELL_NO_SUGGESTIONS_ERROR_INFO"), (Object[])new Object[]{ErrorInfo.this.badWord});
            ErrorInfo.access$202(ErrorInfo.this, new String[suggentionList.size()]);
            suggentionList.subList(0, ErrorInfo.this.suggestions.length).toArray(ErrorInfo.this.suggestions);
            return result;
        }

        public String loadDescription() {
            List suggentionList = this.dictionary.getSuggestions(ErrorInfo.this.badWord.getText(), 1);
            String result = !suggentionList.isEmpty() ? _String.format((String)ErrorInfo.getString("SPELL_ERROR_INFO"), (Object[])new Object[]{ErrorInfo.this.badWord, suggentionList.get(0)}) : _String.format((String)ErrorInfo.getString("SPELL_NO_SUGGESTIONS_ERROR_INFO"), (Object[])new Object[]{ErrorInfo.this.badWord});
            return result;
        }
    }
}

