/*
 * Decompiled with CFR 0.152.
 */
package com.sslexplorer.vpn.util;

import com.sshtools.ui.awt.UIUtil;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;

public class ProgressBar {
    public final int BOXMSG_NONE = 0;
    public final int BOXMSG_PERCENT = 1;
    public final int BOXMSG_NUMBERS = 2;
    Frame parent;
    Window pbar;
    Label mess;
    ProgressBox pbox;
    Button cancel;
    long curVal;
    long maxVal;
    boolean shouldCancel = false;

    public ProgressBar(Component component, String string, String string2, long l) {
        this(component, string, string2, l, true);
    }

    public ProgressBar(Component component, String string, String string2, long l, boolean bl) {
        Serializable serializable;
        this.parent = UIUtil.getFrameAncestor(component);
        if (this.parent == null) {
            this.pbar = new Frame(string2);
        } else {
            if (!this.parent.isVisible()) {
                ((Component)this.parent).setVisible(true);
            }
            this.parent.toFront();
            this.pbar = new Dialog(this.parent, string2);
        }
        if (this.parent != null) {
            this.parent.addWindowListener(new WindowAdapter(){
                {
                    ProgressBar.this.getClass();
                }

                public void windowClosing(WindowEvent windowEvent) {
                    ((Component)ProgressBar.this.parent).hide();
                    ProgressBar.this.dispose();
                }
            });
        }
        Panel panel = new Panel(new FlowLayout(1, 1, 1));
        this.mess = new Label(string);
        panel.add(this.mess);
        this.pbar.add("North", panel);
        Panel panel2 = new Panel(new FlowLayout(1, 1, 1));
        this.pbox = new ProgressBox(l);
        panel2.add(this.pbox);
        this.pbar.add("Center", panel2);
        if (bl) {
            serializable = new Panel(new FlowLayout(1, 1, 1));
            this.cancel = new Button("Cancel");
            this.cancel.addActionListener(new ActionListener(){
                {
                    ProgressBar.this.getClass();
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ProgressBar.this.shouldCancel = true;
                }
            });
            ((Container)serializable).add(this.cancel);
            this.pbar.add("South", (Component)serializable);
        }
        serializable = this.pbar.getToolkit().getScreenSize();
        ((Component)this.pbar).setLocation(((Dimension)serializable).width / 3, ((Dimension)serializable).height / 3);
        this.pbar.pack();
        if (this.pbar instanceof Dialog) {
            ((Dialog)this.pbar).setResizable(false);
        } else {
            ((Frame)this.pbar).setResizable(false);
        }
        this.pbar.show();
        this.pbar.toFront();
    }

    public void setMessage(String string) {
        this.mess.setText(string);
    }

    public long getMaxValue() {
        return this.pbox.getMaxValue();
    }

    public void updateValue(long l) {
        this.pbox.updateValue(l);
    }

    public void setBarText(int n) {
        this.pbox.setBarMsg(n);
    }

    public void dispose() {
        try {
            this.pbar.dispose();
        }
        catch (Exception exception) {}
    }

    public void updateMaxValue(long l) {
        this.pbox.updateMaxValue(l);
    }

    public long getCurrentValue() {
        return this.pbox.getCurrentValue();
    }

    public boolean isCancelClicked() {
        return this.shouldCancel;
    }

    class ProgressBox
    extends Canvas {
        public final int MSG_NONE = 0;
        public final int MSG_PERCENT = 1;
        public final int MSG_NUMBERS = 2;
        private long maxVal;
        private long currentVal;
        private int cols;
        private int width;
        private int height;
        private int dispText;
        private Color barClr;
        private Color borderClr;
        private Color textClr;

        public void setBarMsg(int n) {
            this.dispText = n;
        }

        public ProgressBox(long l) {
            this(l, 40);
        }

        public ProgressBox(long l, int n) {
            ProgressBar.this.getClass();
            this.MSG_NONE = 0;
            this.MSG_PERCENT = 1;
            this.MSG_NUMBERS = 2;
            this.maxVal = l;
            this.currentVal = 0L;
            this.cols = n;
            this.dispText = 1;
            this.barClr = Color.decode("#D8DFEE");
            this.borderClr = Color.gray;
            this.textClr = Color.darkGray;
        }

        protected void measure() {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            if (fontMetrics == null) {
                return;
            }
            this.width = fontMetrics.stringWidth("X") * this.cols;
            this.height = fontMetrics.getHeight() + 4;
        }

        public void addNotify() {
            super.addNotify();
            this.measure();
        }

        public void paint(Graphics graphics) {
            graphics.setColor(this.barClr);
            if (this.currentVal > 0L && this.maxVal > 0L) {
                graphics.fillRect(0, 0, (int)(this.currentVal * (long)this.width / this.maxVal), this.height);
            }
            graphics.setColor(this.borderClr);
            graphics.drawRect(0, 0, this.width, this.height);
            graphics.setColor(this.textClr);
            if (this.dispText == 1) {
                if (this.currentVal > 0L && this.maxVal > 0L) {
                    this.centerText(String.valueOf((int)(this.currentVal * 100L / this.maxVal)) + "%", graphics, this.width, this.height);
                } else if (this.currentVal == 0L) {
                    this.centerText("0%", graphics, this.width, this.height);
                }
            } else if (this.dispText == 2) {
                this.centerText("(" + this.currentVal + " of " + this.maxVal + ")", graphics, this.width, this.height);
            }
        }

        public long getMaxValue() {
            return this.maxVal;
        }

        public void updateValue(long l) {
            this.currentVal = l;
            this.repaint();
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.width + 4, this.height + 4);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void setColors(Color color, Color color2, Color color3) {
            if (color != null) {
                this.barClr = color;
            }
            if (color2 != null) {
                this.borderClr = color2;
            }
            if (color3 != null) {
                this.textClr = color3;
            }
        }

        public void updateMaxValue(long l) {
            this.maxVal = l;
            this.repaint();
        }

        public long getCurrentValue() {
            return this.currentVal;
        }

        private void centerText(String string, Graphics graphics, int n, int n2) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            if (fontMetrics == null) {
                return;
            }
            int n3 = fontMetrics.stringWidth(string);
            int n4 = (n - n3) / 2;
            int n5 = (n2 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
            graphics.drawString(string, n4, n5);
        }
    }
}

