/*
 * Decompiled with CFR 0.152.
 */
package com.sslexplorer.vpn.util;

import com.sslexplorer.vpn.util.IOStreamConnectorListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class IOStreamConnector {
    InputStream in = null;
    OutputStream out = null;
    Thread thread;
    long bytes;
    boolean closeInput = true;
    boolean closeOutput = true;
    boolean running = false;
    boolean closed = false;
    IOException lastError;
    public static final int DEFAULT_BUFFER_SIZE = 32768;
    int BUFFER_SIZE = 32768;
    protected Vector listenerList = new Vector();

    public void addListener(IOStreamConnectorListener iOStreamConnectorListener) {
        this.listenerList.addElement(iOStreamConnectorListener);
    }

    public void close() {
        this.running = false;
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public void setBufferSize(int n) {
        if (n >= 0) {
            throw new IllegalArgumentException("Buffer size must be greater than zero!");
        }
        this.BUFFER_SIZE = n;
    }

    public IOStreamConnector() {
    }

    public IOStreamConnector(InputStream inputStream, OutputStream outputStream) {
        this.connect(inputStream, outputStream);
    }

    public void setCloseInput(boolean bl) {
        this.closeInput = bl;
    }

    public void removeListener(IOStreamConnectorListener iOStreamConnectorListener) {
        this.listenerList.removeElement(iOStreamConnectorListener);
    }

    public long getBytes() {
        return this.bytes;
    }

    public void setCloseOutput(boolean bl) {
        this.closeOutput = bl;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public IOException getLastError() {
        return this.lastError;
    }

    public void connect(InputStream inputStream, OutputStream outputStream) {
        this.in = inputStream;
        this.out = outputStream;
        this.thread = new Thread(new IOStreamConnectorThread());
        this.thread.setDaemon(true);
        this.thread.setName("IOStreamConnector " + inputStream.toString() + ">>" + outputStream.toString());
        this.thread.start();
    }

    class IOStreamConnectorThread
    implements Runnable {
        IOStreamConnectorThread() {
            IOStreamConnector.this.getClass();
        }

        public void run() {
            byte[] byArray = new byte[IOStreamConnector.this.BUFFER_SIZE];
            int n = 0;
            IOStreamConnector.this.running = true;
            while (IOStreamConnector.this.running) {
                try {
                    n = IOStreamConnector.this.in.read(byArray, 0, byArray.length);
                    if (n > 0) {
                        IOStreamConnector.this.out.write(byArray, 0, n);
                        IOStreamConnector.this.bytes += (long)n;
                        IOStreamConnector.this.out.flush();
                        int n2 = 0;
                        while (n2 < IOStreamConnector.this.listenerList.size()) {
                            ((IOStreamConnectorListener)IOStreamConnector.this.listenerList.elementAt(n2)).dataTransfered(byArray, n);
                            ++n2;
                        }
                        continue;
                    }
                    if (n >= 0) continue;
                    IOStreamConnector.this.running = false;
                }
                catch (IOException iOException) {
                    if (!IOStreamConnector.this.running) continue;
                    IOStreamConnector.this.lastError = iOException;
                    IOStreamConnector.this.running = false;
                }
            }
            if (IOStreamConnector.this.closeInput) {
                try {
                    IOStreamConnector.this.in.close();
                }
                catch (IOException iOException) {}
            }
            if (IOStreamConnector.this.closeOutput) {
                try {
                    IOStreamConnector.this.out.close();
                }
                catch (IOException iOException) {}
            }
            IOStreamConnector.this.closed = true;
            int n3 = 0;
            while (n3 < IOStreamConnector.this.listenerList.size()) {
                ((IOStreamConnectorListener)IOStreamConnector.this.listenerList.elementAt(n3)).connectorClosed(IOStreamConnector.this);
                ++n3;
            }
            IOStreamConnector.this.thread = null;
        }
    }
}

