/*
 * Decompiled with CFR 0.152.
 */
package com.sslexplorer.vpn.util;

import com.sslexplorer.vpn.util.ApplicationLauncherEvents;
import com.sslexplorer.vpn.util.ApplicationType;
import com.sslexplorer.vpn.util.Tunnel;
import com.sslexplorer.vpn.util.XMLElement;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;

public class ApplicationLauncher {
    File installDir;
    File sharedDir;
    String typeName;
    String name;
    String ticket;
    long totalBytesToDownload = 0L;
    Vector filesToDownload = new Vector();
    Hashtable sharedFilesToDowload = new Hashtable();
    String applicationStoreProtocol;
    String applicationStoreHost;
    String applicationStoreUser;
    int applicationStorePort;
    ApplicationLauncherEvents events;
    Hashtable parameters;
    Vector tunnels = new Vector();
    Hashtable descriptorParams = new Hashtable();
    boolean debug = false;
    String localProxyURL;
    ApplicationType type;
    int shortcutId;

    public int getApplicationStorePort() {
        return this.applicationStorePort;
    }

    private String replaceAllTokens(String string, String string2, String string3) {
        int n;
        do {
            if ((n = string.indexOf(string2)) <= -1) continue;
            string = string.substring(0, n) + string3 + (string.length() - n <= string2.length() ? "" : string.substring(n + string2.length()));
        } while (n > -1);
        return string;
    }

    public File addShared(XMLElement xMLElement) throws IOException {
        File file;
        if (!this.isSupportedPlatform((String)xMLElement.getAttribute("os"))) {
            return null;
        }
        String string = xMLElement.getContent();
        if (xMLElement.getAttribute("checksum") != null && xMLElement.getAttribute("size") != null) {
            String string2 = (String)xMLElement.getAttribute("checksum") + "." + (String)xMLElement.getAttribute("size") + "." + string;
            file = new File(this.sharedDir, string2);
            long l = Long.parseLong((String)xMLElement.getAttribute("checksum"));
            long l2 = Long.parseLong((String)xMLElement.getAttribute("size"));
            if (!file.exists()) {
                this.sharedFilesToDowload.put(string, string2);
                this.totalBytesToDownload += l2;
            } else {
                long l3 = this.generateChecksum(file);
                if (l3 != l || file.length() != l2) {
                    this.sharedFilesToDowload.put(string, string2);
                    this.totalBytesToDownload += file.length();
                }
            }
        } else {
            throw new IOException("Expected checksum and size for file object");
        }
        return file;
    }

    public ApplicationLauncher(String string, String string2, String string3, int n, Hashtable hashtable, ApplicationLauncherEvents applicationLauncherEvents) {
        this.applicationStoreProtocol = string;
        this.applicationStoreHost = string3;
        this.applicationStoreUser = string2;
        this.applicationStorePort = n;
        this.parameters = hashtable;
        this.events = applicationLauncherEvents;
    }

    public void prepare() throws IOException {
        Object object;
        if (this.events != null) {
            this.events.debug("Checking parameters");
        }
        if (!this.parameters.containsKey("name")) {
            throw new IOException("name is a required parameter");
        }
        if (!this.parameters.containsKey("ticket")) {
            throw new IOException("ticket is a required parameter");
        }
        if (this.debug) {
            this.parameters.put("debug", "true");
        }
        if (this.events != null) {
            this.events.debug("Creating URL query string");
        }
        Enumeration enumeration = this.parameters.keys();
        String string = "";
        if (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            string = "?" + (String)object + "=" + URLEncoder.encode((String)this.parameters.get(object));
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                string = string + "&" + (String)object + "=" + URLEncoder.encode((String)this.parameters.get(object));
            }
        }
        this.shortcutId = this.parameters.contains("id") ? Integer.parseInt((String)this.parameters.get("id")) : -1;
        this.ticket = (String)this.parameters.get("ticket");
        if (this.events != null) {
            this.events.debug("Storing ticket " + this.ticket);
        }
        object = new URL(this.applicationStoreProtocol, this.applicationStoreHost, this.applicationStorePort, "/getApplication.do" + string);
        if (this.events != null) {
            this.events.debug("Opening URL " + ((URL)object).toExternalForm());
        }
        URLConnection uRLConnection = ((URL)object).openConnection();
        XMLElement xMLElement = new XMLElement();
        xMLElement.parseFromReader(new InputStreamReader(uRLConnection.getInputStream()));
        if (this.events != null) {
            this.events.debug("Received a response from server");
        }
        if (!xMLElement.getName().equals("application") && !xMLElement.getName().equals("error")) {
            throw new IOException("URL " + ((URL)object).toExternalForm() + " does not point to an application descriptor");
        }
        if (xMLElement.getName().equals("error")) {
            throw new IOException(xMLElement.getContent());
        }
        this.name = (String)xMLElement.getAttribute("application");
        this.typeName = (String)xMLElement.getAttribute("type");
        try {
            this.type = (ApplicationType)Class.forName("com.sslexplorer.vpn.util.types." + String.valueOf(this.typeName.charAt(0)).toUpperCase() + this.typeName.substring(1) + "ApplicationType").newInstance();
        }
        catch (Throwable throwable) {
            throw new IOException("Failed to load the application description extension for application type of " + this.typeName + ".");
        }
        if (this.events != null) {
            this.events.debug("Application name is " + this.name);
        }
        if (this.events != null) {
            this.events.processingDescriptor();
        }
        if (this.events != null) {
            this.events.debug("Creating install folder");
        }
        if (this.events != null) {
            this.events.debug("User home is " + System.getProperty("user.home"));
        }
        this.installDir = new File(System.getProperty("user.home"), ".sslexplorer" + File.separator + "applications" + File.separator + this.name);
        this.sharedDir = new File(System.getProperty("user.home"), ".sslexplorer/shared");
        if (!this.installDir.exists()) {
            this.installDir.mkdirs();
        }
        if (!this.sharedDir.exists()) {
            this.sharedDir.mkdirs();
        }
        if (this.events != null) {
            this.events.debug("Installing to " + this.installDir.getAbsolutePath());
        }
        Enumeration enumeration2 = xMLElement.enumerateChildren();
        while (enumeration2.hasMoreElements()) {
            XMLElement xMLElement2 = (XMLElement)enumeration2.nextElement();
            if (xMLElement2.getName().equalsIgnoreCase("files")) {
                this.processFiles(xMLElement2);
                continue;
            }
            if (xMLElement2.getName().equalsIgnoreCase("tunnel")) {
                this.createTunnel(xMLElement2);
                continue;
            }
            if (xMLElement2.getName().equalsIgnoreCase("parameter")) {
                this.addParameter(xMLElement2);
                continue;
            }
            if (xMLElement2.getName().equalsIgnoreCase("messages") || xMLElement2.getName().equalsIgnoreCase("description")) continue;
            this.type.prepare(this, this.events, xMLElement2);
        }
        this.downloadFiles();
    }

    public File addFile(XMLElement xMLElement) throws IOException {
        if (!this.isSupportedPlatform((String)xMLElement.getAttribute("os"))) {
            return null;
        }
        String string = xMLElement.getContent();
        File file = new File(this.installDir, string);
        long l = Long.parseLong((String)xMLElement.getAttribute("size"));
        if (this.events != null) {
            this.events.debug("Adding file " + file.getAbsolutePath() + " (" + l + ")");
        }
        if (xMLElement.getAttribute("checksum") == null || xMLElement.getAttribute("size") == null) {
            throw new IOException("Expected checksum and size for file object");
        }
        if (file.exists()) {
            long l2 = Long.parseLong((String)xMLElement.getAttribute("checksum"));
            long l3 = this.generateChecksum(file);
            if (this.events != null) {
                this.events.debug("File exists - current checksum = " + l3 + ", files checksum = " + l2);
            }
            if (l3 != l2 || file.length() != l) {
                if (this.events != null) {
                    this.events.debug("Checksum mismatch, downloading");
                }
                this.filesToDownload.addElement(string);
                this.totalBytesToDownload += file.length();
            }
        } else {
            if (this.events != null) {
                this.events.debug("File doesn't exists downloading");
            }
            this.filesToDownload.addElement(string);
            this.totalBytesToDownload += l;
        }
        return file;
    }

    public int getShortcutId() {
        return this.shortcutId;
    }

    private void addParameter(XMLElement xMLElement) throws IOException {
        String string = (String)xMLElement.getAttribute("name");
        String string2 = (String)xMLElement.getAttribute("value");
        this.descriptorParams.put(string, string2);
    }

    private boolean isSupportedPlatform(String string) {
        if (string != null) {
            String string2 = System.getProperty("os.name").toUpperCase();
            return string2.startsWith(string.toUpperCase());
        }
        return true;
    }

    public void setLocalProxyURL(String string) {
        this.localProxyURL = string;
    }

    public String replaceTokens(String string) {
        String string2;
        Object object;
        string = this.replaceAllTokens(string, "${client:installDir}", this.installDir.getAbsolutePath());
        string = this.replaceAllTokens(string, "${sslexplorer:user}", this.applicationStoreUser == null ? "" : this.applicationStoreUser);
        string = this.replaceAllTokens(string, "${sslexplorer:host}", this.applicationStoreHost == null ? "" : this.applicationStoreHost);
        string = this.replaceAllTokens(string, "${sslexplorer:port}", this.applicationStorePort == -1 ? "" : String.valueOf(this.applicationStorePort));
        string = this.replaceAllTokens(string, "${sslexplorer:protocol}", this.applicationStoreProtocol == null ? "" : this.applicationStoreProtocol);
        string = this.replaceAllTokens(string, "${client:localProxyURL}", this.localProxyURL == null ? "" : this.localProxyURL);
        Enumeration<Object> enumeration = this.descriptorParams.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            string2 = (String)this.descriptorParams.get(object);
            string = this.replaceAllTokens(string, "${param:" + (String)object + "}", string2);
        }
        enumeration = this.tunnels.elements();
        while (enumeration.hasMoreElements()) {
            object = (Tunnel)enumeration.nextElement();
            string2 = "${tunnel:" + object.getName() + ".hostname}";
            String string3 = "${tunnel:" + object.getName() + ".port}";
            string = this.replaceAllTokens(string, string2, "localhost");
            string = this.replaceAllTokens(string, string3, String.valueOf(object.getSourcePort()));
        }
        return string;
    }

    public static int[] getVersion(String string) {
        int n = 0;
        int n2 = 0;
        int[] nArray = new int[]{};
        do {
            int n3;
            if ((n = string.indexOf(46, n2)) > -1) {
                n3 = Integer.parseInt(string.substring(n2, n));
                n2 = n + 1;
            } else {
                try {
                    int n4 = string.indexOf(95, n2);
                    if (n4 == -1) {
                        n4 = string.indexOf(45, n2);
                    }
                    n3 = n4 > -1 ? Integer.parseInt(string.substring(n2, n4)) : Integer.parseInt(string.substring(n2));
                }
                catch (NumberFormatException numberFormatException) {
                    break;
                }
            }
            int[] nArray2 = new int[nArray.length + 1];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            nArray2[nArray2.length - 1] = n3;
            nArray = nArray2;
        } while (n > -1);
        return nArray;
    }

    public String getApplicationStoreHost() {
        return this.applicationStoreHost;
    }

    private long generateChecksum(File file) throws IOException {
        int n;
        Adler32 adler32 = new Adler32();
        CheckedInputStream checkedInputStream = new CheckedInputStream(new FileInputStream(file), adler32);
        byte[] byArray = new byte[4096];
        while ((n = checkedInputStream.read(byArray)) > -1) {
        }
        adler32 = (Adler32)checkedInputStream.getChecksum();
        return adler32.getValue();
    }

    public Hashtable getDescriptorParams() {
        return this.descriptorParams;
    }

    public void start() {
        this.type.start();
    }

    private void downloadFiles() throws IOException {
        String string;
        if (this.events != null) {
            this.events.debug("Downloading files");
        }
        if (this.events != null) {
            this.events.startDownload(this.totalBytesToDownload);
        }
        long l = 0L;
        int n = 0;
        while (n < this.filesToDownload.size()) {
            string = (String)this.filesToDownload.elementAt(n);
            l = this.downloadFile(this.installDir, string, string, l);
            ++n;
        }
        Enumeration enumeration = this.sharedFilesToDowload.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            String string2 = (String)this.sharedFilesToDowload.get(string);
            l = this.downloadFile(this.sharedDir, string, string2, l);
        }
        if (this.events != null) {
            this.events.completedDownload();
        }
        if (this.events != null) {
            this.events.debug("Completed downloading files");
        }
    }

    public ApplicationType getApplicationType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public File getInstallDir() {
        return this.installDir;
    }

    public String getApplicationStoreProtocol() {
        return this.applicationStoreProtocol;
    }

    private void processFiles(XMLElement xMLElement) throws IOException {
        Enumeration enumeration = xMLElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
            if (xMLElement2.getName().equalsIgnoreCase("file")) {
                this.addFile(xMLElement2);
                continue;
            }
            if (xMLElement2.getName().equalsIgnoreCase("if")) {
                try {
                    if (!this.type.checkFileCondition(xMLElement2)) continue;
                    this.processFiles(xMLElement2);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    String string = (String)xMLElement2.getAttribute("parameter");
                    if (string != null) {
                        String string2 = (String)xMLElement2.getAttribute("value");
                        boolean bl = "true".equalsIgnoreCase((String)xMLElement2.getAttribute("not"));
                        String string3 = (String)this.descriptorParams.get(string);
                        if ((bl || !string2.equalsIgnoreCase(string3)) && (!bl || string2.equalsIgnoreCase(string3))) continue;
                        this.processFiles(xMLElement2);
                        continue;
                    }
                    throw new IOException("<if> element requires type specific attributes or parameter/value attributes");
                }
            }
            throw new IOException("Invalid element <" + xMLElement2.getName() + "> found in <files>");
        }
    }

    private boolean isArgument(XMLElement xMLElement) {
        return xMLElement.getName().equalsIgnoreCase("arg") || xMLElement.getName().equalsIgnoreCase("jvm");
    }

    private void createTunnel(XMLElement xMLElement) throws IOException {
        Tunnel tunnel;
        boolean bl;
        String string = (String)xMLElement.getAttribute("hostname");
        String string2 = (String)xMLElement.getAttribute("name");
        int n = Integer.parseInt((String)xMLElement.getAttribute("port"));
        boolean bl2 = bl = !"false".equals(xMLElement.getAttribute("usePreferredPort"));
        if (this.events != null) {
            tunnel = this.events.createTunnel(string2, string, n, bl);
            if (tunnel == null) {
                throw new IOException("Failed to create a required tunnel to " + string + ":" + n);
            }
        } else {
            throw new IOException("Tunnel required but no event handler is available");
        }
        this.tunnels.addElement(tunnel);
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public Vector getTunnels() {
        return this.tunnels;
    }

    private long downloadFile(File file, String string, String string2, long l) throws IOException {
        int n;
        Object object;
        if (this.events != null) {
            this.events.debug("Downloading " + string + " to " + file.getAbsolutePath() + "/" + string2);
        }
        File file2 = new File(file, string2);
        URL uRL = new URL(this.applicationStoreProtocol, this.applicationStoreHost, this.applicationStorePort, "/getApplicationFile.do?name=" + this.name + "&ticket=" + this.ticket + "&file=" + string);
        if (this.events != null) {
            this.events.debug("Request application using " + uRL.toExternalForm());
        }
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setUseCaches(false);
        try {
            object = uRLConnection.getClass().getMethod("setConnectTimeout", Integer.TYPE);
            if (this.events != null) {
                this.events.debug("Using a 1.5 runtime, so setting connection and read timeout to 20 seconds");
            }
            ((Method)object).invoke((Object)uRLConnection, new Integer(20000));
            object = uRLConnection.getClass().getMethod("setReadTimeout", Integer.TYPE);
            ((Method)object).invoke((Object)uRLConnection, new Integer(20000));
        }
        catch (Throwable throwable) {}
        object = new File(file2.getParent());
        ((File)object).mkdirs();
        if (this.events != null) {
            this.events.debug("Creating " + file2.getAbsolutePath());
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        InputStream inputStream = uRLConnection.getInputStream();
        byte[] byArray = new byte[16384];
        while ((n = inputStream.read(byArray)) > -1) {
            fileOutputStream.write(byArray, 0, n);
            l += (long)n;
            if (this.events == null) continue;
            this.events.progressedDownload(l);
        }
        if (this.events != null) {
            this.events.debug("Finshing download file.");
        }
        inputStream.close();
        fileOutputStream.close();
        return l;
    }

    public static boolean checkVersion(String string) {
        int[] nArray = ApplicationLauncher.getVersion(string);
        int[] nArray2 = ApplicationLauncher.getVersion(System.getProperty("java.version"));
        int n = 0;
        while (n < nArray.length && n < nArray2.length) {
            if (nArray[n] > nArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

