/*
 * Decompiled with CFR 0.152.
 */
package com.sslexplorer.vpn.base;

import com.sslexplorer.vpn.base.AbstractVPNClient;
import com.sslexplorer.vpn.base.VPNTCPTunnel;
import com.sslexplorer.vpn.base.VPNTunnel;
import com.sslexplorer.vpn.base.VPNTunnelListener;
import com.sslexplorer.vpn.base.VPNUDPTunnel;
import com.sslexplorer.vpn.util.IOStreamConnectorListener;
import com.sslexplorer.vpn.util.Tunnel;
import com.sslexplorer.vpn.util.XMLElement;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VPNConnectionListener
implements Runnable {
    AbstractVPNClient vpn;
    ServerSocket server;
    Thread thread;
    boolean listening;
    Vector activeTunnels;
    TunnelListener listener;
    IOStreamConnectorListener txListener;
    IOStreamConnectorListener rxListener;
    String ticket;
    Tunnel tunnel;
    int id;
    long dataLastTransferred;
    int datagramLength = 65536;
    byte[] datagramBuffer;
    VPNUDPTunnel udpTunnel;
    DatagramSocket datagramSocket;
    boolean stopping;
    static Log log = LogFactory.getLog((Class)(class$com$sslexplorer$vpn$base$VPNConnectionListener != null ? class$com$sslexplorer$vpn$base$VPNConnectionListener : (class$com$sslexplorer$vpn$base$VPNConnectionListener = VPNConnectionListener.class$("com.sslexplorer.vpn.base.VPNConnectionListener"))));
    private static /* synthetic */ Class class$com$sslexplorer$vpn$base$VPNConnectionListener;

    public int getId() {
        return this.id;
    }

    public void stop() {
        try {
            this.stopping = true;
            log.info((Object)("Closing " + (this.tunnel.isPermanent() ? "permanent" : "temporary") + " listener on " + this.getAddressToBind() + ":" + this.tunnel.getSourcePort()));
            if (this.server != null) {
                this.server.close();
            }
            Vector vector = this.activeTunnels;
            synchronized (vector) {
                Enumeration enumeration = this.activeTunnels.elements();
                while (enumeration.hasMoreElements()) {
                    ((VPNTunnel)enumeration.nextElement()).stop();
                }
                Object var3_3 = null;
            }
        }
        catch (IOException iOException) {}
        this.unregisterListeningSocket();
        this.server = null;
        this.listening = false;
    }

    public boolean isListening() {
        return this.listening;
    }

    public VPNConnectionListener(AbstractVPNClient abstractVPNClient, IOStreamConnectorListener iOStreamConnectorListener, IOStreamConnectorListener iOStreamConnectorListener2, Tunnel tunnel) {
        this.vpn = abstractVPNClient;
        this.tunnel = tunnel;
        this.txListener = iOStreamConnectorListener;
        this.rxListener = iOStreamConnectorListener2;
        this.listener = new TunnelListener();
        this.activeTunnels = new Vector();
        this.dataLastTransferred = System.currentTimeMillis();
    }

    String getAddressToBind() {
        if (this.tunnel.isAllowExternalHosts()) {
            return "0.0.0.0";
        }
        return "127.0.0.1";
    }

    public long getDataLastTransferredTime() {
        return this.dataLastTransferred;
    }

    public Tunnel getTunnel() {
        return this.tunnel;
    }

    void tunnelTCP() {
        Socket socket = null;
        try {
            block11: {
                try {
                    this.listening = true;
                    while (this.listening) {
                        socket = this.server.accept();
                        if (!this.listening || socket == null) break;
                        log.info((Object)("Tunneling request received for " + this.getAddressToBind() + ":" + this.tunnel.getSourcePort()));
                        try {
                            VPNTCPTunnel vPNTCPTunnel = new VPNTCPTunnel(this.vpn.createTunnel(this.tunnel), socket, this.tunnel.getDestinationHost(), this.tunnel.getDestinationPort(), this.txListener, this.rxListener);
                            vPNTCPTunnel.addListener(this.listener);
                            vPNTCPTunnel.start();
                        }
                        catch (Throwable throwable) {
                            log.info((Object)"Failed to connect tunneling request", throwable);
                            try {
                                socket.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (this.tunnel.isPermanent() || !this.tunnel.isTemporarySingleConnect()) continue;
                        log.info((Object)"Not accepting any more connections as this is a temporary tunnel.");
                        break;
                    }
                }
                catch (Throwable throwable) {
                    if (this.stopping) break block11;
                    log.info((Object)"The connection listener thread failed", throwable);
                }
            }
            Object var4_5 = null;
            if (!(!this.tunnel.isPermanent() && this.tunnel.isTemporarySingleConnect() || this.stopping)) {
                this.vpn.stopListeningSocket(this.getTicket());
            }
            this.stopping = false;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (!(!this.tunnel.isPermanent() && this.tunnel.isTemporarySingleConnect() || this.stopping)) {
                this.vpn.stopListeningSocket(this.getTicket());
            }
            this.stopping = false;
            throw throwable;
        }
    }

    public void start() throws IOException {
        this.dataLastTransferred = System.currentTimeMillis();
        log.info((Object)("Starting " + (this.tunnel.isPermanent() ? "permanent" : "temporary") + " VPN connection listener on port " + this.tunnel.getSourcePort()));
        if (this.tunnel.getTransport().equals("udp")) {
            log.info((Object)("UDP socket created on " + InetAddress.getByName(this.getAddressToBind()) + ":" + this.tunnel.getSourcePort()));
            this.datagramSocket = new DatagramSocket(this.tunnel.getSourcePort());
        } else {
            log.info((Object)("TCP socket created on " + InetAddress.getByName(this.getAddressToBind()) + ":" + this.tunnel.getSourcePort()));
            this.server = new ServerSocket(this.tunnel.getSourcePort(), 50, InetAddress.getByName(this.getAddressToBind()));
        }
        XMLElement xMLElement = null;
        try {
            xMLElement = this.vpn.registerListeningSocket(true, this.tunnel);
        }
        catch (Exception exception) {
            throw new IOException("Failed to register tunnel. " + exception.getMessage());
        }
        if (xMLElement != null) {
            this.ticket = xMLElement.getStringAttribute("ticket");
            this.tunnel.setTicket(this.ticket);
            this.id = xMLElement.getIntAttribute("id");
            log.info((Object)"Registration complete");
            this.thread = new Thread(this);
            this.thread.setDaemon(true);
            this.thread.setName("SocketListener " + this.getAddressToBind() + ":" + String.valueOf(this.tunnel.getSourcePort()));
            this.thread.start();
        } else {
            log.info((Object)"Failed to register tunnel with server");
            this.vpn.stopListeningSocket(this.getTicket());
        }
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    void tunnelUDP() {
        try {
            try {
                VPNUDPTunnel vPNUDPTunnel = new VPNUDPTunnel(this.vpn, this.tunnel.getSourcePort(), this.vpn.createTunnel(this.tunnel), this.datagramSocket, this.tunnel.getDestinationHost(), this.tunnel.getDestinationPort(), this.txListener, this.rxListener);
                vPNUDPTunnel.addListener(this.listener);
                vPNUDPTunnel.start();
            }
            catch (Throwable throwable) {
                log.info((Object)"Failed to connect tunneling request", throwable);
            }
            Object var3_3 = null;
            this.vpn.stopListeningSocket(this.getTicket());
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.vpn.stopListeningSocket(this.getTicket());
            throw throwable;
        }
    }

    public void run() {
        if (this.tunnel.getTransport().equals("udp")) {
            this.tunnelUDP();
        } else {
            this.tunnelTCP();
        }
    }

    boolean unregisterListeningSocket() {
        try {
            URL uRL = new URL("https://" + this.vpn.getSSLExplorerHost() + ":" + this.vpn.getSSLExplorerPort() + "/unregisterListeningSocket.do" + "?tunnel=" + this.ticket + "&ticket=" + this.vpn.getTicket());
            URLConnection uRLConnection = uRL.openConnection();
            XMLElement xMLElement = new XMLElement();
            xMLElement.parseFromReader(new InputStreamReader(uRLConnection.getInputStream()));
            return xMLElement.getName().equalsIgnoreCase("success");
        }
        catch (MalformedURLException malformedURLException) {
            log.info((Object)"Failed to construct url", (Throwable)malformedURLException);
        }
        catch (Throwable throwable) {
            log.info((Object)"Failed to connect url", throwable);
        }
        return false;
    }

    public String getTicket() {
        return this.ticket;
    }

    public boolean isRunning() {
        return this.thread != null && this.thread.isAlive();
    }

    public int getLocalPort() {
        if (this.server == null) {
            return this.datagramSocket == null ? -1 : this.datagramSocket.getLocalPort();
        }
        return this.server.getLocalPort();
    }

    class TunnelListener
    implements VPNTunnelListener {
        public void stopped(VPNTunnel vPNTunnel) {
            Vector vector = VPNConnectionListener.this.activeTunnels;
            synchronized (vector) {
                block4: {
                    VPNConnectionListener.this.activeTunnels.removeElement(vPNTunnel);
                    VPNConnectionListener.this.vpn.unregisterForwardingTunnel(vPNTunnel);
                    log.info((Object)("User on " + vPNTunnel.getClientHost() + " has closed the tunnel to " + vPNTunnel.getDestinationHost() + ":" + vPNTunnel.getDestinationPort()));
                    if (!VPNConnectionListener.this.tunnel.isPermanent() && VPNConnectionListener.this.tunnel.isTemporarySingleConnect()) {
                        log.info((Object)"Closing listener as this is a temporary tunnel");
                        VPNConnectionListener.this.vpn.stopListeningSocket(VPNConnectionListener.this.getTicket());
                        VPNConnectionListener.this.thread = null;
                        break block4;
                    }
                    log.info((Object)"Not closing listener as this is not a temporary tunnel");
                }
                Object var3_3 = null;
            }
        }

        TunnelListener() {
            VPNConnectionListener.this.getClass();
        }

        public void started(VPNTunnel vPNTunnel) {
            Vector vector = VPNConnectionListener.this.activeTunnels;
            synchronized (vector) {
                VPNConnectionListener.this.activeTunnels.addElement(vPNTunnel);
                VPNConnectionListener.this.vpn.registerForwardingTunnel(vPNTunnel);
                log.info((Object)("User on " + vPNTunnel.getClientHost() + " has opened a tunnel to " + vPNTunnel.getDestinationHost() + ":" + vPNTunnel.getDestinationPort()));
                Object var3_3 = null;
            }
        }

        public void dataTransferred(VPNTunnel vPNTunnel, byte[] byArray, int n) {
            VPNConnectionListener.this.dataLastTransferred = System.currentTimeMillis();
        }
    }
}

