/*
 * Decompiled with CFR 0.152.
 */
package com.sslexplorer.vpn.base;

import com.maverick.crypto.security.SecureRandom;
import com.maverick.http.ConnectMethod;
import com.maverick.http.HttpClient;
import com.maverick.http.HttpException;
import com.maverick.http.HttpResponse;
import com.maverick.http.PasswordCredentials;
import com.maverick.http.UnsupportedAuthenticationException;
import com.sslexplorer.vpn.base.DefaultTunnel;
import com.sslexplorer.vpn.base.VPNConnectionListener;
import com.sslexplorer.vpn.base.VPNTunnel;
import com.sslexplorer.vpn.util.IOStreamConnectorListener;
import com.sslexplorer.vpn.util.Tunnel;
import com.sslexplorer.vpn.util.URI;
import com.sslexplorer.vpn.util.XMLElement;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractVPNClient {
    public final int LOWEST_RANDOM_PORT = 49152;
    public final int HIGHEST_RANDOM_PORT = 65535;
    protected Hashtable activeListeners = new Hashtable();
    protected String sslexplorerHostname;
    protected int sslexplorerPort;
    protected String username;
    protected String ticket;
    protected URI localProxyURL;
    protected Vector activeApplicationTunnels = new Vector();
    protected Vector forwardingTunnels = new Vector();
    protected Vector activeForwardingTunnels = new Vector();
    protected Hashtable activeDirectTunnels = new Hashtable();
    Log log = LogFactory.getLog((Class)(class$com$sslexplorer$vpn$base$AbstractVPNClient != null ? class$com$sslexplorer$vpn$base$AbstractVPNClient : (class$com$sslexplorer$vpn$base$AbstractVPNClient = AbstractVPNClient.class$("com.sslexplorer.vpn.base.AbstractVPNClient"))));
    private static /* synthetic */ Class class$com$sslexplorer$vpn$base$AbstractVPNClient;

    public abstract IOStreamConnectorListener getTXIOListener();

    public abstract IOStreamConnectorListener getRXIOListener();

    public XMLElement registerListeningSocket(boolean bl, Tunnel tunnel) throws Exception {
        URL uRL = new URL("https://" + this.getSSLExplorerHost() + ":" + this.getSSLExplorerPort() + "/registerListeningSocket.do" + "?ticket=" + this.getTicket() + "&start=" + bl + (tunnel.getId() == -1 ? "&sourcePort=" + tunnel.getSourcePort() + "&destinationHost=" + tunnel.getDestinationHost() + "&destinationPort=" + tunnel.getDestinationPort() + "&allowExternalHosts=" + String.valueOf(tunnel.isAllowExternalHosts()) + "&permanent=" + String.valueOf(tunnel.isPermanent()) + "&autoStart=" + String.valueOf(tunnel.isAutoStart()) + "&permissionId=" + (tunnel.getPermissionId() == null ? "" : tunnel.getPermissionId()) + "&transport=" + tunnel.getTransport() : "&id=" + tunnel.getId()));
        this.log.info((Object)("Registering tunnel with URL " + uRL.toExternalForm()));
        URLConnection uRLConnection = uRL.openConnection();
        XMLElement xMLElement = new XMLElement();
        xMLElement.parseFromReader(new InputStreamReader(uRLConnection.getInputStream()));
        if (xMLElement.getName().equalsIgnoreCase("success")) {
            return xMLElement;
        }
        throw new Exception(xMLElement.getContent());
    }

    public Tunnel registerApplicationTunnel(String string, String string2, int n) throws IOException {
        this.log.info((Object)("Registering application tunnel " + string + " host=" + string2 + ":" + n));
        URL uRL = new URL("https://" + this.sslexplorerHostname + ":" + this.sslexplorerPort + "/registerListeningSocket.do" + "?sourcePort=" + n + "&destinationHost=" + string2 + "&destinationPort=" + n + "&allowExternalHosts=false" + "&ticket=" + this.ticket);
        URLConnection uRLConnection = uRL.openConnection();
        XMLElement xMLElement = new XMLElement();
        xMLElement.parseFromReader(new InputStreamReader(uRLConnection.getInputStream()));
        if (xMLElement.getName().equalsIgnoreCase("success")) {
            DefaultTunnel defaultTunnel = new DefaultTunnel(-1, 0, false, "tcp", this.username, n, n, string2, false, false, true, "", string);
            defaultTunnel.setTicket(xMLElement.getContent());
            this.activeDirectTunnels.put(defaultTunnel.getDestinationHost() + ":" + defaultTunnel.getDestinationPort(), defaultTunnel);
            return defaultTunnel;
        }
        throw new IOException("The server failed to register the application tunnel named " + string + " " + xMLElement.getContent());
    }

    public int getSSLExplorerPort() {
        return this.sslexplorerPort;
    }

    public VPNConnectionListener startListeningSocket(Tunnel tunnel) throws IOException {
        VPNConnectionListener vPNConnectionListener = new VPNConnectionListener(this, this.getTXIOListener(), this.getRXIOListener(), tunnel);
        vPNConnectionListener.start();
        this.activeListeners.put(vPNConnectionListener.getTicket(), vPNConnectionListener);
        return vPNConnectionListener;
    }

    protected void stopListeningSocket(String string) {
        this.log.info((Object)("Removing VPN connection listener with ticket " + string));
        VPNConnectionListener vPNConnectionListener = (VPNConnectionListener)this.activeListeners.get(string);
        if (vPNConnectionListener == null) {
            this.log.error((Object)("No VPN connection listener with ticket " + string));
        } else {
            vPNConnectionListener.stop();
            this.activeListeners.remove(string);
        }
    }

    protected static Properties getSystemPropertiesToSend() {
        Properties properties = new Properties();
        AbstractVPNClient.setIfNotEmpty("java.version", properties);
        AbstractVPNClient.setIfNotEmpty("java.vendor", properties);
        AbstractVPNClient.setIfNotEmpty("sun.os.patch.level", properties);
        AbstractVPNClient.setIfNotEmpty("os.name", properties);
        AbstractVPNClient.setIfNotEmpty("os.version", properties);
        AbstractVPNClient.setIfNotEmpty("os.arch", properties);
        return properties;
    }

    public void setLocalProxyURL(String string) throws URI.MalformedURIException {
        this.localProxyURL = new URI(string);
    }

    public String getUsername() {
        return this.username;
    }

    protected static void setIfNotEmpty(String string, Properties properties) {
        String string2 = System.getProperty(string);
        if (string2 != null && !string2.equals("")) {
            ((Hashtable)properties).put(string, string2);
        }
    }

    protected Tunnel getPersistantForwardingTunnel(int n) {
        Enumeration enumeration = this.forwardingTunnels.elements();
        while (enumeration.hasMoreElements()) {
            Tunnel tunnel = (Tunnel)enumeration.nextElement();
            if (tunnel.getId() != n) continue;
            return tunnel;
        }
        return null;
    }

    protected boolean startForwardingTunnels() throws IOException {
        Enumeration enumeration = this.forwardingTunnels.elements();
        while (enumeration.hasMoreElements()) {
            Tunnel tunnel = (Tunnel)enumeration.nextElement();
            if (!tunnel.isAutoStart()) continue;
            this.createPermanentListeningSocket(tunnel);
        }
        return true;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public String getSSLExplorerHost() {
        return this.sslexplorerHostname;
    }

    protected static String obfuscateURL(String string) {
        try {
            URI uRI = new URI(string);
            String string2 = uRI.getUserinfo();
            String string3 = "";
            if (string2 != null && !string2.equals("")) {
                int n = string2.indexOf(58);
                string3 = string2;
                if (n != -1) {
                    string3 = string2.substring(0, n);
                }
                return uRI.getScheme() + "://" + string3 + ":***@" + uRI.getHost() + ":" + uRI.getPort();
            }
            return string;
        }
        catch (URI.MalformedURIException malformedURIException) {
            return string;
        }
    }

    public void init(String string, int n, String string2, String string3) {
        this.sslexplorerHostname = string;
        this.sslexplorerPort = n;
        this.username = string2;
        this.ticket = string3;
    }

    public String getTicket() {
        return this.ticket;
    }

    protected void unregisterForwardingTunnel(VPNTunnel vPNTunnel) {
        this.activeForwardingTunnels.removeElement(vPNTunnel);
    }

    public VPNConnectionListener createPermanentListeningSocket(Tunnel tunnel) {
        try {
            this.log.info((Object)("Attempting to create a listening socket for " + tunnel.getDestinationHost() + ":" + tunnel.getDestinationPort() + " on the port " + tunnel.getSourcePort()));
            return this.startListeningSocket(tunnel);
        }
        catch (IOException iOException) {
            this.log.info((Object)"Failed to start listening socket", (Throwable)iOException);
            return null;
        }
    }

    protected boolean retrievePersistantForwardingTunnels() throws IOException {
        URL uRL = new URL("https://" + this.sslexplorerHostname + ":" + this.sslexplorerPort + "/getTunnels.do" + "?ticket=" + this.ticket);
        URLConnection uRLConnection = uRL.openConnection();
        XMLElement xMLElement = new XMLElement();
        xMLElement.parseFromReader(new InputStreamReader(uRLConnection.getInputStream()));
        if (xMLElement.getName().equals("tunnels")) {
            this.forwardingTunnels.removeAllElements();
            this.log.info((Object)"Looking for tunnels to open");
            Enumeration enumeration = xMLElement.enumerateChildren();
            while (enumeration.hasMoreElements()) {
                XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
                if (xMLElement2.getName().equals("tunnel")) {
                    int n = xMLElement2.getIntAttribute("id");
                    int n2 = xMLElement2.getIntAttribute("type");
                    boolean bl = xMLElement2.getBooleanAttribute("autoStart", "true", "false", false);
                    String string = (String)xMLElement2.getAttribute("transport");
                    String string2 = (String)xMLElement2.getAttribute("username");
                    int n3 = xMLElement2.getIntAttribute("sourcePort");
                    int n4 = xMLElement2.getIntAttribute("destinationPort");
                    String string3 = xMLElement2.getStringAttribute("destinationHost");
                    String string4 = xMLElement2.getStringAttribute("permissionId");
                    boolean bl2 = xMLElement2.getBooleanAttribute("allowExternalHosts", "true", "false", false);
                    this.log.info((Object)("Tunnel " + string + " from " + n3 + " to " + string3 + ":" + n4));
                    this.forwardingTunnels.addElement(new DefaultTunnel(n, n2, bl, string, string2, n3, n4, string3, bl2, true, false, string4, string3 + ":" + n4));
                    continue;
                }
                this.log.error((Object)"Invalid child element in success.tunnels");
            }
            return true;
        }
        this.log.error((Object)("Did not get a list of tunnels to start, got '" + xMLElement.toString() + " instead."));
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public VPNConnectionListener createTemporaryListeningSocket(String var1_1, int var2_2, boolean var3_3, int var4_4, int var5_5, boolean var6_6) {
        try {
            if (var4_4 == -1) {
                throw new IOException();
            }
            this.log.info((Object)("Attempting to create a " + (var6_6 != false ? "temporary single connect" : "temporary") + " listening socket for " + var1_1 + ":" + var2_2 + " on the preferred port " + var4_4));
            var7_7 = new DefaultTunnel(-1, 0, false, "tcp", this.username, var4_4, var2_2, var1_1, var3_3, false, var6_6, "", var1_1 + ":" + var2_2);
            return this.startListeningSocket(var7_7);
        }
        catch (IOException v0) {
            if (var4_4 == -1) {
                this.log.info((Object)"Preferred port disabled, choosing a random one.");
            } else {
                this.log.info((Object)"Preferred port failed as its probably in use by another application");
            }
            var7_8 = -1;
            var8_9 = 0;
            ** while (var8_9 < var5_5)
        }
lbl-1000:
        // 1 sources

        {
            try {
                var7_8 = this.selectRandomPort();
                this.log.info((Object)("Attempting to create a listening socket for " + var1_1 + ":" + var2_2 + " on the random port " + var7_8));
                var9_10 = new DefaultTunnel(-1, 0, false, "tcp", this.username, var7_8, var2_2, var1_1, var3_3, false, var6_6, "", var1_1 + ":" + var2_2);
                return this.startListeningSocket(var9_10);
            }
            catch (IOException v1) {
                this.log.info((Object)("Random port " + var7_8 + " failed! " + (var5_5 - var8_9) + " attempts left"));
                ++var8_9;
            }
            continue;
        }
lbl24:
        // 1 sources

        this.log.info((Object)"All attempts to create a listening socket failed");
        return null;
    }

    public Socket createTunnel(Tunnel tunnel) throws UnsupportedAuthenticationException, IOException {
        this.log.info((Object)("Creating SSL tunnel to " + tunnel.getDestinationHost() + ":" + tunnel.getDestinationPort()));
        HttpClient httpClient = new HttpClient();
        try {
            Object object;
            ConnectMethod connectMethod = new ConnectMethod(tunnel.getDestinationHost(), tunnel.getDestinationPort(), false);
            PasswordCredentials passwordCredentials = new PasswordCredentials();
            passwordCredentials.setUsername(this.ticket);
            passwordCredentials.setPassword(tunnel.getTicket());
            this.log.info((Object)("Set SSL-Explorer credentials to " + this.ticket + ":" + tunnel.getTicket()));
            httpClient.setCredentials(this.sslexplorerHostname, passwordCredentials);
            String string = this.sslexplorerHostname;
            int n = this.sslexplorerPort;
            boolean bl = true;
            if (this.localProxyURL != null) {
                object = new PasswordCredentials();
                String string2 = this.localProxyURL.getUserinfo();
                String string3 = "";
                String string4 = "";
                if (string2 != null && !string2.equals("")) {
                    int n2 = string2.indexOf(58);
                    string3 = string2;
                    if (n2 != -1) {
                        string4 = string2.substring(n2 + 1);
                        string3 = string2.substring(0, n2);
                    }
                }
                ((PasswordCredentials)object).setUsername(string3);
                ((PasswordCredentials)object).setPassword(string4);
                httpClient.setCredentials(this.localProxyURL.getHost(), (PasswordCredentials)object);
                this.log.info((Object)("Set local proxy to " + AbstractVPNClient.obfuscateURL(this.localProxyURL.toString())));
                connectMethod = new ConnectMethod(this.sslexplorerHostname, this.sslexplorerPort, true, connectMethod);
                string = this.localProxyURL.getHost();
                n = this.localProxyURL.getPort();
                bl = this.localProxyURL.getScheme().equalsIgnoreCase("https");
            }
            object = httpClient.execute(connectMethod, string, n, bl);
            return ((HttpResponse)object).getConnection().getSocket();
        }
        catch (HttpException httpException) {
            throw new IOException("HTTP connection failed: " + httpException.getMessage() + " [" + httpException.getStatus() + "]");
        }
    }

    public boolean unregisterApplicationTunnel(Tunnel tunnel) throws IOException {
        URL uRL = new URL("https://" + this.sslexplorerHostname + ":" + this.sslexplorerPort + "/unregisterListeningSocket.do" + "?ticket=" + this.ticket + "&tunnel=" + tunnel.getTicket());
        URLConnection uRLConnection = uRL.openConnection();
        XMLElement xMLElement = new XMLElement();
        xMLElement.parseFromReader(new InputStreamReader(uRLConnection.getInputStream()));
        return xMLElement.getName().equalsIgnoreCase("success");
    }

    protected void registerForwardingTunnel(VPNTunnel vPNTunnel) {
        this.activeForwardingTunnels.addElement(vPNTunnel);
    }

    public Socket createTunnel(String string, int n) throws IOException, HttpException, UnsupportedAuthenticationException {
        String string2 = string + ":" + n;
        Tunnel tunnel = !this.activeDirectTunnels.containsKey(string2) ? this.registerApplicationTunnel("[Undefined]", string, n) : (Tunnel)this.activeDirectTunnels.get(string2);
        return this.createTunnel(tunnel);
    }

    protected int selectRandomPort() {
        SecureRandom secureRandom = SecureRandom.getInstance();
        int n = 16384;
        int n2 = secureRandom.nextInt() % n;
        if (n2 < 0) {
            n2 = -n2;
        }
        return 49152 + n2;
    }
}

