/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssl;

import com.maverick.crypto.asn1.ASN1OctetString;
import com.maverick.crypto.asn1.ASN1Sequence;
import com.maverick.crypto.asn1.DERInputStream;
import com.maverick.crypto.asn1.DERObjectIdentifier;
import com.maverick.crypto.asn1.x509.CertificateException;
import com.maverick.crypto.asn1.x509.X509Certificate;
import com.maverick.crypto.asn1.x509.X509CertificateStructure;
import com.maverick.crypto.digests.MD5Digest;
import com.maverick.crypto.digests.SHA1Digest;
import com.maverick.crypto.publickey.PublicKey;
import com.maverick.crypto.publickey.Rsa;
import com.maverick.crypto.publickey.RsaPublicKey;
import com.maverick.ssl.SSLException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Hashtable;

public class TrustedCACertStore {
    Hashtable certificates = new Hashtable();

    public boolean isTrustedCertificate(X509Certificate x509Certificate, boolean bl, boolean bl2) throws SSLException {
        try {
            if (this.certificates.containsKey(x509Certificate.getIssuerDN())) {
                X509Certificate x509Certificate2 = (X509Certificate)this.certificates.get(x509Certificate.getIssuerDN());
                PublicKey publicKey = x509Certificate2.getPublicKey();
                if (publicKey instanceof RsaPublicKey) {
                    if (x509Certificate.getSigAlgName().equals("MD5WithRSAEncryption")) {
                        try {
                            BigInteger bigInteger = new BigInteger(x509Certificate.getSignature());
                            RsaPublicKey rsaPublicKey = (RsaPublicKey)x509Certificate2.getPublicKey();
                            BigInteger bigInteger2 = Rsa.doPublic((BigInteger)bigInteger, (BigInteger)rsaPublicKey.getModulus(), (BigInteger)rsaPublicKey.getPublicExponent());
                            BigInteger bigInteger3 = Rsa.removePKCS1((BigInteger)bigInteger2, (int)1);
                            byte[] byArray = bigInteger3.toByteArray();
                            MD5Digest mD5Digest = new MD5Digest();
                            mD5Digest.update(x509Certificate.getTBSCertificate(), 0, x509Certificate.getTBSCertificate().length);
                            byte[] byArray2 = new byte[mD5Digest.getDigestSize()];
                            mD5Digest.doFinal(byArray2, 0);
                            DERInputStream dERInputStream = new DERInputStream((InputStream)new ByteArrayInputStream(byArray));
                            ASN1Sequence aSN1Sequence = (ASN1Sequence)dERInputStream.readObject();
                            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.getObjectAt(0);
                            DERObjectIdentifier cfr_ignored_0 = (DERObjectIdentifier)aSN1Sequence2.getObjectAt(0);
                            ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1Sequence.getObjectAt(1);
                            byte[] byArray3 = aSN1OctetString.getOctets();
                            int n = 0;
                            while (n < byArray3.length) {
                                if (byArray3[n] != byArray2[n]) {
                                    return false;
                                }
                                ++n;
                            }
                        }
                        catch (IOException iOException) {
                            throw new SSLException(997, iOException.getMessage());
                        }
                    } else if (x509Certificate.getSigAlgName().equals("SHA1WithRSAEncryption")) {
                        try {
                            BigInteger bigInteger = new BigInteger(x509Certificate.getSignature());
                            RsaPublicKey rsaPublicKey = (RsaPublicKey)x509Certificate2.getPublicKey();
                            BigInteger bigInteger4 = Rsa.doPublic((BigInteger)bigInteger, (BigInteger)rsaPublicKey.getModulus(), (BigInteger)rsaPublicKey.getPublicExponent());
                            BigInteger bigInteger5 = Rsa.removePKCS1((BigInteger)bigInteger4, (int)1);
                            byte[] byArray = bigInteger5.toByteArray();
                            SHA1Digest sHA1Digest = new SHA1Digest();
                            sHA1Digest.update(x509Certificate.getTBSCertificate(), 0, x509Certificate.getTBSCertificate().length);
                            byte[] byArray4 = new byte[sHA1Digest.getDigestSize()];
                            sHA1Digest.doFinal(byArray4, 0);
                            DERInputStream dERInputStream = new DERInputStream((InputStream)new ByteArrayInputStream(byArray));
                            ASN1Sequence aSN1Sequence = (ASN1Sequence)dERInputStream.readObject();
                            ASN1Sequence aSN1Sequence3 = (ASN1Sequence)aSN1Sequence.getObjectAt(0);
                            DERObjectIdentifier cfr_ignored_1 = (DERObjectIdentifier)aSN1Sequence3.getObjectAt(0);
                            ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1Sequence.getObjectAt(1);
                            byte[] byArray5 = aSN1OctetString.getOctets();
                            int n = 0;
                            while (n < byArray5.length) {
                                if (byArray5[n] != byArray4[n]) {
                                    return false;
                                }
                                ++n;
                            }
                        }
                        catch (IOException iOException) {
                            throw new SSLException(997, iOException.getMessage());
                        }
                    } else {
                        throw new SSLException(43, x509Certificate.getSigAlgName() + " signature algorithm is currently not supported");
                    }
                    try {
                        x509Certificate2.checkValidity();
                        x509Certificate.checkValidity();
                    }
                    catch (CertificateException certificateException) {
                        return bl;
                    }
                    return true;
                }
                throw new SSLException(43, "Unsupported public key in X509 certificate");
            }
            try {
                x509Certificate.checkValidity();
            }
            catch (CertificateException certificateException) {
                return bl;
            }
            return bl2;
        }
        catch (CertificateException certificateException) {
            throw new SSLException(43, certificateException.getMessage());
        }
    }

    public void addTrustedCACertificate(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.addTrustedCACertificate(fileInputStream);
    }

    public void addTrustedCACertificate(String string) throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            throw new IOException("Could not locate trusted CA resource " + string + " andwhere in the CLASSPATH.");
        }
        this.addTrustedCACertificate(inputStream);
    }

    public void addTrustedCACertificate(InputStream inputStream) throws IOException {
        DERInputStream dERInputStream = null;
        try {
            try {
                dERInputStream = new DERInputStream(inputStream);
                ASN1Sequence aSN1Sequence = (ASN1Sequence)dERInputStream.readObject();
                X509Certificate x509Certificate = new X509Certificate(X509CertificateStructure.getInstance((Object)aSN1Sequence));
                this.certificates.put(x509Certificate.getIssuerDN(), x509Certificate);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (dERInputStream != null) {
                    dERInputStream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (dERInputStream != null) {
                dERInputStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    public TrustedCACertStore() throws IOException {
        this.addTrustedCACertificate("/gtecybertrustca.cert");
        this.addTrustedCACertificate("/baltimorecodesigningca.cert");
        this.addTrustedCACertificate("/baltimorecybertrustca.cert");
        this.addTrustedCACertificate("/entrust2048ca.cert");
        this.addTrustedCACertificate("/entrustclientca.cert");
        this.addTrustedCACertificate("/entrustglobalclientca.cert");
        this.addTrustedCACertificate("/entrustgsslca.cert");
        this.addTrustedCACertificate("/entrustsslca.cert");
        this.addTrustedCACertificate("/equifaxsecureca.cert");
        this.addTrustedCACertificate("/equifaxsecureebusinessca1.cert");
        this.addTrustedCACertificate("/equifaxsecureebusinessca2.cert");
        this.addTrustedCACertificate("/equifaxsecureglobalebusinessca1.cert");
        this.addTrustedCACertificate("/geotrustglobalca.cert");
        this.addTrustedCACertificate("/gtecybertrustglobalca.cert");
        this.addTrustedCACertificate("/gtecybertrust5ca.cert");
        this.addTrustedCACertificate("/thawtepersonalbasicca.cert");
        this.addTrustedCACertificate("/thawtepersonalfreemailca.cert");
        this.addTrustedCACertificate("/thawtepersonalpreiumca.cert");
        this.addTrustedCACertificate("/thawtepersonalpremiumca.cert");
        this.addTrustedCACertificate("/thawtepremiumserverca.cert");
        this.addTrustedCACertificate("/thawteserverca.cert");
        this.addTrustedCACertificate("/verisignclass1ca.cert");
        this.addTrustedCACertificate("/verisignclass2ca.cert");
        this.addTrustedCACertificate("/verisignclass3ca.cert");
        this.addTrustedCACertificate("/verisignclass4ca.cert");
        this.addTrustedCACertificate("/verisignserverca.cert");
    }
}

