/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssl;

import com.maverick.ssl.SSLCipherSuite;
import com.maverick.ssl.SSLContext;
import com.maverick.ssl.SSLException;
import com.maverick.ssl.SSLHandshakeProtocol;
import com.maverick.ssl.SSLIOException;
import com.maverick.ssl.SSL_NULL_WITH_NULL_NULL;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SSLTransport {
    public static final int VERSION_MAJOR = 3;
    public static final int VERSION_MINOR = 0;
    static final int WARNING_ALERT = 1;
    static final int FATAL_ALERT = 2;
    static final int CHANGE_CIPHER_SPEC_MSG = 20;
    static final int ALERT_PROTOCOL = 21;
    static final int APPLICATION_DATA = 23;
    SSLInputStream sslIn = new SSLInputStream();
    SSLOutputStream sslOut = new SSLOutputStream();
    SSLHandshakeProtocol handshake = null;
    SSLContext context;
    public String debug = "Standard transport";
    DataInputStream rawIn;
    DataOutputStream rawOut;
    long incomingSequence = 0L;
    long outgoingSequence = 0L;
    SSLCipherSuite writeCipherSuite = null;
    SSLCipherSuite readCipherSuite = null;
    Log log = LogFactory.getLog((Class)(class$com$maverick$ssl$SSLSocket != null ? class$com$maverick$ssl$SSLSocket : (class$com$maverick$ssl$SSLSocket = SSLTransport.class$("com.maverick.ssl.SSLSocket"))));
    private static /* synthetic */ Class class$com$maverick$ssl$SSLSocket;

    public void initialize(InputStream inputStream, OutputStream outputStream) throws IOException, SSLException {
        this.initialize(inputStream, outputStream, null);
    }

    public void initialize(InputStream inputStream, OutputStream outputStream, SSLContext sSLContext) throws IOException, SSLException {
        this.rawIn = new DataInputStream(inputStream);
        this.rawOut = new DataOutputStream(outputStream);
        this.writeCipherSuite = this.readCipherSuite = new SSL_NULL_WITH_NULL_NULL();
        this.log.debug((Object)"Initializing SSL");
        if (sSLContext == null) {
            sSLContext = new SSLContext();
        }
        this.handshake = new SSLHandshakeProtocol(this, sSLContext);
        this.handshake.startHandshake();
        while (!this.handshake.isComplete()) {
            this.processMessages();
            this.log.debug((Object)"Initialization complete; starting application protocol");
        }
    }

    public void close() throws SSLException {
        byte[] byArray = new byte[2];
        byArray[0] = 1;
        this.sendMessage(21, byArray);
    }

    void sendCipherChangeSpec(SSLCipherSuite sSLCipherSuite) throws SSLException {
        this.log.debug((Object)"Changing OutputStream cipher spec");
        this.sendMessage(20, new byte[]{1});
        this.writeCipherSuite = sSLCipherSuite;
        this.outgoingSequence = 0L;
    }

    public InputStream getInputStream() throws IOException {
        return this.sslIn;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.sslOut;
    }

    void sendMessage(int n, byte[] byArray) throws SSLException {
        this.sendMessage(n, byArray, 0, byArray.length);
    }

    void sendMessage(int n, byte[] byArray, int n2, int n3) throws SSLException {
        byte[] byArray2;
        Object object;
        if (this.writeCipherSuite.getMACLength() > 0) {
            object = this.writeCipherSuite.generateMAC(byArray, n2, n3, n, this.outgoingSequence);
            byArray2 = new byte[n3 + ((byte[])object).length];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
            System.arraycopy(object, 0, byArray2, n3, ((Object)object).length);
            this.writeCipherSuite.encrypt(byArray2, 0, byArray2.length);
        } else if (n2 > 0 || byArray.length != n3) {
            byArray2 = new byte[n3];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
        } else {
            byArray2 = byArray;
        }
        object = new ByteArrayOutputStream();
        try {
            ((ByteArrayOutputStream)object).write(n);
            ((ByteArrayOutputStream)object).write(3);
            ((ByteArrayOutputStream)object).write(0);
            ((ByteArrayOutputStream)object).write(byArray2.length >> 8 & 0xFF);
            ((ByteArrayOutputStream)object).write(byArray2.length);
            ((OutputStream)object).write(byArray2);
        }
        catch (IOException iOException) {
            throw new SSLException(997, iOException.getMessage() == null ? iOException.getClass().getName() : iOException.getMessage());
        }
        try {
            this.rawOut.write(((ByteArrayOutputStream)object).toByteArray());
        }
        catch (IOException iOException) {
            throw new SSLException(996, iOException.getMessage() == null ? iOException.getClass().getName() : iOException.getMessage());
        }
        ++this.outgoingSequence;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    void processMessages() throws SSLException, EOFException {
        int n = 0;
        byte[] byArray = null;
        try {
            n = this.rawIn.read();
            this.rawIn.read();
            this.rawIn.read();
            short s = this.rawIn.readShort();
            byArray = new byte[s];
            this.rawIn.readFully(byArray);
            this.readCipherSuite.decrypt(byArray, 0, byArray.length);
            if (this.readCipherSuite.getMACLength() > 0 && !this.readCipherSuite.verifyMAC(byArray, 0, byArray.length - this.readCipherSuite.getMACLength(), n, this.incomingSequence, byArray, byArray.length - this.readCipherSuite.getMACLength(), this.readCipherSuite.getMACLength())) {
                throw new SSLException(999, "Invalid MAC!!");
            }
        }
        catch (EOFException eOFException) {
            throw eOFException;
        }
        catch (IOException iOException) {
            throw new SSLException(996, iOException.getMessage() == null ? iOException.getClass().getName() : iOException.getMessage());
        }
        ++this.incomingSequence;
        this.log.debug((Object)("Processing fragment of type " + n));
        switch (n) {
            case 22: {
                this.handshake.processMessage(byArray, 0, byArray.length - this.readCipherSuite.getMACLength());
                break;
            }
            case 20: {
                this.log.debug((Object)"Changing InputStream cipher spec");
                this.readCipherSuite = this.handshake.getPendingCipherSuite();
                this.incomingSequence = 0L;
                break;
            }
            case 21: {
                switch (byArray[0]) {
                    case 2: {
                        throw new SSLException(byArray[1] & 0xFF);
                    }
                    case 1: {
                        switch (byArray[1]) {
                            case 0: {
                                this.log.debug((Object)"The remote side is closing the connection");
                                byte[] byArray2 = new byte[2];
                                byArray2[0] = 1;
                                this.sendMessage(21, byArray2);
                                throw new EOFException();
                            }
                        }
                        this.log.warn((Object)SSLException.getDescription(byArray[1]));
                        break;
                    }
                    default: {
                        this.log.debug((Object)("Unexpected alert type " + byArray[0] + " " + byArray[1]));
                        break;
                    }
                }
            }
            case 23: {
                this.sslIn.write(byArray, 0, byArray.length - this.readCipherSuite.getMACLength());
                break;
            }
            default: {
                throw new SSLException(999, "Unexpected SSL protocol type " + n);
            }
        }
    }

    public SSLContext getContext() {
        return this.context;
    }

    class SSLInputStream
    extends InputStream {
        byte[] buffer;
        int unread;
        int position;
        int base;
        boolean isEOF;
        long transfered;

        SSLInputStream() {
            SSLTransport.this.getClass();
            this.unread = 0;
            this.position = 0;
            this.base = 0;
            this.isEOF = false;
            this.transfered = 0L;
            this.buffer = new byte[16384];
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            int n = this.read(byArray, 0, 1);
            if (n > 0) {
                return byArray[0] & 0xFF;
            }
            return -1;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            try {
                while (this.unread <= 0 && !this.isEOF) {
                    SSLTransport.this.processMessages();
                }
                int n3 = this.unread < n2 ? this.unread : n2;
                int n4 = this.base;
                this.base = (this.base + n3) % this.buffer.length;
                if (this.buffer.length - n4 > n3) {
                    System.arraycopy(this.buffer, n4, byArray, n, n3);
                } else {
                    int n5 = this.buffer.length - n4;
                    System.arraycopy(this.buffer, n4, byArray, n, n5);
                    System.arraycopy(this.buffer, 0, byArray, n + n5, n3 - n5);
                }
                this.unread -= n3;
                return n3;
            }
            catch (EOFException eOFException) {
                return -1;
            }
            catch (SSLException sSLException) {
                throw new SSLIOException(sSLException);
            }
        }

        public int available() {
            return this.unread;
        }

        void write(byte[] byArray, int n, int n2) {
            int n3 = n;
            while (n3 < n + n2) {
                int n4 = (this.base + this.unread) % this.buffer.length;
                this.buffer[n4] = byArray[n3];
                ++this.unread;
                ++n3;
            }
        }
    }

    class SSLOutputStream
    extends OutputStream {
        SSLOutputStream() {
            SSLTransport.this.getClass();
        }

        public void write(int n) throws IOException {
            SSLTransport.this.log.debug((Object)"Sending 1 byte of data");
            try {
                SSLTransport.this.sendMessage(23, new byte[]{(byte)n});
            }
            catch (SSLException sSLException) {
                throw new SSLIOException(sSLException);
            }
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            SSLTransport.this.log.debug((Object)(n2 + " bytes of data to send"));
            try {
                int n3 = 0;
                while (n3 < n2) {
                    SSLTransport.this.log.debug((Object)("Sending block of " + (n2 - n3 < 16384 ? n2 - n3 : 16384) + " bytes"));
                    SSLTransport.this.sendMessage(23, byArray, n + n3, n2 - n3 < 16384 ? n2 - n3 : 16384);
                    n3 += n2 < 16384 ? n2 : 16384;
                }
            }
            catch (SSLException sSLException) {
                throw new SSLIOException(sSLException);
            }
        }
    }
}

