/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssl;

public class SSLException
extends Exception {
    public static final int CLOSE_NOTIFY = 0;
    public static final int UNEXPECTED_MESSAGE = 10;
    public static final int BAD_RECORD_MAC = 20;
    public static final int DECOMPRESSION_FAILURE = 30;
    public static final int HANDSHAKE_FAILURE = 40;
    public static final int NO_CERTIFICATE = 41;
    public static final int BAD_CERTIFICATE = 42;
    public static final int UNSUPPORTED_CERTIFICATE = 43;
    public static final int CERTIFICATE_REVOKED = 44;
    public static final int CERTIFICATE_EXPIRED = 45;
    public static final int CERTIFICATE_UNKNOWN = 46;
    public static final int PROTOCOL_VIOLATION = 999;
    public static final int UNSUPPORTED_OPERATION = 998;
    public static final int INTERNAL_ERROR = 997;
    public static final int UNEXPECTED_TERMINATION = 996;
    int status;

    public static String getDescription(int n) {
        switch (n) {
            case 0: {
                return "The remote side has closed the connection";
            }
            case 10: {
                return "Unexpected message";
            }
            case 20: {
                return "Bad record MAC";
            }
            case 30: {
                return "Decompression failure";
            }
            case 40: {
                return "Handshake failure";
            }
            case 41: {
                return "No certificate";
            }
            case 42: {
                return "Bad certificate";
            }
            case 43: {
                return "Unsupported certificate";
            }
            case 44: {
                return "Certificate revoked";
            }
            case 45: {
                return "Certificate expired";
            }
            case 46: {
                return "Certificate unknown";
            }
            case 999: {
                return "Protocol violation";
            }
        }
        return "Unexpected error status " + n;
    }

    public SSLException(int n) {
        super(SSLException.getDescription(n));
    }

    public SSLException(int n, String string) {
        super(string);
    }

    public int getStatus() {
        return this.status;
    }
}

