/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.http;

import com.maverick.http.HttpAuthenticator;
import com.maverick.http.HttpRequest;
import com.maverick.http.HttpResponse;
import com.maverick.http.NTLM;
import java.io.IOException;

public class NTLMAuthentication
extends HttpAuthenticator {
    NTLM ntlm = new NTLM();
    String host = "";
    String domain = "";
    String challenge = null;
    private static final int INITIATED = 1;
    private static final int TYPE1_MSG_GENERATED = 2;
    private static final int TYPE2_MSG_RECEIVED = 3;
    private static final int TYPE3_MSG_GENERATED = 4;
    private static final int FAILED = Integer.MAX_VALUE;
    int state = 1;
    boolean isAuthenticated = false;

    public void setChallenge(String string) {
    }

    public void setDomain(String string) {
        this.domain = string;
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    public NTLMAuthentication() {
        super("NTLM");
    }

    public boolean wantsPrompt() {
        return this.credentials == null;
    }

    public boolean processResponse(HttpResponse httpResponse) {
        this.isAuthenticated = httpResponse.getStatus() == 200;
        this.challenge = httpResponse.getHeaderField(this.authenticationHeader);
        if (this.challenge != null) {
            if (this.challenge.equals("NTLM")) {
                this.challenge = "";
                this.state = 1;
            } else if (this.challenge.startsWith("NTLM") && this.challenge.length() > 4) {
                this.challenge = this.challenge.substring(5).trim();
                this.state = 3;
            }
        }
        return this.state == 4;
    }

    public void authenticate(HttpRequest httpRequest, String string) throws IOException {
        switch (this.state) {
            case 1: {
                httpRequest.setHeaderField(this.authorizationHeader, "NTLM " + this.ntlm.getResponseFor(this.challenge, this.credentials.getUsername(), this.credentials.getPassword(), this.connection.getHost(), this.domain));
                this.state = 2;
                break;
            }
            case 3: {
                httpRequest.setHeaderField(this.authorizationHeader, "NTLM " + this.ntlm.getResponseFor(this.challenge, this.credentials.getUsername(), this.credentials.getPassword(), this.connection.getHost(), this.domain));
                this.state = 4;
                break;
            }
            default: {
                throw new IOException("Invalid authentication state in NTLM authentication");
            }
        }
    }
}

