/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class HttpHeader {
    protected static final String WHITE_SPACE = " \t\r";
    Hashtable fields = new Hashtable();
    protected String begin;

    private String processNextLine(String string, String string2) throws IOException {
        String string3;
        String string4;
        char c = string.charAt(0);
        if (c == ' ' || c == '\t') {
            string4 = string2;
            string3 = this.getHeaderField(string2) + " " + string.trim();
        } else {
            int n = string.indexOf(58);
            if (n == -1) {
                throw new IOException("HTTP Header encoutered a corrupt field: '" + string + "'");
            }
            string4 = string.substring(0, n).toLowerCase();
            string3 = string.substring(n + 1).trim();
        }
        this.setHeaderField(string4, string3);
        return string4;
    }

    public String toString() {
        String string = this.begin + "\r\n";
        Enumeration enumeration = this.getHeaderFieldNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            string = string + string2 + ": " + this.getHeaderField(string2) + "\r\n";
        }
        string = string + "\r\n";
        return string;
    }

    protected HttpHeader() {
    }

    public Hashtable getHeaderFields() {
        return this.fields;
    }

    protected String readLine(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n;
            if ((n = inputStream.read()) == -1) {
                throw new IOException("Failed to read expected HTTP header line: " + stringBuffer.toString());
            }
            if (n == 10) continue;
            if (n == 13) break;
            stringBuffer.append((char)n);
        }
        return new String(stringBuffer);
    }

    public String getStartLine() {
        return this.begin;
    }

    public String getHeaderField(String string) {
        return (String)this.fields.get(string.toLowerCase());
    }

    public void setHeaderField(String string, String string2) {
        this.fields.put(string.toLowerCase(), string2);
    }

    public Enumeration getHeaderFieldNames() {
        return this.fields.keys();
    }

    protected void processHeaderFields(InputStream inputStream) throws IOException {
        int n;
        this.fields = new Hashtable();
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        while (true) {
            if ((n = inputStream.read()) == -1) {
                throw new IOException("The HTTP header is corrupt");
            }
            if (n == 10) continue;
            if (n != 13) {
                stringBuffer.append((char)n);
                continue;
            }
            if (stringBuffer.length() == 0) break;
            String string2 = stringBuffer.toString();
            string = this.processNextLine(string2, string);
            stringBuffer.setLength(0);
        }
        n = inputStream.read();
    }
}

