/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.http;

import com.maverick.http.AuthenticationPrompt;
import com.maverick.http.AuthenticationRequired;
import com.maverick.http.HttpAuthenticator;
import com.maverick.http.HttpAuthenticatorFactory;
import com.maverick.http.HttpConnection;
import com.maverick.http.HttpException;
import com.maverick.http.HttpMethod;
import com.maverick.http.HttpResponse;
import com.maverick.http.PasswordCredentials;
import com.maverick.http.UnsupportedAuthenticationException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpClient {
    Hashtable credentialsStore = new Hashtable();
    AuthenticationPrompt prompt;
    boolean doAuth = true;
    String authType = "basic";
    static Log log = LogFactory.getLog((Class)(class$com$maverick$http$HttpClient != null ? class$com$maverick$http$HttpClient : (class$com$maverick$http$HttpClient = HttpClient.class$("com.maverick.http.HttpClient"))));
    private static /* synthetic */ Class class$com$maverick$http$HttpClient;

    public HttpResponse execute(HttpMethod httpMethod, HttpConnection httpConnection) throws IOException, HttpException, UnsupportedAuthenticationException {
        try {
            log.info((Object)("Executing unauthenticated method " + httpMethod.getName() + " on connection " + httpConnection.getHost()));
            return httpMethod.execute(this, httpConnection);
        }
        catch (AuthenticationRequired authenticationRequired) {
            HttpResponse httpResponse;
            log.info((Object)(httpConnection.getHost() + " requires " + authenticationRequired.getAuthorizationHeader() + " for " + HttpAuthenticatorFactory.getAuthenticationMethod(authenticationRequired.getChallenge())));
            HttpAuthenticator httpAuthenticator = HttpAuthenticatorFactory.createAuthenticator(httpConnection, authenticationRequired.getChallenge(), authenticationRequired.getAuthenticateHeader(), authenticationRequired.getAuthorizationHeader());
            if (this.prompt == null && httpAuthenticator.wantsPrompt() && !this.credentialsStore.containsKey(httpConnection.getHost().toLowerCase())) {
                throw new IOException("Authentication required but no credentials or authentication prompt callback are available!");
            }
            if (this.credentialsStore.containsKey(httpConnection.getHost().toLowerCase())) {
                log.info((Object)("Found credentials for host " + httpConnection.getHost()));
                httpAuthenticator.setCredentials((PasswordCredentials)this.credentialsStore.get(httpConnection.getHost().toLowerCase()));
            } else if (httpAuthenticator.wantsPrompt()) {
                log.info((Object)"Prompting user for credentials");
                this.prompt.promptForCredentials(httpAuthenticator);
            }
            if (authenticationRequired.hasConnectionClosed()) {
                try {
                    httpConnection.getSocket().close();
                }
                catch (IOException iOException) {}
                httpConnection = new HttpConnection(httpConnection.getHost(), httpConnection.getPort(), httpConnection.isSecure());
            }
            log.info((Object)("Executing method " + httpMethod.getName() + " with authentication on connection " + httpConnection.getHost()));
            while (!httpAuthenticator.processResponse(httpResponse = httpMethod.execute(this, httpConnection, httpAuthenticator))) {
            }
            if (!httpAuthenticator.isAuthenticated()) {
                throw new HttpException(httpResponse.getReason(), httpResponse.getStatus());
            }
            return httpResponse;
        }
    }

    public HttpResponse execute(HttpMethod httpMethod, String string, int n, boolean bl) throws UnknownHostException, IOException, HttpException, UnsupportedAuthenticationException {
        HttpConnection httpConnection = new HttpConnection(string, n, bl);
        return this.execute(httpMethod, httpConnection);
    }

    public void setCredentials(String string, PasswordCredentials passwordCredentials) {
        log.info((Object)("Set credentials for host " + string));
        this.credentialsStore.put(string.toLowerCase(), passwordCredentials);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void setAuthenticationPrompt(AuthenticationPrompt authenticationPrompt) {
        this.prompt = authenticationPrompt;
    }
}

