/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;

public class SimpleLog
implements Log,
Serializable {
    protected static final String systemPrefix = "org.apache.commons.logging.simplelog.";
    protected static final Properties simpleLogProps = new Properties();
    protected static final String DEFAULT_DATE_TIME_FORMAT = "yyyy/MM/dd HH:mm:ss:SSS zzz";
    protected static boolean showLogName = false;
    protected static boolean showShortName = true;
    protected static boolean showDateTime = false;
    protected static String dateTimeFormat = "yyyy/MM/dd HH:mm:ss:SSS zzz";
    protected static DateFormat dateFormatter = null;
    public static final int LOG_LEVEL_TRACE = 1;
    public static final int LOG_LEVEL_DEBUG = 2;
    public static final int LOG_LEVEL_INFO = 3;
    public static final int LOG_LEVEL_WARN = 4;
    public static final int LOG_LEVEL_ERROR = 5;
    public static final int LOG_LEVEL_FATAL = 6;
    public static final int LOG_LEVEL_ALL = 0;
    public static final int LOG_LEVEL_OFF = 7;
    protected String logName = null;
    protected int currentLogLevel;
    private String shortLogName = null;
    private static /* synthetic */ Class class$java$lang$Thread;
    private static /* synthetic */ Class class$org$apache$commons$logging$impl$SimpleLog;

    public final void trace(Object object, Throwable throwable) {
        if (this.isLevelEnabled(1)) {
            this.log(1, object, throwable);
        }
    }

    protected void log(int n, Object object, Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer();
        if (showDateTime) {
            stringBuffer.append(dateFormatter.format(new Date()));
            stringBuffer.append(" ");
        }
        switch (n) {
            case 1: {
                stringBuffer.append("[TRACE] ");
                break;
            }
            case 2: {
                stringBuffer.append("[DEBUG] ");
                break;
            }
            case 3: {
                stringBuffer.append("[INFO] ");
                break;
            }
            case 4: {
                stringBuffer.append("[WARN] ");
                break;
            }
            case 5: {
                stringBuffer.append("[ERROR] ");
                break;
            }
            case 6: {
                stringBuffer.append("[FATAL] ");
                break;
            }
        }
        if (showShortName) {
            if (this.shortLogName == null) {
                this.shortLogName = this.logName.substring(this.logName.lastIndexOf(".") + 1);
                this.shortLogName = this.shortLogName.substring(this.shortLogName.lastIndexOf("/") + 1);
            }
            stringBuffer.append(String.valueOf(this.shortLogName)).append(" - ");
        } else if (showLogName) {
            stringBuffer.append(String.valueOf(this.logName)).append(" - ");
        }
        stringBuffer.append(String.valueOf(object));
        if (throwable != null) {
            stringBuffer.append(" <");
            stringBuffer.append(throwable.toString());
            stringBuffer.append(">");
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            printWriter.close();
            stringBuffer.append(stringWriter.toString());
        }
        this.write(stringBuffer);
    }

    public final boolean isFatalEnabled() {
        return this.isLevelEnabled(6);
    }

    public final boolean isWarnEnabled() {
        return this.isLevelEnabled(4);
    }

    public final void fatal(Object object) {
        if (this.isLevelEnabled(6)) {
            this.log(6, object, null);
        }
    }

    public final void fatal(Object object, Throwable throwable) {
        if (this.isLevelEnabled(6)) {
            this.log(6, object, throwable);
        }
    }

    public SimpleLog(String string) {
        this.logName = string;
        this.setLevel(3);
        String string2 = SimpleLog.getStringProperty(systemPrefix + "log." + this.logName);
        int n = String.valueOf(string).lastIndexOf(".");
        while (string2 == null && n > -1) {
            string = string.substring(0, n);
            string2 = SimpleLog.getStringProperty(systemPrefix + "log." + string);
            n = String.valueOf(string).lastIndexOf(".");
        }
        if (string2 == null) {
            string2 = SimpleLog.getStringProperty(systemPrefix + "defaultlog");
        }
        if ("all".equalsIgnoreCase(string2)) {
            this.setLevel(0);
        } else if ("trace".equalsIgnoreCase(string2)) {
            this.setLevel(1);
        } else if ("debug".equalsIgnoreCase(string2)) {
            this.setLevel(2);
        } else if ("info".equalsIgnoreCase(string2)) {
            this.setLevel(3);
        } else if ("warn".equalsIgnoreCase(string2)) {
            this.setLevel(4);
        } else if ("error".equalsIgnoreCase(string2)) {
            this.setLevel(5);
        } else if ("fatal".equalsIgnoreCase(string2)) {
            this.setLevel(6);
        } else if ("off".equalsIgnoreCase(string2)) {
            this.setLevel(7);
        }
    }

    protected boolean isLevelEnabled(int n) {
        return n >= this.currentLogLevel;
    }

    public final void info(Object object) {
        if (this.isLevelEnabled(3)) {
            this.log(3, object, null);
        }
    }

    public final void info(Object object, Throwable throwable) {
        if (this.isLevelEnabled(3)) {
            this.log(3, object, throwable);
        }
    }

    public final void warn(Object object) {
        if (this.isLevelEnabled(4)) {
            this.log(4, object, null);
        }
    }

    public final void warn(Object object, Throwable throwable) {
        if (this.isLevelEnabled(4)) {
            this.log(4, object, throwable);
        }
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader classLoader = null;
        if (classLoader == null) {
            try {
                Method method = (class$java$lang$Thread != null ? class$java$lang$Thread : (class$java$lang$Thread = SimpleLog.class$("java.lang.Thread"))).getMethod("getContextClassLoader", null);
                try {
                    classLoader = (ClassLoader)method.invoke((Object)Thread.currentThread(), null);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (!(invocationTargetException.getTargetException() instanceof SecurityException)) {
                        throw new LogConfigurationException("Unexpected InvocationTargetException", invocationTargetException.getTargetException());
                    }
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        if (classLoader == null) {
            classLoader = (class$org$apache$commons$logging$impl$SimpleLog != null ? class$org$apache$commons$logging$impl$SimpleLog : (class$org$apache$commons$logging$impl$SimpleLog = SimpleLog.class$("org.apache.commons.logging.impl.SimpleLog"))).getClassLoader();
        }
        return classLoader;
    }

    private static String getStringProperty(String string) {
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (SecurityException securityException) {}
        if (string2 == null) {
            return simpleLogProps.getProperty(string);
        }
        return string2;
    }

    private static String getStringProperty(String string, String string2) {
        String string3 = SimpleLog.getStringProperty(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    protected void write(StringBuffer stringBuffer) {
        System.err.println(stringBuffer.toString());
    }

    public final boolean isErrorEnabled() {
        return this.isLevelEnabled(5);
    }

    public final boolean isInfoEnabled() {
        return this.isLevelEnabled(3);
    }

    private static InputStream getResourceAsStream(String string) {
        ClassLoader classLoader = SimpleLog.getContextClassLoader();
        if (classLoader != null) {
            return classLoader.getResourceAsStream(string);
        }
        return ClassLoader.getSystemResourceAsStream(string);
    }

    public final void debug(Object object) {
        if (this.isLevelEnabled(2)) {
            this.log(2, object, null);
        }
    }

    public final void debug(Object object, Throwable throwable) {
        if (this.isLevelEnabled(2)) {
            this.log(2, object, throwable);
        }
    }

    static {
        InputStream inputStream = SimpleLog.getResourceAsStream("simplelog.properties");
        if (inputStream != null) {
            try {
                simpleLogProps.load(inputStream);
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        showLogName = SimpleLog.getBooleanProperty(systemPrefix + "showlogname", showLogName);
        showShortName = SimpleLog.getBooleanProperty(systemPrefix + "showShortLogname", showShortName);
        showDateTime = SimpleLog.getBooleanProperty(systemPrefix + "showdatetime", showDateTime);
        if (showDateTime) {
            dateTimeFormat = SimpleLog.getStringProperty(systemPrefix + "dateTimeFormat", dateTimeFormat);
            try {
                dateFormatter = new SimpleDateFormat(dateTimeFormat);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                dateTimeFormat = DEFAULT_DATE_TIME_FORMAT;
                dateFormatter = new SimpleDateFormat(dateTimeFormat);
            }
        }
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static boolean getBooleanProperty(String string, boolean bl) {
        String string2 = SimpleLog.getStringProperty(string);
        if (string2 == null) {
            return bl;
        }
        return "true".equalsIgnoreCase(string2);
    }

    public final boolean isDebugEnabled() {
        return this.isLevelEnabled(2);
    }

    public final boolean isTraceEnabled() {
        return this.isLevelEnabled(1);
    }

    public void setLevel(int n) {
        this.currentLogLevel = n;
    }

    public int getLevel() {
        return this.currentLogLevel;
    }

    public final void error(Object object) {
        if (this.isLevelEnabled(5)) {
            this.log(5, object, null);
        }
    }

    public final void error(Object object, Throwable throwable) {
        if (this.isLevelEnabled(5)) {
            this.log(5, object, throwable);
        }
    }

    public final void trace(Object object) {
        if (this.isLevelEnabled(1)) {
            this.log(1, object, null);
        }
    }
}

