/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.publickey;

import com.maverick.crypto.io.ByteArrayReader;
import com.maverick.ssh.SshException;
import com.maverick.ssh.SshPublicKey;
import com.maverick.ssh2.Ssh2DsaPublicKey;
import com.maverick.ssh2.Ssh2RsaPublicKey;
import com.sshtools.publickey.B;
import com.sshtools.publickey.F;
import com.sshtools.publickey.J;
import com.sshtools.publickey.SshPublicKeyFile;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class SshPublicKeyFileFactory {
    public static final int OPENSSH_FORMAT = 0;
    public static final int SECSH_FORMAT = 1;
    public static final int SSH1_FORMAT = 2;

    public static SshPublicKey decodeSSH2PublicKey(byte[] byArray) throws IOException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            String string = byteArrayReader.readString();
            if (string.equals("ssh-dss")) {
                try {
                    Ssh2DsaPublicKey ssh2DsaPublicKey = new Ssh2DsaPublicKey();
                    ssh2DsaPublicKey.init(byArray, 0, byArray.length);
                    return ssh2DsaPublicKey;
                }
                catch (SshException sshException) {
                    throw new IOException("Failed to decode ssh-dss public key");
                }
            }
            if (string.equals("ssh-rsa")) {
                try {
                    Ssh2RsaPublicKey ssh2RsaPublicKey = new Ssh2RsaPublicKey();
                    ssh2RsaPublicKey.init(byArray, 0, byArray.length);
                    return ssh2RsaPublicKey;
                }
                catch (SshException sshException) {
                    throw new IOException("Failed to decode ssh-rsa public key");
                }
            }
            throw new IOException("Unsupported SSH2 public key algorithm " + string);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new IOException("An error occured parsing a public key file! Is the file corrupt?");
        }
    }

    public static SshPublicKeyFile parse(byte[] byArray) throws IOException {
        try {
            try {
                return new B(byArray);
            }
            catch (IOException iOException) {
                try {
                    return new J(byArray);
                }
                catch (IOException iOException2) {
                    return new F(byArray);
                }
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new IOException("An error occured parsing a public key file! Is the file corrupt?");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SshPublicKeyFile parse(InputStream inputStream) throws IOException {
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = inputStream.read()) > -1) {
                byteArrayOutputStream.write(n);
            }
            SshPublicKeyFile sshPublicKeyFile = SshPublicKeyFileFactory.parse(byteArrayOutputStream.toByteArray());
            return sshPublicKeyFile;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static SshPublicKeyFile create(SshPublicKey sshPublicKey, String string, int n) throws IOException {
        switch (n) {
            case 0: {
                return new B(sshPublicKey, string);
            }
            case 1: {
                return new J(sshPublicKey, string);
            }
            case 2: {
                return new F(sshPublicKey);
            }
        }
        throw new IOException("Invalid format type specified!");
    }
}

