/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.publickey;

import com.maverick.crypto.publickey.RsaPrivateCrtKey;
import com.sshtools.publickey.Base64EncodedFileFormat;
import com.sshtools.publickey.D;
import com.sshtools.publickey.G;
import com.sshtools.publickey.H;
import com.sshtools.publickey.I;
import com.sshtools.publickey.K;
import com.sshtools.publickey.SshKeyPair;
import com.sshtools.publickey.SshPrivateKeyFile;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class SshPrivateKeyFileFactory {
    public static final int OPENSSH_FORMAT = 0;
    public static final int SSHTOOLS_FORMAT = 1;
    public static final int SSH1_FORMAT = 3;

    public static SshPrivateKeyFile parse(byte[] byArray) throws IOException {
        try {
            if (K.C(byArray)) {
                return new K(byArray);
            }
            if (Base64EncodedFileFormat.isFormatted(byArray, I.I, I.K)) {
                return new I(byArray);
            }
            if (D.A(byArray)) {
                return new D(byArray);
            }
            if (G.B(byArray)) {
                return new G(byArray);
            }
            if (H.D(byArray)) {
                return new H(byArray);
            }
            throw new IOException("A suitable key format could not be found!");
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new IOException("An error occured parsing a private key file! Is the file corrupt?");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SshPrivateKeyFile parse(InputStream inputStream) throws IOException {
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = inputStream.read()) > -1) {
                byteArrayOutputStream.write(n);
            }
            SshPrivateKeyFile sshPrivateKeyFile = SshPrivateKeyFileFactory.parse(byteArrayOutputStream.toByteArray());
            return sshPrivateKeyFile;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static SshPrivateKeyFile create(SshKeyPair sshKeyPair, String string, String string2, int n) throws IOException {
        if (!(sshKeyPair.B instanceof RsaPrivateCrtKey) && n == 3) {
            throw new IOException("SSH1 format requires rsa key pair!");
        }
        switch (n) {
            case 0: {
                return new K(sshKeyPair, string);
            }
            case 1: {
                return new I(sshKeyPair, string, string2);
            }
            case 3: {
                return new D(sshKeyPair, string, string2);
            }
        }
        throw new IOException("Invalid key format!");
    }
}

