/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.publickey;

import com.maverick.crypto.io.ByteArrayReader;
import com.maverick.ssh.Packet;
import com.maverick.ssh.SshChannel;
import com.maverick.ssh.SshException;
import com.maverick.ssh.SshPublicKey;
import com.maverick.ssh.SubsystemChannel;
import com.maverick.ssh2.Ssh2Session;
import com.sshtools.publickey.PublicKeySubsystemException;
import com.sshtools.publickey.SshPublicKeyFileFactory;
import java.io.IOException;
import java.util.Vector;

public class PublicKeySubsystem
extends SubsystemChannel {
    static final int H = 0;
    static final int Q = 1;
    static final int R = 2;
    static final int I = 3;
    static final int P = 4;
    static final int O = 5;
    static final int M = 6;
    static final int N = 7;
    static final int G = 8;
    static final int K = 1;
    static final int J = 2;
    int L;

    public PublicKeySubsystem(Ssh2Session ssh2Session) throws SshException {
        super((SshChannel)ssh2Session);
        try {
            if (!ssh2Session.startSubsystem("publickey@vandyke.com")) {
                throw new SshException("The remote side failed to start the publickey subsystem", 6);
            }
            Packet packet = this.createPacket();
            packet.writeString("version");
            packet.writeInt(1);
            this.sendMessage(packet);
            ByteArrayReader byteArrayReader = new ByteArrayReader(this.nextMessage());
            String string = byteArrayReader.readString();
            int n = (int)byteArrayReader.readInt();
            this.L = Math.min(n, 1);
        }
        catch (IOException iOException) {
            throw new SshException(5, (Throwable)iOException);
        }
    }

    public void add(SshPublicKey sshPublicKey, String string) throws SshException, PublicKeySubsystemException {
        try {
            Packet packet = this.createPacket();
            packet.writeString("add");
            packet.writeString(string);
            packet.writeString(sshPublicKey.getAlgorithm());
            packet.writeBinaryString(sshPublicKey.getEncoded());
            this.sendMessage(packet);
            this.A();
        }
        catch (IOException iOException) {
            throw new SshException((Throwable)iOException);
        }
    }

    public void remove(SshPublicKey sshPublicKey) throws SshException, PublicKeySubsystemException {
        try {
            Packet packet = this.createPacket();
            packet.writeString("remove");
            packet.writeString(sshPublicKey.getAlgorithm());
            packet.writeBinaryString(sshPublicKey.getEncoded());
            this.sendMessage(packet);
            this.A();
        }
        catch (IOException iOException) {
            throw new SshException((Throwable)iOException);
        }
    }

    public SshPublicKey[] list() throws SshException, PublicKeySubsystemException {
        try {
            String string;
            ByteArrayReader byteArrayReader;
            String string2;
            Packet packet = this.createPacket();
            packet.writeString("list");
            this.sendMessage(packet);
            Vector<SshPublicKey> vector = new Vector<SshPublicKey>();
            while ((string2 = (byteArrayReader = new ByteArrayReader(this.nextMessage())).readString()).equals("publickey")) {
                String string3 = byteArrayReader.readString();
                string = byteArrayReader.readString();
                vector.addElement(SshPublicKeyFileFactory.decodeSSH2PublicKey(byteArrayReader.readBinaryString()));
            }
            if (string2.equals("status")) {
                int n = (int)byteArrayReader.readInt();
                string = byteArrayReader.readString();
                if (n != 0) {
                    throw new PublicKeySubsystemException(n, string);
                }
                Object[] objectArray = new SshPublicKey[vector.size()];
                vector.copyInto(objectArray);
                return objectArray;
            }
            throw new SshException("The server sent an invalid response to a list command", 3);
        }
        catch (IOException iOException) {
            throw new SshException((Throwable)iOException);
        }
    }

    public void associateCommand(SshPublicKey sshPublicKey, String string) throws SshException, PublicKeySubsystemException {
        try {
            Packet packet = this.createPacket();
            packet.writeString("command");
            packet.writeString(sshPublicKey.getAlgorithm());
            packet.writeBinaryString(sshPublicKey.getEncoded());
            packet.writeString(string);
            this.sendMessage(packet);
            this.A();
        }
        catch (IOException iOException) {
            throw new SshException((Throwable)iOException);
        }
    }

    void A() throws SshException, PublicKeySubsystemException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(this.nextMessage());
            String string = byteArrayReader.readString();
            int n = (int)byteArrayReader.readInt();
            String string2 = byteArrayReader.readString();
            if (n != 0) {
                throw new PublicKeySubsystemException(n, string2);
            }
        }
        catch (IOException iOException) {
            throw new SshException((Throwable)iOException);
        }
    }
}

