/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.publickey;

import com.maverick.crypto.publickey.DsaPrivateKey;
import com.maverick.crypto.publickey.DsaPublicKey;
import com.maverick.crypto.publickey.RsaPrivateCrtKey;
import com.maverick.ssh.SshDsaPrivateKey;
import com.maverick.ssh.SshRsaPrivateCrtKey;
import com.maverick.ssh2.Ssh2DsaPublicKey;
import com.maverick.ssh2.Ssh2RsaPublicKey;
import com.sshtools.publickey.C;
import com.sshtools.publickey.E;
import com.sshtools.publickey.InvalidPassphraseException;
import com.sshtools.publickey.SshKeyPair;
import com.sshtools.publickey.SshPrivateKeyFile;
import com.sshtools.util.SimpleASNReader;
import com.sshtools.util.SimpleASNWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigInteger;

class K
implements SshPrivateKeyFile {
    byte[] L;

    K(byte[] byArray) throws IOException {
        if (!K.C(byArray)) {
            throw new IOException("Formatted key data is not a valid OpenSSH key format");
        }
        this.L = byArray;
    }

    K(SshKeyPair sshKeyPair, String string) throws IOException {
        this.L = this.A(sshKeyPair, string);
    }

    public boolean isPassphraseProtected() {
        try {
            StringReader stringReader = new StringReader(new String(this.L, "US-ASCII"));
            E e = new E(stringReader);
            return e.F().containsKey("DEK-Info");
        }
        catch (IOException iOException) {
            return true;
        }
    }

    public String getType() {
        return "OpenSSH";
    }

    public boolean supportsPassphraseChange() {
        return true;
    }

    public SshKeyPair toKeyPair(String string) throws IOException, InvalidPassphraseException {
        StringReader stringReader = new StringReader(new String(this.L, "US-ASCII"));
        E e = new E(stringReader);
        byte[] byArray = e.B(string);
        SimpleASNReader simpleASNReader = new SimpleASNReader(byArray);
        try {
            if ("DSA PRIVATE KEY".equals(e.E())) {
                return this.A(simpleASNReader);
            }
            if ("RSA PRIVATE KEY".equals(e.E())) {
                return this.B(simpleASNReader);
            }
            throw new IOException("Unsupported type: " + e.E());
        }
        catch (IOException iOException) {
            throw new InvalidPassphraseException();
        }
    }

    SshKeyPair B(SimpleASNReader simpleASNReader) throws IOException {
        simpleASNReader.assertByte(48);
        simpleASNReader.getLength();
        simpleASNReader.assertByte(2);
        simpleASNReader.getData();
        simpleASNReader.assertByte(2);
        BigInteger bigInteger = new BigInteger(simpleASNReader.getData());
        simpleASNReader.assertByte(2);
        BigInteger bigInteger2 = new BigInteger(simpleASNReader.getData());
        simpleASNReader.assertByte(2);
        BigInteger bigInteger3 = new BigInteger(simpleASNReader.getData());
        simpleASNReader.assertByte(2);
        BigInteger bigInteger4 = new BigInteger(simpleASNReader.getData());
        simpleASNReader.assertByte(2);
        BigInteger bigInteger5 = new BigInteger(simpleASNReader.getData());
        simpleASNReader.assertByte(2);
        BigInteger bigInteger6 = new BigInteger(simpleASNReader.getData());
        simpleASNReader.assertByte(2);
        BigInteger bigInteger7 = new BigInteger(simpleASNReader.getData());
        simpleASNReader.assertByte(2);
        BigInteger bigInteger8 = new BigInteger(simpleASNReader.getData());
        SshKeyPair sshKeyPair = new SshKeyPair();
        sshKeyPair.A = new Ssh2RsaPublicKey(bigInteger, bigInteger2);
        sshKeyPair.B = new SshRsaPrivateCrtKey(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
        return sshKeyPair;
    }

    SshKeyPair A(SimpleASNReader simpleASNReader) throws IOException {
        simpleASNReader.assertByte(48);
        simpleASNReader.getLength();
        simpleASNReader.assertByte(2);
        simpleASNReader.getData();
        simpleASNReader.assertByte(2);
        BigInteger bigInteger = new BigInteger(simpleASNReader.getData());
        simpleASNReader.assertByte(2);
        BigInteger bigInteger2 = new BigInteger(simpleASNReader.getData());
        simpleASNReader.assertByte(2);
        BigInteger bigInteger3 = new BigInteger(simpleASNReader.getData());
        simpleASNReader.assertByte(2);
        BigInteger bigInteger4 = new BigInteger(simpleASNReader.getData());
        simpleASNReader.assertByte(2);
        BigInteger bigInteger5 = new BigInteger(simpleASNReader.getData());
        SshKeyPair sshKeyPair = new SshKeyPair();
        sshKeyPair.A = new Ssh2DsaPublicKey(bigInteger, bigInteger2, bigInteger3, bigInteger4);
        sshKeyPair.B = new SshDsaPrivateKey(bigInteger, bigInteger2, bigInteger3, bigInteger5);
        return sshKeyPair;
    }

    void A(SimpleASNWriter simpleASNWriter, DsaPrivateKey dsaPrivateKey, DsaPublicKey dsaPublicKey) {
        SimpleASNWriter simpleASNWriter2 = new SimpleASNWriter();
        simpleASNWriter2.writeByte(2);
        byte[] byArray = new byte[1];
        simpleASNWriter2.writeData(byArray);
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(dsaPrivateKey.getP().toByteArray());
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(dsaPrivateKey.getQ().toByteArray());
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(dsaPrivateKey.getG().toByteArray());
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(dsaPublicKey.getY().toByteArray());
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(dsaPrivateKey.getX().toByteArray());
        byte[] byArray2 = simpleASNWriter2.toByteArray();
        simpleASNWriter.writeByte(48);
        simpleASNWriter.writeData(byArray2);
    }

    void A(SimpleASNWriter simpleASNWriter, RsaPrivateCrtKey rsaPrivateCrtKey) {
        SimpleASNWriter simpleASNWriter2 = new SimpleASNWriter();
        simpleASNWriter2.writeByte(2);
        byte[] byArray = new byte[1];
        simpleASNWriter2.writeData(byArray);
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(rsaPrivateCrtKey.getModulus().toByteArray());
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(rsaPrivateCrtKey.getPublicExponent().toByteArray());
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(rsaPrivateCrtKey.getPrivateExponent().toByteArray());
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(rsaPrivateCrtKey.getPrimeP().toByteArray());
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(rsaPrivateCrtKey.getPrimeQ().toByteArray());
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(rsaPrivateCrtKey.getPrimeExponentP().toByteArray());
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(rsaPrivateCrtKey.getPrimeExponentQ().toByteArray());
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(rsaPrivateCrtKey.getCrtCoefficient().toByteArray());
        byte[] byArray2 = simpleASNWriter2.toByteArray();
        simpleASNWriter.writeByte(48);
        simpleASNWriter.writeData(byArray2);
    }

    public byte[] A(SshKeyPair sshKeyPair, String string) throws IOException {
        byte[] byArray;
        C c = new C();
        SimpleASNWriter simpleASNWriter = new SimpleASNWriter();
        if (sshKeyPair.getPublicKey() instanceof Ssh2DsaPublicKey) {
            this.A(simpleASNWriter, (DsaPrivateKey)sshKeyPair.getPrivateKey(), (DsaPublicKey)sshKeyPair.getPublicKey());
            byArray = simpleASNWriter.toByteArray();
            c.A("DSA PRIVATE KEY");
        } else if (sshKeyPair.getPrivateKey() instanceof RsaPrivateCrtKey) {
            this.A(simpleASNWriter, (RsaPrivateCrtKey)sshKeyPair.getPrivateKey());
            byArray = simpleASNWriter.toByteArray();
            c.A("RSA PRIVATE KEY");
        } else {
            throw new IOException(sshKeyPair.getPublicKey().getAlgorithm() + " is not supported");
        }
        c.A(byArray, string);
        StringWriter stringWriter = new StringWriter();
        c.A(stringWriter);
        return stringWriter.toString().getBytes("US-ASCII");
    }

    public void changePassphrase(String string, String string2) throws IOException, InvalidPassphraseException {
        SshKeyPair sshKeyPair = this.toKeyPair(string);
        this.L = this.A(sshKeyPair, string2);
    }

    public byte[] getFormattedKey() {
        return this.L;
    }

    public static boolean C(byte[] byArray) {
        try {
            StringReader stringReader = new StringReader(new String(byArray, "US-ASCII"));
            E e = new E(stringReader);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

