/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh2;

import com.maverick.crypto.digests.Hash;
import com.maverick.crypto.io.ByteArrayReader;
import com.maverick.crypto.io.ByteArrayWriter;
import com.maverick.crypto.security.SecureRandom;
import com.maverick.ssh.SshException;
import com.maverick.ssh.SshPublicKey;
import com.maverick.ssh.SshTransport;
import com.maverick.ssh.cipher.SshCipher;
import com.maverick.ssh.compression.SshCompression;
import com.maverick.ssh.message.SshMessageReader;
import com.maverick.ssh2.Ssh2Context;
import com.maverick.ssh2.SshHmac;
import com.maverick.ssh2.SshKeyExchange;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class TransportProtocol
implements SshMessageReader {
    public static String CHARSET_ENCODING = "UTF8";
    DataInputStream x;
    OutputStream \u00c9;
    SshTransport \u00a4;
    SecureRandom \u00cf;
    Ssh2Context \u00b5;
    String \u00c7;
    String \u00ba;
    byte[] \u00d3;
    byte[] n;
    byte[] \u00d5;
    static final int \u00cb = 1;
    static final int \u00ca = 2;
    static final int z = 3;
    static final int p = 4;
    static final int r = 5;
    static final int k = 6;
    static final int t = 20;
    static final int \u00a2 = 21;
    public static final int NEGOTIATING_PROTOCOL = 1;
    public static final int PERFORMING_KEYEXCHANGE = 2;
    public static final int CONNECTED = 3;
    public static final int DISCONNECTED = 4;
    int \u00aa;
    Throwable i;
    String o;
    SshKeyExchange \u00d4;
    SshCipher \u00cc;
    SshCipher \u00c5;
    SshHmac v;
    SshHmac \u00c1;
    SshCompression \u00d2;
    SshCompression \u00a5;
    SshPublicKey l;
    int h = 8;
    int w = 0;
    byte[] m;
    ByteArrayWriter y;
    int \u00c3 = 8;
    int \u00d1 = 0;
    long \u00cd = 0L;
    long \u00d0 = 0L;
    static final int u = Integer.MAX_VALUE;
    static final int \u00a3 = 0x40000000;
    int s;
    int \u00c6;
    int \u00c4;
    int \u00c2;
    long \u00ce = 0L;
    long q = 0L;
    Object \u00c0 = new Object();
    Vector \u00c8 = new Vector();
    Vector j = new Vector();
    public static final int HOST_NOT_ALLOWED = 1;
    public static final int PROTOCOL_ERROR = 2;
    public static final int KEY_EXCHANGE_FAILED = 3;
    public static final int RESERVED = 4;
    public static final int MAC_ERROR = 5;
    public static final int COMPRESSION_ERROR = 6;
    public static final int SERVICE_NOT_AVAILABLE = 7;
    public static final int PROTOCOL_VERSION_NOT_SUPPORTED = 8;
    public static final int HOST_KEY_NOT_VERIFIABLE = 9;
    public static final int CONNECTION_LOST = 10;
    public static final int BY_APPLICATION = 11;
    public static final int TOO_MANY_CONNECTIONS = 12;
    public static final int AUTH_CANCELLED_BY_USER = 13;
    public static final int NO_MORE_AUTH_METHODS_AVAILABLE = 14;
    public static final int ILLEGAL_USER_NAME = 15;

    public TransportProtocol() throws SshException {
        this.\u00cf = SecureRandom.getInstance();
    }

    public boolean isConnected() {
        return this.\u00aa == 3 || this.\u00aa == 2;
    }

    public Throwable getLastError() {
        return this.i;
    }

    public void startTransportProtocol(SshTransport sshTransport, Ssh2Context ssh2Context, String string, String string2) throws SshException {
        try {
            this.x = new DataInputStream(sshTransport.getInputStream());
            this.\u00c9 = sshTransport.getOutputStream();
            this.\u00a4 = sshTransport;
            this.\u00c7 = string;
            this.\u00ba = string2;
            this.\u00b5 = ssh2Context;
            this.m = new byte[this.\u00b5.getMaximumPacketLength()];
            this.y = new ByteArrayWriter(this.\u00b5.getMaximumPacketLength());
            this.\u00aa = 1;
            this.H();
            while (this.processMessage(this.I()) && this.\u00aa != 3) {
            }
        }
        catch (IOException iOException) {
            throw new SshException(iOException.getMessage(), 10);
        }
    }

    public String getRemoteIdentification() {
        return this.\u00ba;
    }

    public byte[] getSessionIdentifier() {
        return this.\u00d5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(int n, String string) {
        try {
            this.o = string;
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.write(1);
            byteArrayWriter.writeInt(n);
            byteArrayWriter.writeString(string);
            byteArrayWriter.writeString("");
            this.sendMessage(byteArrayWriter.toByteArray());
        }
        catch (Throwable throwable) {
        }
        finally {
            this.J();
        }
    }

    public SecureRandom getRND() {
        return this.\u00cf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(byte[] byArray) throws SshException {
        if (this.\u00aa == 2 && !this.B(byArray[0])) {
            Vector vector = this.\u00c8;
            synchronized (vector) {
                this.\u00c8.addElement(byArray);
                return;
            }
        }
        OutputStream outputStream = this.\u00c9;
        synchronized (outputStream) {
            try {
                this.y.reset();
                int n = 4;
                if (this.\u00d2 != null) {
                    byArray = this.\u00d2.compress(byArray, 0, byArray.length);
                }
                n += (this.h - (byArray.length + 5 + n) % this.h) % this.h;
                this.y.writeInt(byArray.length + 1 + n);
                this.y.write(n);
                this.y.write(byArray, 0, byArray.length);
                this.\u00cf.nextBytes(this.y.array(), this.y.size(), n);
                this.y.move(n);
                if (this.v != null) {
                    this.v.generate(this.\u00cd, this.y.array(), 0, this.y.size(), this.y.array(), this.y.size());
                }
                if (this.\u00cc != null) {
                    this.\u00cc.transform(this.y.array(), 0, this.y.array(), 0, this.y.size());
                }
                this.y.move(this.w);
                this.\u00ce += (long)this.y.size();
                this.\u00c9.write(this.y.array(), 0, this.y.size());
                this.\u00c9.flush();
                ++this.\u00cd;
                this.\u00c4 += byArray.length;
                ++this.\u00c2;
                if (this.\u00cd >= 0x100000000L) {
                    this.\u00cd = 0L;
                }
                if (this.\u00c4 >= 0x40000000 || this.\u00c2 >= Integer.MAX_VALUE) {
                    this.H();
                }
            }
            catch (IOException iOException) {
                this.J();
                throw new SshException("Unexpected termination: " + iOException.getMessage(), 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] nextMessage() throws SshException {
        Object object = this.\u00c0;
        synchronized (object) {
            byte[] byArray;
            while (this.processMessage(byArray = this.I())) {
            }
            return byArray;
        }
    }

    byte[] I() throws SshException {
        Object object = this.\u00c0;
        synchronized (object) {
            try {
                byte[] byArray;
                this.x.readFully(this.m, 0, this.\u00c3);
                if (this.\u00c5 != null) {
                    this.\u00c5.transform(this.m, 0, this.m, 0, this.\u00c3);
                }
                int n = (int)ByteArrayReader.readInt((byte[])this.m, (int)0);
                int n2 = this.m[4] & 0xFF;
                int n3 = n - (this.\u00c3 - 4);
                if (n3 < 0) {
                    this.J();
                    throw new SshException("EOF whilst reading message data block", 1);
                }
                if (n3 > this.m.length - this.\u00c3) {
                    if (n3 + this.\u00c3 + this.\u00d1 > this.\u00b5.getMaximumPacketLength()) {
                        this.J();
                        throw new SshException("Incoming packet length violates SSH protocol [" + n3 + this.\u00c3 + " bytes]", 1);
                    }
                    byArray = new byte[n3 + this.\u00c3 + this.\u00d1];
                    System.arraycopy(this.m, 0, byArray, 0, this.\u00c3);
                    this.m = byArray;
                }
                if (n3 > 0) {
                    this.x.readFully(this.m, this.\u00c3, n3);
                    if (this.\u00c5 != null) {
                        this.\u00c5.transform(this.m, this.\u00c3, this.m, this.\u00c3, n3);
                    }
                }
                if (this.\u00c1 != null) {
                    this.x.readFully(this.m, this.\u00c3 + n3, this.\u00d1);
                    if (!this.\u00c1.verify(this.\u00d0, this.m, 0, this.\u00c3 + n3, this.m, this.\u00c3 + n3)) {
                        this.disconnect(5, "Corrupt Mac on input");
                        throw new SshException("Corrupt Mac on input", 3);
                    }
                }
                if (++this.\u00d0 >= 0x100000000L) {
                    this.\u00d0 = 0L;
                }
                this.q += (long)(this.\u00c3 + n3 + this.\u00d1);
                byArray = new byte[n + 4 - n2 - 5];
                System.arraycopy(this.m, 5, byArray, 0, byArray.length);
                if (this.\u00a5 != null) {
                    return this.\u00a5.uncompress(byArray, 0, byArray.length);
                }
                this.s += byArray.length;
                ++this.\u00c6;
                if (this.s >= 0x40000000 || this.\u00c6 >= Integer.MAX_VALUE) {
                    this.H();
                }
                return byArray;
            }
            catch (IOException iOException) {
                this.J();
                throw new SshException("Unexpected terminaton: " + (iOException.getMessage() != null ? iOException.getMessage() : iOException.getClass().getName()) + " sequenceNo = " + this.\u00d0 + " bytesIn = " + this.q + " bytesOut = " + this.\u00ce, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void C(byte[] byArray) throws SshException {
        try {
            Object object = this.\u00c0;
            synchronized (object) {
                SshCompression sshCompression;
                if (this.\u00d3 == null) {
                    this.H();
                }
                this.\u00aa = 2;
                this.n = byArray;
                ByteArrayReader byteArrayReader = new ByteArrayReader(this.n, 0, this.n.length);
                byteArrayReader.skip(17L);
                String string = byteArrayReader.readString();
                this.\u00d4 = (SshKeyExchange)this.\u00b5.supportedKeyExchanges().getInstance(this.A(this.\u00b5.supportedKeyExchanges().list(this.\u00b5.getPreferredKeyExchange()), string));
                this.\u00d4.init(this);
                String string2 = byteArrayReader.readString();
                String string3 = this.A(this.\u00b5.supportedCiphers().list(this.\u00b5.getPreferredCipherCS()), byteArrayReader.readString());
                String string4 = this.A(this.\u00b5.supportedCiphers().list(this.\u00b5.getPreferredCipherSC()), byteArrayReader.readString());
                SshCipher sshCipher = (SshCipher)this.\u00b5.supportedCiphers().getInstance(string3);
                SshCipher sshCipher2 = (SshCipher)this.\u00b5.supportedCiphers().getInstance(string4);
                String string5 = this.A(this.\u00b5.supportedMacs().list(this.\u00b5.getPreferredMacCS()), byteArrayReader.readString());
                String string6 = this.A(this.\u00b5.supportedMacs().list(this.\u00b5.getPreferredMacSC()), byteArrayReader.readString());
                SshHmac sshHmac = (SshHmac)this.\u00b5.supportedMacs().getInstance(string5);
                SshHmac sshHmac2 = (SshHmac)this.\u00b5.supportedMacs().getInstance(string6);
                String string7 = this.A(this.\u00b5.supportedCompressions().list(this.\u00b5.getPreferredCompressionCS()), byteArrayReader.readString());
                String string8 = this.A(this.\u00b5.supportedCompressions().list(this.\u00b5.getPreferredCompressionSC()), byteArrayReader.readString());
                SshCompression sshCompression2 = (SshCompression)this.\u00b5.supportedCompressions().getInstance(string7);
                if (sshCompression2 != null) {
                    sshCompression2.init(1, 6);
                }
                if ((sshCompression = (SshCompression)this.\u00b5.supportedCompressions().getInstance(string8)) != null) {
                    sshCompression.init(0, 6);
                }
                String string9 = byteArrayReader.readString();
                string9 = byteArrayReader.readString();
                this.\u00d4.performClientExchange(this.\u00c7, this.\u00ba, this.\u00d3, this.n);
                this.l = (SshPublicKey)this.\u00b5.supportedPublicKeys().getInstance(this.A(this.\u00b5.supportedPublicKeys().list(this.\u00b5.getPreferredPublicKey()), string2));
                this.l.init(this.\u00d4.getHostKey(), 0, this.\u00d4.getHostKey().length);
                if (this.\u00b5.getHostKeyVerification() != null) {
                    if (!this.\u00b5.getHostKeyVerification().verifyHost(this.\u00a4.getHost(), this.l)) {
                        this.disconnect(9, "Host key not accepted");
                        throw new SshException("The host key was not accepted", 8);
                    }
                    if (!this.l.verifySignature(this.\u00d4.getSignature(), this.\u00d4.getExchangeHash())) {
                        this.disconnect(9, "Invalid host key signature");
                        throw new SshException("The host key signature is invalid", 3);
                    }
                }
                if (this.\u00d5 == null) {
                    this.\u00d5 = this.\u00d4.getExchangeHash();
                }
                this.sendMessage(new byte[]{21});
                sshCipher.init(0, this.A('A'), this.A('C'));
                this.h = sshCipher.getBlockSize();
                sshHmac.init(this.A('E'));
                this.w = sshHmac.getMacLength();
                this.\u00cc = sshCipher;
                this.v = sshHmac;
                this.\u00d2 = sshCompression2;
                do {
                    if (this.processMessage(byArray = this.I())) continue;
                    this.disconnect(2, "Invalid message received");
                    throw new SshException("Invalid message received during key exchange", 3);
                } while (byArray[0] != 21);
                sshCipher2.init(1, this.A('B'), this.A('D'));
                this.\u00c3 = sshCipher2.getBlockSize();
                sshHmac2.init(this.A('F'));
                this.\u00d1 = sshHmac2.getMacLength();
                this.\u00c5 = sshCipher2;
                this.\u00c1 = sshHmac2;
                this.\u00a5 = sshCompression;
                this.\u00aa = 3;
                Vector vector = this.\u00c8;
                synchronized (vector) {
                    Enumeration enumeration = this.\u00c8.elements();
                    while (enumeration.hasMoreElements()) {
                        this.sendMessage((byte[])enumeration.nextElement());
                    }
                    this.\u00c8.removeAllElements();
                }
                this.\u00d3 = null;
                this.n = null;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw new SshException(classNotFoundException.getMessage(), 5);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new SshException(iOException.getMessage(), 5);
        }
        catch (SshException sshException) {
            sshException.printStackTrace();
            throw sshException;
        }
    }

    public void startService(String string) throws SshException {
        try {
            byte[] byArray;
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.write(5);
            byteArrayWriter.writeString(string);
            this.sendMessage(byteArrayWriter.toByteArray());
            while (this.processMessage(byArray = this.I()) || byArray[0] != 6) {
            }
        }
        catch (IOException iOException) {
            throw new SshException(iOException.getMessage(), 5);
        }
    }

    void J() {
        this.\u00aa = 4;
        try {
            this.\u00a4.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (int i = 0; i < this.j.size(); ++i) {
            try {
                ((Runnable)this.j.elementAt(i)).run();
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    void A(Runnable runnable) {
        if (runnable != null) {
            this.j.addElement(runnable);
        }
    }

    public boolean processMessage(byte[] byArray) throws SshException {
        try {
            if (byArray.length < 1) {
                this.disconnect(2, "Invalid message received");
                throw new SshException("Invalid transport protocol message", 5);
            }
            switch (byArray[0]) {
                case 1: {
                    this.J();
                    ByteArrayReader byteArrayReader = new ByteArrayReader(byArray, 5, byArray.length - 5);
                    throw new SshException(byteArrayReader.readString(), 2);
                }
                case 2: 
                case 4: 
                case 21: {
                    return true;
                }
                case 20: {
                    if (this.n != null) {
                        this.disconnect(2, "Key exchange already in progress!");
                        throw new SshException("Key exchange already in progress!", 3);
                    }
                    this.C(byArray);
                    return true;
                }
            }
            return false;
        }
        catch (IOException iOException) {
            throw new SshException(iOException.getMessage(), 5);
        }
    }

    boolean B(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 20: 
            case 21: {
                return true;
            }
        }
        if (this.\u00d4 != null) {
            return this.\u00d4.isKeyExchangeMessage(n);
        }
        return false;
    }

    String A(String string, String string2) throws SshException {
        int n;
        Vector<String> vector = new Vector<String>();
        while ((n = string2.indexOf(",")) > -1) {
            vector.addElement(string2.substring(0, n));
            string2 = string2.substring(n + 1);
        }
        vector.addElement(string2);
        while ((n = string.indexOf(",")) > -1) {
            String string3 = string.substring(0, n);
            if (vector.contains(string3)) {
                return string3;
            }
            string = string.substring(n + 1);
        }
        if (vector.contains(string)) {
            return string;
        }
        throw new SshException("Failed to negotiate a transport component [" + string + "] [" + string2 + "]", 9);
    }

    void H() throws SshException {
        try {
            this.s = 0;
            this.\u00c6 = 0;
            this.\u00c4 = 0;
            this.\u00c2 = 0;
            this.\u00aa = 2;
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byte[] byArray = new byte[16];
            this.\u00cf.nextBytes(byArray);
            byteArrayWriter.write(20);
            byteArrayWriter.write(byArray);
            byteArrayWriter.writeString(this.\u00b5.supportedKeyExchanges().list(this.\u00b5.getPreferredKeyExchange()));
            byteArrayWriter.writeString(this.\u00b5.supportedPublicKeys().list(this.\u00b5.getPreferredPublicKey()));
            byteArrayWriter.writeString(this.\u00b5.supportedCiphers().list(this.\u00b5.getPreferredCipherCS()));
            byteArrayWriter.writeString(this.\u00b5.supportedCiphers().list(this.\u00b5.getPreferredCipherSC()));
            byteArrayWriter.writeString(this.\u00b5.supportedMacs().list(this.\u00b5.getPreferredMacCS()));
            byteArrayWriter.writeString(this.\u00b5.supportedMacs().list(this.\u00b5.getPreferredMacSC()));
            byteArrayWriter.writeString(this.\u00b5.supportedCompressions().list(this.\u00b5.getPreferredCompressionCS()));
            byteArrayWriter.writeString(this.\u00b5.supportedCompressions().list(this.\u00b5.getPreferredCompressionSC()));
            byteArrayWriter.writeString("");
            byteArrayWriter.writeString("");
            byteArrayWriter.write(0);
            byteArrayWriter.writeInt(0);
            this.\u00d3 = byteArrayWriter.toByteArray();
            this.sendMessage(this.\u00d3);
        }
        catch (IOException iOException) {
            throw new SshException(iOException.getMessage(), 5);
        }
    }

    byte[] A(char c) throws IOException {
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byte[] byArray = new byte[20];
        Hash hash = new Hash("SHA-1");
        hash.putBigInteger(this.\u00d4.getSecret());
        hash.putBytes(this.\u00d4.getExchangeHash());
        hash.putByte((byte)c);
        hash.putBytes(this.\u00d5);
        byArray = hash.doFinal();
        byteArrayWriter.write(byArray);
        hash.reset();
        hash.putBigInteger(this.\u00d4.getSecret());
        hash.putBytes(this.\u00d4.getExchangeHash());
        hash.putBytes(byArray);
        byArray = hash.doFinal();
        byteArrayWriter.write(byArray);
        return byteArrayWriter.toByteArray();
    }
}

