/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver.runtime.java.lang;

public class Integer_ {
    public static final int SIZE = 32;

    private Integer_() {
    }

    public static int highestOneBit(int i) {
        i |= i >> 1;
        i |= i >> 2;
        i |= i >> 4;
        i |= i >> 8;
        i |= i >> 16;
        return i & ~(i >>> 1);
    }

    public static int lowestOneBit(int i) {
        return i & -i;
    }

    public static int numberOfLeadingZeros(int i) {
        i |= i >> 1;
        i |= i >> 2;
        i |= i >> 4;
        i |= i >> 8;
        i |= i >> 16;
        return Integer_.bitCount(~i);
    }

    public static int numberOfTrailingZeros(int i) {
        return Integer_.bitCount((i & -i) - 1);
    }

    public static int bitCount(int i) {
        i -= i >> 1 & 0x55555555;
        i = (i & 0x33333333) + (i >> 2 & 0x33333333);
        i = (i >> 4) + i & 0xF0F0F0F;
        i += i >> 8;
        i += i >> 16;
        return i & 0x3F;
    }

    public static int rotateLeft(int i, int distance) {
        if (distance == 0) {
            return i;
        }
        return i << distance | i >>> -distance;
    }

    public static int rotateRight(int i, int distance) {
        if (distance == 0) {
            return i;
        }
        return i >>> distance | i << -distance;
    }

    public static int reverseBytes(int i) {
        int b3 = i >>> 24;
        int b2 = i >>> 8 & 0xFF00;
        int b1 = (i & 0xFF00) << 8;
        int b0 = i << 24;
        return b0 | b1 | b2 | b3;
    }

    public static int reverse(int i) {
        i = (i & 0x55555555) << 1 | i >> 1 & 0x55555555;
        i = (i & 0x33333333) << 2 | i >> 2 & 0x33333333;
        i = (i & 0xF0F0F0F) << 4 | i >> 4 & 0xF0F0F0F;
        return Integer_.reverseBytes(i);
    }

    public static int signum(int i) {
        return i == 0 ? 0 : (i < 0 ? -1 : 1);
    }

    public static Integer valueOf(int i) {
        if (i < -128 || i > 127) {
            return new Integer(i);
        }
        return valueOfCache.CACHE[i + 128];
    }

    static class valueOfCache {
        static final Integer[] CACHE = new Integer[256];

        valueOfCache() {
        }

        static {
            for (int i = -128; i <= 127; ++i) {
                valueOfCache.CACHE[i + 128] = new Integer(i);
            }
        }
    }
}

