/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver.runtime.java.lang;

public class Double_ {
    private Double_() {
    }

    public static Double valueOf(double val) {
        return new Double(val);
    }

    public static String toHexString(double d) {
        if (d != d) {
            return "NaN";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "Infinity";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-Infinity";
        }
        long bitValue = Double.doubleToLongBits(d);
        boolean negative = (bitValue & Long.MIN_VALUE) != 0L;
        long exponent = (bitValue & 0x7FF0000000000000L) >>> 52;
        long significand = bitValue & 0xFFFFFFFFFFFFFL;
        if (exponent == 0L && significand == 0L) {
            return negative ? "-0x0.0p0" : "0x0.0p0";
        }
        StringBuffer hexString = new StringBuffer(10);
        if (negative) {
            hexString.append("-0x");
        } else {
            hexString.append("0x");
        }
        if (exponent == 0L) {
            hexString.append("0.");
            int fractionDigits = 13;
            while (significand != 0L && (significand & 0xFL) == 0L) {
                significand >>>= 4;
                --fractionDigits;
            }
            String hexSignificand = Long.toHexString(significand);
            if (significand != 0L && fractionDigits > hexSignificand.length()) {
                int digitDiff = fractionDigits - hexSignificand.length();
                while (digitDiff-- != 0) {
                    hexString.append('0');
                }
            }
            hexString.append(hexSignificand);
            hexString.append("p-1022");
        } else {
            hexString.append("1.");
            int fractionDigits = 13;
            while (significand != 0L && (significand & 0xFL) == 0L) {
                significand >>>= 4;
                --fractionDigits;
            }
            String hexSignificand = Long.toHexString(significand);
            if (significand != 0L && fractionDigits > hexSignificand.length()) {
                int digitDiff = fractionDigits - hexSignificand.length();
                while (digitDiff-- != 0) {
                    hexString.append('0');
                }
            }
            hexString.append(hexSignificand);
            hexString.append('p');
            hexString.append(Long.toString(exponent - 1023L));
        }
        return hexString.toString();
    }
}

