/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.util;

import java.io.IOException;

public class SimpleASNReader {
    private byte[] A;
    private int B;

    public SimpleASNReader(byte[] byArray) {
        this.A = byArray;
        this.B = 0;
    }

    public void assertByte(int n) throws IOException {
        int n2 = this.getByte();
        if (n2 != n) {
            throw new IOException("Assertion failed, next byte value is " + Integer.toHexString(n2) + " instead of asserted " + Integer.toHexString(n));
        }
    }

    public int getByte() {
        return this.A[this.B++] & 0xFF;
    }

    public byte[] getData() {
        int n = this.getLength();
        return this.A(n);
    }

    public int getLength() {
        int n;
        if (((n = this.A[this.B++] & 0xFF) & 0x80) != 0) {
            int n2 = 0;
            for (int i = n & 0x7F; i > 0; --i) {
                n2 <<= 8;
                n2 |= this.A[this.B++] & 0xFF;
            }
            return n2;
        }
        return n;
    }

    private byte[] A(int n) {
        byte[] byArray = new byte[n];
        System.arraycopy(this.A, this.B, byArray, 0, n);
        this.B += n;
        return byArray;
    }

    public boolean hasMoreData() {
        return this.B < this.A.length;
    }
}

