/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOUtil {
    public static boolean closeStream(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean closeStream(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean delTree(File file) {
        if (file.isFile()) {
            return file.delete();
        }
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            if (IOUtil.delTree(new File(file, stringArray[i]))) continue;
            return false;
        }
        return true;
    }

    public static void recurseDeleteDirectory(File file) {
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            if (file2.isDirectory()) {
                IOUtil.recurseDeleteDirectory(file2);
            }
            file2.delete();
        }
        file.delete();
    }

    public static void copyFile(File file, File file2) throws IOException {
        if (file.isDirectory()) {
            if (!file2.exists()) {
                file2.mkdir();
            }
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                File file3 = new File(file, stringArray[i]);
                if (file3.getName().equals(".") || file3.getName().equals("..")) continue;
                if (file3.isDirectory()) {
                    File file4 = new File(file2, file3.getName());
                    IOUtil.copyFile(file3, file4);
                    continue;
                }
                IOUtil.copyFile(file3, file2);
            }
        } else if (file.isFile() && (file2.isDirectory() || file2.isFile())) {
            int n;
            if (file2.isDirectory()) {
                file2 = new File(file2, file.getName());
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[32678];
            while ((n = fileInputStream.read(byArray)) > -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            IOUtil.closeStream(fileInputStream);
            IOUtil.closeStream(fileOutputStream);
        }
    }
}

