/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.util;

import com.sshtools.util.A;
import com.sshtools.util.B;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class EOLProcessor {
    public static final int TEXT_SYSTEM = 0;
    public static final int TEXT_WINDOWS = 1;
    public static final int TEXT_DOS = 1;
    public static final int TEXT_CRLF = 1;
    public static final int TEXT_UNIX = 2;
    public static final int TEXT_LF = 2;
    public static final int TEXT_MAC = 3;
    public static final int TEXT_CR = 3;
    public static final int TEXT_ALL = 4;
    byte[] C;
    String H = System.getProperty("line.separator");
    boolean B = false;
    boolean F = false;
    boolean G = false;
    boolean E = false;
    boolean A = false;
    OutputStream D;

    public EOLProcessor(int n, int n2, OutputStream outputStream) throws IOException {
        this.D = outputStream;
        switch (n) {
            case 1: {
                this.G = true;
                break;
            }
            case 3: {
                this.B = true;
                break;
            }
            case 2: {
                this.F = true;
                break;
            }
            case 4: {
                this.B = true;
                this.F = true;
                this.G = true;
                break;
            }
            case 0: {
                byte[] byArray = this.H.getBytes();
                if (byArray.length == 2 && byArray[0] == 13 && byArray[1] == 10) {
                    this.G = true;
                    break;
                }
                if (byArray.length == 1 && byArray[0] == 13) {
                    this.B = true;
                    break;
                }
                if (byArray.length == 1 && byArray[0] == 10) {
                    this.F = true;
                    break;
                }
                throw new IOException("Unsupported system EOL mode");
            }
            default: {
                throw new IllegalArgumentException("Unknown text style: " + n2);
            }
        }
        switch (n2) {
            case 0: {
                this.C = this.H.getBytes();
                break;
            }
            case 1: {
                this.C = new byte[]{13, 10};
                break;
            }
            case 3: {
                this.C = new byte[]{13};
                break;
            }
            case 2: {
                this.C = new byte[]{10};
                break;
            }
            case 4: {
                throw new IllegalArgumentException("TEXT_ALL cannot be used for an output style");
            }
            default: {
                throw new IllegalArgumentException("Unknown text style: " + n2);
            }
        }
    }

    public boolean hasBinary() {
        return this.E;
    }

    public void close() throws IOException {
        if (this.A && !this.B) {
            this.D.write(13);
        }
    }

    public void processBytes(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byArray, n, n2), 32768);
        while ((n3 = bufferedInputStream.read()) != -1) {
            if (n3 == 13) {
                if (this.G) {
                    bufferedInputStream.mark(1);
                    int n4 = bufferedInputStream.read();
                    if (n4 == -1) {
                        this.A = true;
                        break;
                    }
                    if (n4 == 10) {
                        this.D.write(this.C);
                        continue;
                    }
                    bufferedInputStream.reset();
                    if (this.B) {
                        this.D.write(this.C);
                        continue;
                    }
                    this.D.write(n3);
                    continue;
                }
                if (this.B) {
                    this.D.write(this.C);
                    continue;
                }
                this.D.write(n3);
                continue;
            }
            if (n3 == 10) {
                if (this.A) {
                    this.D.write(this.C);
                    this.A = false;
                    continue;
                }
                if (this.F) {
                    this.D.write(this.C);
                    continue;
                }
                this.D.write(n3);
                continue;
            }
            if (this.A) {
                if (this.B) {
                    this.D.write(this.C);
                } else {
                    this.D.write(n3);
                }
            }
            if (n3 != 116 && n3 != 12 && (n3 & 0xFF) < 32) {
                this.E = true;
            }
            this.D.write(n3);
        }
    }

    public static OutputStream createOutputStream(int n, int n2, OutputStream outputStream) throws IOException {
        return new A(n, n2, outputStream);
    }

    public static InputStream createInputStream(int n, int n2, InputStream inputStream) throws IOException {
        return new B(n, n2, inputStream);
    }
}

