/*
 * Decompiled with CFR 0.152.
 */
package nl.siegmann.epublib.epub;

import java.util.ArrayList;
import java.util.List;
import nl.siegmann.epublib.util.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class DOMUtil {
    DOMUtil() {
    }

    public static String getAttribute(Element element, String namespace, String attribute) {
        String result = element.getAttributeNS(namespace, attribute);
        if (StringUtil.isEmpty(result)) {
            result = element.getAttribute(attribute);
        }
        return result;
    }

    public static List<String> getElementsTextChild(Element parentElement, String namespace, String tagname) {
        NodeList elements = parentElement.getElementsByTagNameNS(namespace, tagname);
        ArrayList<String> result = new ArrayList<String>(elements.getLength());
        int i = 0;
        while (i < elements.getLength()) {
            result.add(DOMUtil.getTextChildrenContent((Element)elements.item(i)));
            ++i;
        }
        return result;
    }

    public static String getFindAttributeValue(Document document, String namespace, String elementName, String findAttributeName, String findAttributeValue, String resultAttributeName) {
        NodeList metaTags = document.getElementsByTagNameNS(namespace, elementName);
        int i = 0;
        while (i < metaTags.getLength()) {
            Element metaElement = (Element)metaTags.item(i);
            if (findAttributeValue.equalsIgnoreCase(metaElement.getAttribute(findAttributeName)) && StringUtil.isNotBlank(metaElement.getAttribute(resultAttributeName))) {
                return metaElement.getAttribute(resultAttributeName);
            }
            ++i;
        }
        return null;
    }

    public static Element getFirstElementByTagNameNS(Element parentElement, String namespace, String tagName) {
        NodeList nodes = parentElement.getElementsByTagNameNS(namespace, tagName);
        if (nodes.getLength() == 0) {
            return null;
        }
        return (Element)nodes.item(0);
    }

    public static String getTextChildrenContent(Element parentElement) {
        if (parentElement == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        NodeList childNodes = parentElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node != null && node.getNodeType() == 3) {
                result.append(((Text)node).getData());
            }
            ++i;
        }
        return result.toString().trim();
    }
}

