/*
 * Decompiled with CFR 0.152.
 */
package nl.siegmann.epublib.domain;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import nl.siegmann.epublib.domain.MediaType;
import nl.siegmann.epublib.domain.ResourceInputStream;
import nl.siegmann.epublib.service.MediatypeService;
import nl.siegmann.epublib.util.IOUtil;
import nl.siegmann.epublib.util.StringUtil;
import nl.siegmann.epublib.util.commons.io.XmlStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resource
implements Serializable {
    private static final long serialVersionUID = 1043946707835004037L;
    private String id;
    private String title;
    private String href;
    private String originalHref;
    private MediaType mediaType;
    private String inputEncoding = "UTF-8";
    private byte[] data;
    private String fileName;
    private long cachedSize;
    private static final Logger LOG = LoggerFactory.getLogger(Resource.class);

    public Resource(String href) {
        this(null, new byte[0], href, MediatypeService.determineMediaType(href));
    }

    public Resource(byte[] data, MediaType mediaType) {
        this(null, data, null, mediaType);
    }

    public Resource(byte[] data, String href) {
        this(null, data, href, MediatypeService.determineMediaType(href), "UTF-8");
    }

    public Resource(Reader in, String href) throws IOException {
        this(null, IOUtil.toByteArray(in, "UTF-8"), href, MediatypeService.determineMediaType(href), "UTF-8");
    }

    public Resource(InputStream in, String href) throws IOException {
        this(null, IOUtil.toByteArray(in), href, MediatypeService.determineMediaType(href));
    }

    public Resource(InputStream in, String fileName, int length, String href) throws IOException {
        this(null, IOUtil.toByteArray(in, length), href, MediatypeService.determineMediaType(href));
        this.fileName = fileName;
        this.cachedSize = length;
    }

    public Resource(String fileName, long size, String href) {
        this(null, null, href, MediatypeService.determineMediaType(href));
        this.fileName = fileName;
        this.cachedSize = size;
    }

    public Resource(String id, byte[] data, String href, MediaType mediaType) {
        this(id, data, href, mediaType, "UTF-8");
    }

    public Resource(String id, byte[] data, String href, MediaType mediaType, String inputEncoding) {
        this.id = id;
        this.href = href;
        this.originalHref = href;
        this.mediaType = mediaType;
        this.inputEncoding = inputEncoding;
        this.data = data;
    }

    public InputStream getInputStream() throws IOException {
        if (this.isInitialized()) {
            return new ByteArrayInputStream(this.getData());
        }
        return this.getResourceStream();
    }

    public void initialize() throws IOException {
        this.getData();
    }

    public byte[] getData() throws IOException {
        if (this.data == null) {
            LOG.info("Initializing lazy resource " + this.fileName + "#" + this.href);
            InputStream in = this.getResourceStream();
            byte[] readData = IOUtil.toByteArray(in, (int)this.cachedSize);
            if (readData == null) {
                throw new IOException("Could not lazy-load data.");
            }
            this.data = readData;
            this.data = IOUtil.toByteArray(in);
            in.close();
        }
        return this.data;
    }

    private InputStream getResourceStream() throws FileNotFoundException, IOException {
        ZipFile zipResource = new ZipFile(this.fileName);
        ZipEntry zipEntry = zipResource.getEntry(this.originalHref);
        if (zipEntry == null) {
            zipResource.close();
            throw new IllegalStateException("Cannot find resources href in the epub file");
        }
        return new ResourceInputStream(zipResource.getInputStream(zipEntry), zipResource);
    }

    public void close() {
        if (this.fileName != null) {
            this.data = null;
        }
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public boolean isInitialized() {
        return this.data != null;
    }

    public long getSize() {
        if (this.data != null) {
            return this.data.length;
        }
        return this.cachedSize;
    }

    public String getTitle() {
        return this.title;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String getInputEncoding() {
        return this.inputEncoding;
    }

    public void setInputEncoding(String encoding) {
        this.inputEncoding = encoding;
    }

    public Reader getReader() throws IOException {
        return new XmlStreamReader((InputStream)new ByteArrayInputStream(this.getData()), this.getInputEncoding());
    }

    public int hashCode() {
        return this.href.hashCode();
    }

    public boolean equals(Object resourceObject) {
        if (!(resourceObject instanceof Resource)) {
            return false;
        }
        return this.href.equals(((Resource)resourceObject).getHref());
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String toString() {
        return StringUtil.toString("id", this.id, "title", this.title, "encoding", this.inputEncoding, "mediaType", this.mediaType, "href", this.href, "size", this.data == null ? 0 : this.data.length);
    }
}

