/*
 * Decompiled with CFR 0.152.
 */
package nl.siegmann.epublib.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import nl.siegmann.epublib.domain.GuideReference;
import nl.siegmann.epublib.domain.Resource;
import nl.siegmann.epublib.domain.ResourceReference;

public class Guide
implements Serializable {
    private static final long serialVersionUID = -6256645339915751189L;
    public static final String DEFAULT_COVER_TITLE = GuideReference.COVER;
    private List<GuideReference> references = new ArrayList<GuideReference>();
    private static final int COVERPAGE_NOT_FOUND = -1;
    private static final int COVERPAGE_UNITIALIZED = -2;
    private int coverPageIndex = -1;

    public List<GuideReference> getReferences() {
        return this.references;
    }

    public void setReferences(List<GuideReference> references) {
        this.references = references;
        this.uncheckCoverPage();
    }

    private void uncheckCoverPage() {
        this.coverPageIndex = -2;
    }

    public GuideReference getCoverReference() {
        this.checkCoverPage();
        if (this.coverPageIndex >= 0) {
            return this.references.get(this.coverPageIndex);
        }
        return null;
    }

    public int setCoverReference(GuideReference guideReference) {
        if (this.coverPageIndex >= 0) {
            this.references.set(this.coverPageIndex, guideReference);
        } else {
            this.references.add(0, guideReference);
            this.coverPageIndex = 0;
        }
        return this.coverPageIndex;
    }

    private void checkCoverPage() {
        if (this.coverPageIndex == -2) {
            this.initCoverPage();
        }
    }

    private void initCoverPage() {
        int result = -1;
        int i = 0;
        while (i < this.references.size()) {
            GuideReference guideReference = this.references.get(i);
            if (guideReference.getType().equals(GuideReference.COVER)) {
                result = i;
                break;
            }
            ++i;
        }
        this.coverPageIndex = result;
    }

    public Resource getCoverPage() {
        GuideReference guideReference = this.getCoverReference();
        if (guideReference == null) {
            return null;
        }
        return guideReference.getResource();
    }

    public void setCoverPage(Resource coverPage) {
        GuideReference coverpageGuideReference = new GuideReference(coverPage, GuideReference.COVER, DEFAULT_COVER_TITLE);
        this.setCoverReference(coverpageGuideReference);
    }

    public ResourceReference addReference(GuideReference reference) {
        this.references.add(reference);
        this.uncheckCoverPage();
        return reference;
    }

    public List<GuideReference> getGuideReferencesByType(String referenceTypeName) {
        ArrayList<GuideReference> result = new ArrayList<GuideReference>();
        for (GuideReference guideReference : this.references) {
            if (!referenceTypeName.equalsIgnoreCase(guideReference.getType())) continue;
            result.add(guideReference);
        }
        return result;
    }
}

