/*
 * Decompiled with CFR 0.152.
 */
package nl.siegmann.epublib.domain;

import java.io.Serializable;
import java.text.SimpleDateFormat;

public class Date
implements Serializable {
    private static final long serialVersionUID = 7533866830395120136L;
    private Event event;
    private String dateString;

    public Date(java.util.Date date) {
        this(date, (Event)null);
    }

    public Date(String dateString) {
        this(dateString, (Event)null);
    }

    public Date(java.util.Date date, Event event) {
        this(new SimpleDateFormat("yyyy-MM-dd").format(date), event);
    }

    public Date(String dateString, Event event) {
        this.dateString = dateString;
        this.event = event;
    }

    public Date(java.util.Date date, String event) {
        this(new SimpleDateFormat("yyyy-MM-dd").format(date), event);
    }

    public Date(String dateString, String event) {
        this(Date.checkDate(dateString), Event.fromValue(event));
        this.dateString = dateString;
    }

    private static String checkDate(String dateString) {
        if (dateString == null) {
            throw new IllegalArgumentException("Cannot create a date from a blank string");
        }
        return dateString;
    }

    public String getValue() {
        return this.dateString;
    }

    public Event getEvent() {
        return this.event;
    }

    public void setEvent(Event event) {
        this.event = event;
    }

    public String toString() {
        if (this.event == null) {
            return this.dateString;
        }
        return (Object)((Object)this.event) + ":" + this.dateString;
    }

    public static enum Event {
        PUBLICATION("publication"),
        MODIFICATION("modification"),
        CREATION("creation");

        private final String value;

        private Event(String v) {
            this.value = v;
        }

        public static Event fromValue(String v) {
            Event[] eventArray = Event.values();
            int n = eventArray.length;
            int n2 = 0;
            while (n2 < n) {
                Event c = eventArray[n2];
                if (c.value.equals(v)) {
                    return c;
                }
                ++n2;
            }
            return null;
        }

        public String toString() {
            return this.value;
        }
    }
}

