/*
 * Decompiled with CFR 0.152.
 */
package com.xiaobai.novel;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;

public class FileUtil {
    private static void copyFile(String srcPath, String desPath) {
        try {
            int count;
            FileInputStream in = new FileInputStream(srcPath);
            FileOutputStream out = new FileOutputStream(desPath);
            byte[] bt = new byte[1024];
            while ((count = in.read(bt)) > 0) {
                out.write(bt, 0, count);
            }
            in.close();
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void copyAndReplaceFile(String srcPath, String desPath) throws Exception {
        srcPath = FileUtil.separatorReplace(srcPath);
        desPath = FileUtil.separatorReplace(desPath);
        File srcFile = new File(srcPath);
        if (!srcFile.isFile()) {
            throw new Exception("source file not found!");
        }
        FileUtil.copyFile(srcPath, desPath);
    }

    public static void copyAndNotReplaceFile(String srcPath, String desPath) throws Exception {
        srcPath = FileUtil.separatorReplace(srcPath);
        desPath = FileUtil.separatorReplace(desPath);
        File srcFile = new File(srcPath);
        File desFile = new File(desPath);
        if (!srcFile.isFile()) {
            throw new Exception("source file not found!");
        }
        if (desFile.isFile()) {
            return;
        }
        FileUtil.copyFile(srcPath, desPath);
    }

    public static void moveAndReplaceFile(String srcPath, String desPath) throws Exception {
        srcPath = FileUtil.separatorReplace(srcPath);
        desPath = FileUtil.separatorReplace(desPath);
        FileUtil.copyAndReplaceFile(srcPath, desPath);
        FileUtil.deleteFile(srcPath);
    }

    public static void moveAndNotReplaceFile(String srcPath, String desPath) throws Exception {
        srcPath = FileUtil.separatorReplace(srcPath);
        desPath = FileUtil.separatorReplace(desPath);
        FileUtil.copyAndNotReplaceFile(srcPath, desPath);
        FileUtil.deleteFile(srcPath);
    }

    public static void copyAndMergerFolder(String srcPath, String desPath) throws Exception {
        File[] files;
        srcPath = FileUtil.separatorReplace(srcPath);
        desPath = FileUtil.separatorReplace(desPath);
        File folder = FileUtil.getFolder(srcPath);
        FileUtil.createFolder(desPath);
        File[] fileArray = files = folder.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String src = file.getAbsolutePath();
            String des = String.valueOf(desPath) + File.separator + file.getName();
            if (file.isFile()) {
                FileUtil.copyAndNotReplaceFile(src, des);
            } else if (file.isDirectory()) {
                FileUtil.copyAndMergerFolder(src, des);
            }
            ++n2;
        }
    }

    public static void copyAndReplaceFolder(String srcPath, String desPath) throws Exception {
        File[] files;
        srcPath = FileUtil.separatorReplace(srcPath);
        desPath = FileUtil.separatorReplace(desPath);
        File folder = FileUtil.getFolder(srcPath);
        FileUtil.createNewFolder(desPath);
        File[] fileArray = files = folder.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String src = file.getAbsolutePath();
            String des = String.valueOf(desPath) + File.separator + file.getName();
            if (file.isFile()) {
                FileUtil.copyAndReplaceFile(src, des);
            } else if (file.isDirectory()) {
                FileUtil.copyAndReplaceFolder(src, des);
            }
            ++n2;
        }
    }

    public static void moveAndMergerFolder(String srcPath, String desPath) throws Exception {
        srcPath = FileUtil.separatorReplace(srcPath);
        desPath = FileUtil.separatorReplace(desPath);
        FileUtil.copyAndMergerFolder(srcPath, desPath);
        FileUtil.deleteFolder(srcPath);
    }

    public static void moveAndReplaceFolder(String srcPath, String desPath) throws Exception {
        srcPath = FileUtil.separatorReplace(srcPath);
        desPath = FileUtil.separatorReplace(desPath);
        FileUtil.copyAndReplaceFolder(srcPath, desPath);
        FileUtil.deleteFolder(srcPath);
    }

    public static void createFolder(String path) throws Exception {
        File folder = new File(path = FileUtil.separatorReplace(path));
        if (folder.isDirectory()) {
            return;
        }
        if (folder.isFile()) {
            FileUtil.deleteFile(path);
        }
        folder.mkdirs();
    }

    public static void createNewFolder(String path) throws Exception {
        File folder = new File(path = FileUtil.separatorReplace(path));
        if (folder.isDirectory()) {
            FileUtil.deleteFolder(path);
        } else if (folder.isFile()) {
            FileUtil.deleteFile(path);
        }
        folder.mkdirs();
    }

    public static File createFile(String path) throws Exception {
        File file = new File(path = FileUtil.separatorReplace(path));
        if (file.isFile()) {
            return file;
        }
        if (file.isDirectory()) {
            FileUtil.deleteFolder(path);
        }
        return FileUtil.createFile(file);
    }

    public static File createNewFile(String path) throws Exception {
        File file = new File(path = FileUtil.separatorReplace(path));
        if (file.isFile()) {
            FileUtil.deleteFile(path);
        } else if (file.isDirectory()) {
            FileUtil.deleteFolder(path);
        }
        return FileUtil.createFile(file);
    }

    public static String separatorReplace(String path) {
        return path.replace("\\", "/");
    }

    public static File createFile(File file) throws Exception {
        FileUtil.createParentFolder(file);
        if (!file.createNewFile()) {
            throw new Exception("create file failure!");
        }
        return file;
    }

    private static void createParentFolder(File file) throws Exception {
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new Exception("create parent directory failure!");
        }
    }

    public static void deleteFile(String path) throws Exception {
        File file = FileUtil.getFile(path = FileUtil.separatorReplace(path));
        if (!file.delete()) {
            throw new Exception("delete file failure");
        }
    }

    public static void deleteFile(String dir, String prefix, String suffix) throws Exception {
        File[] files;
        dir = FileUtil.separatorReplace(dir);
        File directory = FileUtil.getFolder(dir);
        File[] fileArray = files = directory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName;
            File file = fileArray[n2];
            if (file.isFile() && (fileName = file.getName()).startsWith(prefix) && fileName.endsWith(suffix)) {
                FileUtil.deleteFile(file.getAbsolutePath());
            }
            ++n2;
        }
    }

    public static void deleteFolder(String path) throws Exception {
        File[] files;
        path = FileUtil.separatorReplace(path);
        File folder = FileUtil.getFolder(path);
        File[] fileArray = files = folder.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                FileUtil.deleteFolder(file.getAbsolutePath());
            } else if (file.isFile()) {
                FileUtil.deleteFile(file.getAbsolutePath());
            }
            ++n2;
        }
        folder.delete();
    }

    public static File searchFile(String dir, String fileName) throws FileNotFoundException {
        File[] files;
        dir = FileUtil.separatorReplace(dir);
        File f = null;
        File folder = FileUtil.getFolder(dir);
        File[] fileArray = files = folder.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                f = FileUtil.searchFile(file.getAbsolutePath(), fileName);
                if (f != null) {
                    break;
                }
            } else if (file.isFile() && file.getName().equals(fileName)) {
                f = file;
                break;
            }
            ++n2;
        }
        return f;
    }

    public static String getFileType(String path) throws FileNotFoundException {
        File file = FileUtil.getFile(path = FileUtil.separatorReplace(path));
        String fileName = file.getName();
        String[] strs = fileName.split("\\.");
        if (strs.length < 2) {
            return "unknownType";
        }
        return strs[strs.length - 1];
    }

    public static long getFileSize(String path) throws FileNotFoundException {
        path = FileUtil.separatorReplace(path);
        File file = FileUtil.getFile(path);
        return file.length();
    }

    public static long getFolderSize(String path) throws FileNotFoundException {
        File[] files;
        path = FileUtil.separatorReplace(path);
        long size = 0L;
        File folder = FileUtil.getFolder(path);
        File[] fileArray = files = folder.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                size += FileUtil.getFolderSize(file.getAbsolutePath());
            } else if (file.isFile()) {
                size += file.length();
            }
            ++n2;
        }
        return size;
    }

    public static File getFile(String path) throws FileNotFoundException {
        File file = new File(path = FileUtil.separatorReplace(path));
        if (!file.isFile()) {
            throw new FileNotFoundException("file not found!");
        }
        return file;
    }

    public static File getFolder(String path) throws FileNotFoundException {
        File folder = new File(path = FileUtil.separatorReplace(path));
        if (!folder.isDirectory()) {
            throw new FileNotFoundException("folder not found!");
        }
        return folder;
    }

    public static Date getFileLastModified(String path) throws FileNotFoundException {
        path = FileUtil.separatorReplace(path);
        File file = FileUtil.getFile(path);
        return new Date(file.lastModified());
    }

    public static Date getFolderLastModified(String path) throws FileNotFoundException {
        path = FileUtil.separatorReplace(path);
        File folder = FileUtil.getFolder(path);
        return new Date(folder.lastModified());
    }

    public static void writeFile2(String path, ArrayList<String> list) throws IOException {
        FileOutputStream fos = new FileOutputStream(new File(path));
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
        BufferedWriter bw = new BufferedWriter(osw);
        for (String arr : list) {
            bw.write(String.valueOf(arr) + "\r\n");
        }
        bw.close();
        osw.close();
        fos.close();
        System.out.println("\u6536\u96c6\u5b8c\u6210");
    }
}

