/*
 * Decompiled with CFR 0.152.
 */
package com.xiaobai.novel;

import com.xiaobai.novel.GetPassage;
import com.xiaobai.novel.Info;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import nl.siegmann.epublib.domain.Author;
import nl.siegmann.epublib.domain.Book;
import nl.siegmann.epublib.domain.Resource;
import nl.siegmann.epublib.epub.EpubWriter;

public class Epub {
    String projecPath = String.valueOf(this.getProjectPath()) + "\\epub\\";

    public void getInputSteam(String[] str, String title, int a) throws IOException {
        InputStream file = this.getClass().getResourceAsStream("/epub.html");
        ArrayList<String> input = new ArrayList<String>();
        InputStreamReader isr = new InputStreamReader(file, "UTF-8");
        BufferedReader br = new BufferedReader(isr);
        String line = "";
        String splis = "";
        while ((line = br.readLine()) != null) {
            if (line.contains("\u7b2c\u4e00\u7ae0")) {
                line = line.replace("\u7b2c\u4e00\u7ae0", title);
            } else if (line.contains("\u8fd9\u662f\u6587\u672c")) {
                if (str[0].contains("\u7ae0")) {
                    str[0] = "";
                }
                if (str.length >= 2) {
                    str[1].contains("\u7ae0");
                    str[1] = "";
                }
                int i = 0;
                while (i < str.length) {
                    splis = String.valueOf(splis) + "<blockquote><p>" + str[i] + "</p></blockquote>" + "\n";
                    ++i;
                }
                line = splis;
            }
            input.add(line);
        }
        br.close();
        isr.close();
        file.close();
        this.writeFile1(input, String.valueOf(this.getProjectPath()) + "\\epub\\Chapter" + (a + 1) + ".html");
    }

    public void writeFile1(ArrayList<String> input, String path) throws IOException {
        File file = new File(String.valueOf(this.getProjectPath()) + "\\epub\\");
        if (!file.exists()) {
            file.mkdir();
        }
        FileOutputStream fos = new FileOutputStream(new File(path));
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
        BufferedWriter bw = new BufferedWriter(osw);
        for (String arr : input) {
            bw.write(String.valueOf(arr) + "\n");
        }
        bw.close();
        osw.close();
        fos.close();
    }

    private String getProjectPath() {
        String project_path = System.getProperty("user.dir");
        return project_path;
    }

    public void doEpub() {
        Book book = new Book();
        book.getMetadata().addTitle(Info.title);
        book.getMetadata().addAuthor(new Author(Info.author));
        book.getMetadata().addContributor(new Author(Info.author));
        book.getMetadata().addPublisher("xiaobaiyey.com");
        ArrayList<String> list = new ArrayList<String>();
        list.add("publish-\u5c0f\u767d");
        list.add("publish-\u5c0f\u767d");
        book.getMetadata().setPublishers(list);
        list = new ArrayList();
        list.add("Descriptions-\u5c0f\u767d");
        list.add("Descriptions-\u5c0f\u767d");
        book.getMetadata().setDescriptions(list);
        ArrayList<nl.siegmann.epublib.domain.Date> list2 = new ArrayList<nl.siegmann.epublib.domain.Date>();
        list2.add(new nl.siegmann.epublib.domain.Date(new Date()));
        book.getMetadata().setDates(list2);
        book.getMetadata().setSubjects(list);
        int a = this.getfilelist();
        int i = 0;
        while (i < a) {
            File file = new File(String.valueOf(this.projecPath) + "Chapter" + (i + 1) + ".html");
            if (file.exists()) {
                try {
                    book.addSection(GetPassage.ChapterTitle.get(i), new Resource(new FileInputStream(file), "Chapter" + (i + 1) + ".html"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        try {
            book.setCoverImage(new Resource(new FileInputStream(new File(Info.coverPath)), "cover.jpg"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        EpubWriter epubWriter = new EpubWriter();
        try {
            epubWriter.write(book, new FileOutputStream(new File(String.valueOf(Info.title) + ".epub")));
            System.out.println("ok");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    int getfilelist() {
        File file = new File(this.projecPath);
        File[] tempList = file.listFiles();
        int a = tempList.length;
        return a;
    }
}

