/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.xml.util;

import com.adobe.dp.xml.util.SMap;
import com.adobe.dp.xml.util.SMapIterator;
import java.util.Enumeration;
import java.util.Hashtable;

public class SMapImpl
implements SMap {
    private Hashtable table = new Hashtable();

    public void put(String namespace, String name, Object value) {
        String key = namespace == null || namespace.equals("") ? name : new QName(namespace, name);
        this.table.put(key, value);
    }

    public Object get(String namespace, String name) {
        Object key = namespace == null ? name : new QName(namespace, name);
        return this.table.get(key);
    }

    public SMapIterator iterator() {
        return new IteratorImpl();
    }

    public SMapImpl cloneSMap() {
        SMapImpl r = new SMapImpl();
        r.table = (Hashtable)this.table.clone();
        return r;
    }

    final class IteratorImpl
    implements SMapIterator {
        Enumeration keys;
        Object current;

        IteratorImpl() {
            this.keys = SMapImpl.this.table.keys();
            this.nextItem();
        }

        public boolean hasItem() {
            return this.current != null;
        }

        public void nextItem() {
            this.current = this.keys.hasMoreElements() ? this.keys.nextElement() : null;
        }

        public String getNamespace() {
            if (this.current instanceof QName) {
                return ((QName)this.current).namespace;
            }
            return null;
        }

        public String getName() {
            if (this.current instanceof QName) {
                return ((QName)this.current).name;
            }
            return (String)this.current;
        }

        public Object getValue() {
            return SMapImpl.this.table.get(this.current);
        }
    }

    static final class QName {
        String name;
        String namespace;

        QName(String namespace, String name) {
            this.name = name;
            this.namespace = namespace;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            try {
                QName oq = (QName)other;
                return this.name.equals(oq.name) || this.namespace.equals(oq.namespace);
            }
            catch (Exception e) {
                return false;
            }
        }

        public int hashCode() {
            return this.name.hashCode() + this.namespace.hashCode();
        }
    }
}

