/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.otf;

import com.adobe.dp.otf.FontPropertyConstants;

public class FontProperties
implements FontPropertyConstants,
Comparable {
    private String familyName;
    private int weight;
    private int style;

    public FontProperties(String familyName, int weight, int style) {
        this.familyName = familyName;
        this.weight = weight;
        this.style = style;
    }

    public int hashCode() {
        return this.familyName.hashCode() + this.weight + this.style;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public int getStyle() {
        return this.style;
    }

    public String getStyleString() {
        if (this.style == 1) {
            return "Italic";
        }
        if (this.style == 2) {
            return "Oblique";
        }
        return "Regular";
    }

    public int getWeight() {
        return this.weight;
    }

    public String getWeightString() {
        switch (this.weight) {
            case 200: 
            case 300: {
                return "Light";
            }
            case 400: {
                return "Normal";
            }
            case 500: {
                return "Medium";
            }
            case 600: {
                return "Semibold";
            }
            case 700: 
            case 800: {
                return "Bold";
            }
            case 900: {
                return "Black";
            }
        }
        return Integer.toString(this.weight);
    }

    public boolean equals(Object other) {
        if (other.getClass() != this.getClass()) {
            return false;
        }
        FontProperties o = (FontProperties)other;
        return o.familyName.equals(this.familyName) && o.weight == this.weight && o.style == this.style;
    }

    public String toString() {
        String styleStr = this.getStyleString();
        return String.valueOf(this.familyName) + ":" + this.weight + ":" + styleStr;
    }

    public int compareTo(Object o) {
        FontProperties f = (FontProperties)o;
        int c = this.getFamilyName().compareTo(f.getFamilyName());
        if (c != 0) {
            return c;
        }
        c = this.getWeight() - f.getWeight();
        if (c != 0) {
            return c;
        }
        return this.getStyle() - f.getStyle();
    }
}

