/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.office.word;

import com.adobe.dp.office.embedded.EmbeddedObject;
import com.adobe.dp.office.types.BorderSide;
import com.adobe.dp.office.types.FontFamily;
import com.adobe.dp.office.types.Paint;
import com.adobe.dp.office.types.RGBColor;
import com.adobe.dp.office.vml.VMLElement;
import com.adobe.dp.office.vml.VMLElementFactory;
import com.adobe.dp.office.vml.VMLFormulasElement;
import com.adobe.dp.office.vml.VMLShapeTypeElement;
import com.adobe.dp.office.word.AbstractNumberingDefinition;
import com.adobe.dp.office.word.BRElement;
import com.adobe.dp.office.word.BaseProperties;
import com.adobe.dp.office.word.BodyElement;
import com.adobe.dp.office.word.ContainerElement;
import com.adobe.dp.office.word.DrawingElement;
import com.adobe.dp.office.word.Element;
import com.adobe.dp.office.word.FootnoteElement;
import com.adobe.dp.office.word.FootnoteReferenceElement;
import com.adobe.dp.office.word.HyperlinkElement;
import com.adobe.dp.office.word.LastRenderedPageBreakElement;
import com.adobe.dp.office.word.MetadataItem;
import com.adobe.dp.office.word.NumberingDefinitionInstance;
import com.adobe.dp.office.word.NumberingLabel;
import com.adobe.dp.office.word.NumberingLevelDefinition;
import com.adobe.dp.office.word.NumberingProperties;
import com.adobe.dp.office.word.ParagraphElement;
import com.adobe.dp.office.word.ParagraphProperties;
import com.adobe.dp.office.word.PictElement;
import com.adobe.dp.office.word.RunElement;
import com.adobe.dp.office.word.RunProperties;
import com.adobe.dp.office.word.SmartTagElement;
import com.adobe.dp.office.word.Style;
import com.adobe.dp.office.word.TXBXContentElement;
import com.adobe.dp.office.word.TabElement;
import com.adobe.dp.office.word.TableCellElement;
import com.adobe.dp.office.word.TableCellProperties;
import com.adobe.dp.office.word.TableElement;
import com.adobe.dp.office.word.TableProperties;
import com.adobe.dp.office.word.TableRowElement;
import com.adobe.dp.office.word.TableRowProperties;
import com.adobe.dp.office.word.TextElement;
import com.adobe.dp.office.word.WordDocument;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class WordDocumentParser {
    static final String cpNS = "http://schemas.openxmlformats.org/package/2006/metadata/core-properties";
    static final String dcNS = "http://purl.org/dc/elements/1.1/";
    static final String dctNS = "http://purl.org/dc/terms/";
    static final String wNS = "http://schemas.openxmlformats.org/wordprocessingml/2006/main";
    static final String wpNS = "http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing";
    static final String aNS = "http://schemas.openxmlformats.org/drawingml/2006/main";
    static final String picNS = "http://schemas.openxmlformats.org/drawingml/2006/picture";
    static final String vNS = "urn:schemas-microsoft-com:vml";
    static final String rNS = "http://schemas.openxmlformats.org/officeDocument/2006/relationships";
    static final String rPkNS = "http://schemas.openxmlformats.org/package/2006/relationships";
    static final String hyperlinkRel = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink";
    static final String imageRel = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/image";
    static final String stylesRel = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles";
    static final String numberingRel = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/numbering";
    static final String themeRel = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/theme";
    static final String fontsRel = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/fontTable";
    static final String footnotesRel = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/footnotes";
    WordDocument doc;
    Hashtable rels;
    File docFile;
    ZipFile zip;
    Stack contextStack;
    SAXParserFactory factory;
    String stylesName;
    String fontsName;
    String themeName;
    String footnotesName;
    String numberingName;
    Hashtable fonts = new Hashtable();
    String majorFontName;
    String minorFontName;
    Hashtable vmldefs = new Hashtable();
    static final Hashtable propertyParsers = new Hashtable();
    static final Hashtable colorTable = new Hashtable();

    static {
        SimplePropertyParser simpleParser = new SimplePropertyParser("");
        propertyParsers.put("vertAlign", simpleParser);
        propertyParsers.put("u", simpleParser);
        propertyParsers.put("jc", simpleParser);
        propertyParsers.put("lang", simpleParser);
        NumberPropertyParser numberParser = new NumberPropertyParser();
        propertyParsers.put("sz", numberParser);
        propertyParsers.put("spacing-r", numberParser);
        OnOffPropertyParser onOffParser = new OnOffPropertyParser();
        propertyParsers.put("b", onOffParser);
        propertyParsers.put("i", onOffParser);
        propertyParsers.put("webHidden", onOffParser);
        propertyParsers.put("strike", onOffParser);
        propertyParsers.put("keepNext", onOffParser);
        propertyParsers.put("keepLines", onOffParser);
        propertyParsers.put("pageBreakBefore", onOffParser);
        propertyParsers.put("contextualSpacing", onOffParser);
        IntegerPropertyParser integerParser = new IntegerPropertyParser();
        propertyParsers.put("ilvl", integerParser);
        propertyParsers.put("outlineLvl", integerParser);
        propertyParsers.put("numId", integerParser);
        SpacingPropertyParser insetsParser = new SpacingPropertyParser();
        propertyParsers.put("spacing", insetsParser);
        PaintPropertyParser paintParser = new PaintPropertyParser();
        propertyParsers.put("color", paintParser);
        propertyParsers.put("highlight", paintParser);
        ShadingPropertyParser shdParser = new ShadingPropertyParser();
        propertyParsers.put("shd", shdParser);
        FontsPropertyParser fontsParser = new FontsPropertyParser();
        propertyParsers.put("rFonts", fontsParser);
        IndentParser indentParser = new IndentParser();
        propertyParsers.put("ind", indentParser);
        FrameParser frameParser = new FrameParser();
        propertyParsers.put("framePr", frameParser);
        colorTable.put("white", new RGBColor(0xFFFFFF));
        colorTable.put("black", new RGBColor(0));
        colorTable.put("red", new RGBColor(0xFF0000));
        colorTable.put("green", new RGBColor(65280));
        colorTable.put("blue", new RGBColor(255));
        colorTable.put("yellow", new RGBColor(0xFFFF00));
        colorTable.put("magenta", new RGBColor(0xFF00FF));
        colorTable.put("cyan", new RGBColor(65535));
        colorTable.put("lightGray", new RGBColor(0xCCCCCC));
        colorTable.put("gray", new RGBColor(0x999999));
        colorTable.put("darkGray", new RGBColor(0x777777));
    }

    static Paint parsePaint(String val) {
        Paint propertyValue;
        if (val == null) {
            return null;
        }
        if (val.equals("auto")) {
            val = "black";
        }
        if ((propertyValue = (Paint)colorTable.get(val)) != null) {
            return propertyValue;
        }
        try {
            int ival = Integer.parseInt(val, 16);
            return new RGBColor(ival);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return null;
        }
    }

    static PropertyParser getPropertyParser(String localName) {
        return (PropertyParser)propertyParsers.get(localName);
    }

    private BorderSide parseBorderSide(Attributes attributes) {
        String val = attributes.getValue(wNS, "val");
        String szVal = attributes.getValue(wNS, "sz");
        float sz = 0.0f;
        if (szVal != null) {
            try {
                sz = Float.parseFloat(szVal);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        String spaceVal = attributes.getValue(wNS, "space");
        float space = 0.0f;
        if (spaceVal != null) {
            try {
                space = Float.parseFloat(spaceVal);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        String colorVal = attributes.getValue(wNS, "color");
        Paint color = WordDocumentParser.parsePaint(colorVal);
        return new BorderSide(val, sz, space, color);
    }

    public WordDocumentParser(File docFile) {
        this.docFile = docFile;
    }

    public WordDocument parse() throws IOException {
        this.doc = new WordDocument();
        this.parseInternal();
        return this.doc;
    }

    void parseInternal() throws IOException {
        this.doc.body = null;
        this.doc.docDefaultParagraphStyle = new Style("__p");
        this.doc.docDefaultRunStyle = new Style("__r");
        this.doc.stylesById = new Hashtable();
        this.zip = new ZipFile(this.docFile);
        this.factory = SAXParserFactory.newInstance();
        this.factory.setNamespaceAware(true);
        this.rels = new Hashtable();
        this.contextStack = new Stack();
        this.numberingName = null;
        this.stylesName = null;
        this.fontsName = null;
        this.themeName = null;
        this.parseXML("docProps/core.xml");
        this.contextStack.clear();
        this.parseXML("word/_rels/document.xml.rels");
        this.contextStack.clear();
        if (this.themeName != null) {
            this.parseXML("word/" + this.themeName);
            this.contextStack.clear();
        }
        if (this.fontsName != null) {
            this.parseXML("word/" + this.fontsName);
            this.contextStack.clear();
        }
        if (this.stylesName != null) {
            this.parseXML("word/" + this.stylesName);
            this.contextStack.clear();
        }
        if (this.numberingName != null) {
            this.parseXML("word/" + this.numberingName);
            this.contextStack.clear();
        }
        if (this.footnotesName != null) {
            this.parseXML("word/" + this.footnotesName);
            this.contextStack.clear();
        }
        this.parseXML("word/document.xml");
        this.contextStack.clear();
        if (this.doc.body != null) {
            this.number(this.doc.body);
        }
        if (this.doc.footnotes != null) {
            this.number(this.doc.footnotes);
        }
        this.zip.close();
    }

    private void number(Element e) {
        NumberingProperties np;
        ParagraphProperties pp;
        if (e instanceof ParagraphElement && (pp = ((ParagraphElement)e).paragraphProperties) != null && (np = pp.getNumberingProperties()) != null) {
            int lvl;
            Iterator it;
            NumberingDefinitionInstance inst;
            Integer numId = (Integer)np.get("numId");
            Integer ilvl = (Integer)np.get("ilvl");
            if (numId != null && (inst = (NumberingDefinitionInstance)this.doc.numberingDefinitions.get(numId)) != null && (it = inst.iteratorForLevel(lvl = ilvl != null ? ilvl : 0)) != null) {
                NumberingLabel label;
                pp.numberingLabel = label = (NumberingLabel)it.next();
            }
        }
        Iterator it = e.content();
        while (it.hasNext()) {
            Object child = it.next();
            if (!(child instanceof ContainerElement)) continue;
            this.number((ContainerElement)child);
        }
    }

    private void parseXML(String entryName) throws IOException {
        ZipEntry entry = this.zip.getEntry(entryName);
        if (entry == null) {
            return;
        }
        try {
            SAXParser parser = this.factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            int index = entryName.lastIndexOf(47);
            String xrefPrefix = entryName.substring(0, index + 1);
            XMLHandler handler = new XMLHandler(xrefPrefix);
            reader.setContentHandler(handler);
            InputStream in = this.zip.getInputStream(entry);
            InputSource source = new InputSource(in);
            source.setSystemId(entryName);
            reader.parse(source);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    private void assignStyleProperties(Style style, BaseProperties prop) {
        if (prop instanceof ParagraphProperties) {
            style.paragraphProperties = (ParagraphProperties)prop;
        } else if (prop instanceof RunProperties) {
            style.runProperties = (RunProperties)prop;
        }
    }

    private void assignElementProperties(Element element, BaseProperties prop) {
        if (prop instanceof ParagraphProperties) {
            if (element instanceof ParagraphElement) {
                ((ParagraphElement)element).paragraphProperties = (ParagraphProperties)prop;
            }
        } else if (prop instanceof RunProperties) {
            if (element instanceof RunElement) {
                ((RunElement)element).runProperties = (RunProperties)prop;
            }
        } else if (prop instanceof TableProperties) {
            if (element instanceof TableElement) {
                ((TableElement)element).tableProperties = (TableProperties)prop;
            }
        } else if (prop instanceof TableRowProperties) {
            if (element instanceof TableRowElement) {
                ((TableRowElement)element).tableRowProperties = (TableRowProperties)prop;
            }
        } else if (prop instanceof TableCellProperties && element instanceof TableCellElement) {
            ((TableCellElement)element).tableCellProperties = (TableCellProperties)prop;
        }
    }

    private void assignInnerProperties(BaseProperties parent, BaseProperties prop) {
        if (parent instanceof ParagraphProperties) {
            ParagraphProperties p = (ParagraphProperties)parent;
            if (prop instanceof RunProperties) {
                p.runProperties = (RunProperties)prop;
            } else if (prop instanceof NumberingProperties) {
                p.numberingProperties = (NumberingProperties)prop;
            }
        }
    }

    private BaseProperties createWordProperties(String localName) {
        if (localName.equals("pPr")) {
            return new ParagraphProperties();
        }
        if (localName.equals("rPr")) {
            return new RunProperties();
        }
        if (localName.equals("numPr")) {
            return new NumberingProperties();
        }
        if (localName.equals("tblPr")) {
            return new TableProperties();
        }
        if (localName.equals("trPr")) {
            return new TableRowProperties();
        }
        if (localName.equals("tcPr")) {
            return new TableCellProperties();
        }
        return null;
    }

    private Element createWordElement(String localName, Attributes attributes) {
        if (localName.equals("t")) {
            TextElement te = new TextElement();
            String val = attributes.getValue("http://www.w3.org/XML/1998/namespace", "space");
            te.preserveSpace = val != null && val.equals("preserve");
            return te;
        }
        if (localName.equals("p")) {
            return new ParagraphElement();
        }
        if (localName.equals("body") || localName.equals("footnotes")) {
            return new BodyElement();
        }
        if (localName.equals("r")) {
            return new RunElement();
        }
        if (localName.equals("tab")) {
            return new TabElement();
        }
        if (localName.equals("br")) {
            return new BRElement();
        }
        if (localName.equals("drawing")) {
            return new DrawingElement();
        }
        if (localName.equals("pict")) {
            return new PictElement();
        }
        if (localName.equals("tbl")) {
            return new TableElement();
        }
        if (localName.equals("tr")) {
            return new TableRowElement();
        }
        if (localName.equals("tc")) {
            return new TableCellElement();
        }
        if (localName.equals("txbxContent")) {
            return new TXBXContentElement();
        }
        if (localName.equals("smartTag")) {
            return new SmartTagElement();
        }
        if (localName.equals("hyperlink")) {
            Relationship rel;
            HyperlinkElement he = new HyperlinkElement();
            String rid = attributes.getValue(rNS, "id");
            if (rid != null && (rel = (Relationship)this.rels.get(rid)) != null) {
                he.href = rel.target;
            }
            return he;
        }
        if (localName.equals("footnote")) {
            FootnoteElement fe = new FootnoteElement();
            fe.id = attributes.getValue(wNS, "id");
            if (fe.id == null || fe.id.equals("0") || fe.id.startsWith("-")) {
                return null;
            }
            return fe;
        }
        if (localName.equals("footnoteReference")) {
            FootnoteReferenceElement fe = new FootnoteReferenceElement();
            fe.id = attributes.getValue(wNS, "id");
            return fe;
        }
        if (localName.equals("lastRenderedPageBreak")) {
            return new LastRenderedPageBreakElement();
        }
        return null;
    }

    static abstract class CompoundPropertyParser
    extends PropertyParser {
        CompoundPropertyParser() {
        }

        void parseComponent(BaseProperties target, String baseName, String componentName, Attributes attributes, WordDocumentParser self) {
            try {
                String before = attributes.getValue(WordDocumentParser.wNS, componentName);
                if (before != null) {
                    Double propertyValue = new Double(before);
                    target.put(String.valueOf(baseName) + "-" + componentName, propertyValue);
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
    }

    static class FontsPropertyParser
    extends PropertyParser {
        FontsPropertyParser() {
        }

        boolean parse(BaseProperties target, String localName, Attributes attributes, WordDocumentParser self) {
            Object propertyValue;
            String themeName;
            String propertyName = localName;
            String name = attributes.getValue(WordDocumentParser.wNS, "ascii");
            if (name == null && (themeName = attributes.getValue(WordDocumentParser.wNS, "asciiTheme")) != null) {
                if (themeName.equals("majorHAnsi")) {
                    name = self.majorFontName;
                } else if (themeName.equals("minorHAnsi")) {
                    name = self.minorFontName;
                }
            }
            if (name != null && (propertyValue = self.fonts.get(name)) != null) {
                target.put(propertyName, propertyValue);
                return true;
            }
            return false;
        }
    }

    static class FrameParser
    extends CompoundPropertyParser {
        FrameParser() {
        }

        boolean parse(BaseProperties target, String localName, Attributes attributes, WordDocumentParser self) {
            this.parseComponent(target, localName, "w", attributes, self);
            this.parseComponent(target, localName, "hSpace", attributes, self);
            this.parseComponent(target, localName, "vSpace", attributes, self);
            String align = attributes.getValue(WordDocumentParser.wNS, "xAlign");
            if (align != null) {
                target.put(String.valueOf(localName) + "-align", align);
            }
            return true;
        }
    }

    static class IndentParser
    extends CompoundPropertyParser {
        IndentParser() {
        }

        boolean parse(BaseProperties target, String localName, Attributes attributes, WordDocumentParser self) {
            this.parseComponent(target, localName, "left", attributes, self);
            this.parseComponent(target, localName, "right", attributes, self);
            this.parseComponent(target, localName, "firstLine", attributes, self);
            this.parseComponent(target, localName, "hanging", attributes, self);
            return true;
        }
    }

    static class IntegerPropertyParser
    extends PropertyParser {
        IntegerPropertyParser() {
        }

        boolean parse(BaseProperties target, String localName, Attributes attributes, WordDocumentParser self) {
            String propertyName = localName;
            String val = attributes.getValue(WordDocumentParser.wNS, "val");
            if (val != null) {
                try {
                    Integer propertyValue = new Integer(val);
                    target.put(propertyName, propertyValue);
                    return true;
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
    }

    static class NumberPropertyParser
    extends PropertyParser {
        NumberPropertyParser() {
        }

        boolean parse(BaseProperties target, String localName, Attributes attributes, WordDocumentParser self) {
            String propertyName = localName;
            String val = attributes.getValue(WordDocumentParser.wNS, "val");
            if (val != null) {
                try {
                    Double propertyValue = new Double(val);
                    target.put(propertyName, propertyValue);
                    return true;
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
    }

    static class OnOffPropertyParser
    extends PropertyParser {
        OnOffPropertyParser() {
        }

        boolean parse(BaseProperties target, String localName, Attributes attributes, WordDocumentParser self) {
            String propertyName = localName;
            String val = attributes.getValue(WordDocumentParser.wNS, "val");
            Boolean propertyValue = val == null || val.equals("on") ? Boolean.TRUE : Boolean.FALSE;
            target.put(propertyName, propertyValue);
            return true;
        }
    }

    static class PaintPropertyParser
    extends PropertyParser {
        PaintPropertyParser() {
        }

        boolean parse(BaseProperties target, String localName, Attributes attributes, WordDocumentParser self) {
            String propertyName = localName;
            String val = attributes.getValue(WordDocumentParser.wNS, "val");
            Paint propertyValue = WordDocumentParser.parsePaint(val);
            if (propertyValue != null) {
                target.put(propertyName, propertyValue);
                return true;
            }
            return false;
        }
    }

    static class ParseContext {
        Element parentElement;
        Style parentStyle;
        BaseProperties properties;
        BaseProperties borderProp;
        EmbeddedObject embedded;
        MetadataItem item;
        FontFamily font;
        String state;
        AbstractNumberingDefinition abstractNumberingDefinition;
        NumberingDefinitionInstance numberingDefinitionInstance;
        NumberingLevelDefinition numberingLevelDefinition;
        Integer ilvlOverride;

        ParseContext() {
        }
    }

    static abstract class PropertyParser {
        PropertyParser() {
        }

        abstract boolean parse(BaseProperties var1, String var2, Attributes var3, WordDocumentParser var4);
    }

    static class Relationship {
        String type;
        String target;
        String targetMode;

        Relationship(String type, String target, String targetMode) {
            this.target = target;
            this.type = type;
            this.targetMode = targetMode;
        }
    }

    static class ShadingPropertyParser
    extends PropertyParser {
        ShadingPropertyParser() {
        }

        boolean parse(BaseProperties target, String localName, Attributes attributes, WordDocumentParser self) {
            String propertyName = localName;
            String val = attributes.getValue(WordDocumentParser.wNS, "fill");
            if (val == null) {
                return false;
            }
            Paint propertyValue = WordDocumentParser.parsePaint(val);
            if (propertyValue != null) {
                target.put(propertyName, propertyValue);
                return true;
            }
            return false;
        }
    }

    static class SimplePropertyParser
    extends PropertyParser {
        Object defaultValue;

        SimplePropertyParser(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        boolean parse(BaseProperties target, String localName, Attributes attributes, WordDocumentParser self) {
            String propertyName = localName;
            Object propertyValue = attributes.getValue(WordDocumentParser.wNS, "val");
            if (propertyValue == null) {
                propertyValue = this.defaultValue;
            }
            target.put(propertyName, propertyValue);
            return true;
        }
    }

    static class SpacingPropertyParser
    extends CompoundPropertyParser {
        SpacingPropertyParser() {
        }

        boolean parse(BaseProperties target, String localName, Attributes attributes, WordDocumentParser self) {
            this.parseComponent(target, localName, "before", attributes, self);
            this.parseComponent(target, localName, "after", attributes, self);
            this.parseComponent(target, localName, "line", attributes, self);
            String lineRule = attributes.getValue(WordDocumentParser.wNS, "lineRule");
            if (lineRule != null) {
                target.put(String.valueOf(localName) + "-lineRule", lineRule);
            }
            return true;
        }
    }

    class XMLHandler
    extends DefaultHandler
    implements DrawingElement.Context {
        String xrefPrefix;

        XMLHandler(String prefix) {
            this.xrefPrefix = prefix;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            ParseContext context = (ParseContext)WordDocumentParser.this.contextStack.peek();
            Element p = context.parentElement;
            if (p instanceof TextElement) {
                ((TextElement)p).text = String.valueOf(((TextElement)p).text) + new String(ch, start, length);
            }
            if (context.item != null) {
                StringBuffer sb = new StringBuffer();
                String value = context.item.getValue();
                if (value != null) {
                    sb.append(value);
                }
                sb.append(ch, start, length);
                context.item.setValue(sb.toString());
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            ParseContext parentContext;
            ParseContext context = (ParseContext)WordDocumentParser.this.contextStack.pop();
            EmbeddedObject embedded = context.embedded;
            if (embedded != null) {
                embedded.finish(this);
                if (!WordDocumentParser.this.contextStack.isEmpty()) {
                    parentContext = (ParseContext)WordDocumentParser.this.contextStack.peek();
                    if (parentContext.embedded != null) {
                        parentContext.embedded.finishChild(this, embedded);
                    }
                }
            }
            if (context.item != null && context.item.getValue() != null) {
                WordDocumentParser.this.doc.metadata.add(context.item);
            }
            if (uri.equals(WordDocumentParser.vNS) && !WordDocumentParser.this.contextStack.isEmpty() && context.parentElement instanceof VMLFormulasElement) {
                parentContext = (ParseContext)WordDocumentParser.this.contextStack.peek();
                if (parentContext.parentElement instanceof VMLShapeTypeElement) {
                    ((VMLShapeTypeElement)parentContext.parentElement).setFormulas((VMLFormulasElement)context.parentElement);
                }
            }
            if (WordDocumentParser.this.doc.defaultParagraphStyle != null && context.parentElement instanceof ParagraphElement) {
                ParagraphElement p = (ParagraphElement)context.parentElement;
                if (p.paragraphProperties == null) {
                    p.paragraphProperties = new ParagraphProperties();
                }
                if (p.paragraphProperties.paragraphStyle == null) {
                    p.paragraphProperties.paragraphStyle = WordDocumentParser.this.doc.defaultParagraphStyle;
                }
            }
            if (WordDocumentParser.this.doc.defaultRunStyle != null && context.parentElement instanceof RunElement) {
                RunElement r = (RunElement)context.parentElement;
                if (r.runProperties == null) {
                    r.runProperties = new RunProperties();
                }
                if (r.runProperties.runStyle == null) {
                    r.runProperties.runStyle = WordDocumentParser.this.doc.defaultRunStyle;
                }
            }
            if (context.parentStyle != null) {
                Style style = context.parentStyle;
                if (style.parent == null && style != WordDocumentParser.this.doc.docDefaultParagraphStyle && style != WordDocumentParser.this.doc.docDefaultRunStyle && style.type != null && style.type.equals("paragraph")) {
                    style.parent = WordDocumentParser.this.doc.docDefaultParagraphStyle;
                }
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            ParseContext newContext = new ParseContext();
            if (WordDocumentParser.this.contextStack.isEmpty()) {
                if (uri.equals(WordDocumentParser.wNS) && localName.equals("footnotes")) {
                    Element p;
                    newContext.parentElement = p = WordDocumentParser.this.createWordElement(localName, attributes);
                    WordDocumentParser.this.doc.footnotes = (BodyElement)p;
                }
            } else {
                ParseContext parentContext = (ParseContext)WordDocumentParser.this.contextStack.peek();
                if (uri != null) {
                    if (uri.equals(WordDocumentParser.wNS)) {
                        if (localName.equals("style")) {
                            String defStr;
                            newContext.parentStyle = new Style();
                            String styleId = attributes.getValue(WordDocumentParser.wNS, "styleId");
                            if (styleId != null) {
                                newContext.parentStyle.styleId = styleId;
                                WordDocumentParser.this.doc.stylesById.put(styleId, newContext.parentStyle);
                            }
                            newContext.parentStyle.type = attributes.getValue(WordDocumentParser.wNS, "type");
                            if (newContext.parentStyle.type != null && (defStr = attributes.getValue(WordDocumentParser.wNS, "default")) != null && defStr.equals("1")) {
                                if (newContext.parentStyle.type.equals("character")) {
                                    WordDocumentParser.this.doc.defaultRunStyle = newContext.parentStyle;
                                } else if (newContext.parentStyle.type.equals("paragraph")) {
                                    WordDocumentParser.this.doc.defaultParagraphStyle = newContext.parentStyle;
                                }
                            }
                        } else if (localName.equals("abstractNum")) {
                            newContext.abstractNumberingDefinition = new AbstractNumberingDefinition();
                            String abstractNumIdStr = attributes.getValue(WordDocumentParser.wNS, "abstractNumId");
                            try {
                                Integer abstractNumId = new Integer(abstractNumIdStr);
                                WordDocumentParser.this.doc.abstractNumberingDefinitions.put(abstractNumId, newContext.abstractNumberingDefinition);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else if (localName.equals("num")) {
                            String numIdStr = attributes.getValue(WordDocumentParser.wNS, "numId");
                            try {
                                Integer numId = new Integer(numIdStr);
                                newContext.numberingDefinitionInstance = new NumberingDefinitionInstance(WordDocumentParser.this.doc, numId);
                                WordDocumentParser.this.doc.numberingDefinitions.put(numId, newContext.numberingDefinitionInstance);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else if (localName.equals("lvlOverride")) {
                            if (parentContext.numberingDefinitionInstance != null) {
                                newContext.numberingDefinitionInstance = parentContext.numberingDefinitionInstance;
                                String ilvlStr = attributes.getValue(WordDocumentParser.wNS, "ilvl");
                                if (ilvlStr != null) {
                                    try {
                                        newContext.ilvlOverride = new Integer(ilvlStr);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                        } else if (localName.equals("startOverride")) {
                            String startStr;
                            if (parentContext.ilvlOverride != null && parentContext.numberingDefinitionInstance != null && (startStr = attributes.getValue(WordDocumentParser.wNS, "val")) != null) {
                                try {
                                    Integer start = new Integer(startStr);
                                    parentContext.numberingDefinitionInstance.startOverrides.put(parentContext.ilvlOverride, start);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        } else if (localName.equals("lvl")) {
                            newContext.numberingLevelDefinition = new NumberingLevelDefinition();
                            String ilvlStr = attributes.getValue(WordDocumentParser.wNS, "ilvl");
                            if (ilvlStr != null) {
                                try {
                                    Integer ilvl = new Integer(ilvlStr);
                                    newContext.numberingLevelDefinition.lvl = ilvl;
                                    newContext.numberingLevelDefinition.lvlRestart = newContext.numberingLevelDefinition.lvl - 1;
                                    if (parentContext.abstractNumberingDefinition != null) {
                                        parentContext.abstractNumberingDefinition.numberingLevelDefinitions.put(ilvl, newContext.numberingLevelDefinition);
                                    } else if (parentContext.numberingDefinitionInstance != null) {
                                        parentContext.numberingDefinitionInstance.numberingLevelDefinitions.put(ilvl, newContext.numberingLevelDefinition);
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        } else if (localName.equals("font")) {
                            String name = attributes.getValue(WordDocumentParser.wNS, "name");
                            if (name != null) {
                                FontFamily font;
                                newContext.font = font = new FontFamily(name);
                                WordDocumentParser.this.fonts.put(name, font);
                            }
                        } else if (localName.endsWith("Pr") && !localName.equals("framePr")) {
                            BaseProperties prop;
                            newContext.properties = prop = WordDocumentParser.this.createWordProperties(localName);
                            if (parentContext.parentStyle != null) {
                                WordDocumentParser.this.assignStyleProperties(parentContext.parentStyle, prop);
                            } else if (parentContext.parentElement != null) {
                                WordDocumentParser.this.assignElementProperties(parentContext.parentElement, prop);
                            } else if (parentContext.properties != null) {
                                WordDocumentParser.this.assignInnerProperties(parentContext.properties, prop);
                            } else if (parentContext.numberingLevelDefinition != null) {
                                if (localName.equals("pPr")) {
                                    parentContext.numberingLevelDefinition.paragraphProperties = (ParagraphProperties)prop;
                                } else if (localName.equals("rPr")) {
                                    parentContext.numberingLevelDefinition.runProperties = (RunProperties)prop;
                                }
                            }
                        } else if (parentContext.parentStyle != null) {
                            String parentStyle;
                            if (localName.equals("name")) {
                                parentContext.parentStyle.name = attributes.getValue(WordDocumentParser.wNS, "val");
                            } else if (localName.equals("basedOn") && (parentStyle = attributes.getValue(WordDocumentParser.wNS, "val")) != null) {
                                parentContext.parentStyle.parent = WordDocumentParser.this.doc.getStyleById(parentStyle);
                            }
                        } else if (parentContext.font != null) {
                            if (localName.equals("panose1")) {
                                parentContext.font.setPanose(attributes.getValue(WordDocumentParser.wNS, "val"));
                            } else if (localName.equals("family")) {
                                parentContext.font.setFamily(attributes.getValue(WordDocumentParser.wNS, "val"));
                            } else if (localName.equals("pitch")) {
                                parentContext.font.setPitch(attributes.getValue(WordDocumentParser.wNS, "val"));
                            }
                        } else if (parentContext.abstractNumberingDefinition != null) {
                            if (localName.equals("numStyleLink")) {
                                parentContext.abstractNumberingDefinition.numStyleLink = attributes.getValue(WordDocumentParser.wNS, "val");
                            }
                        } else if (parentContext.numberingDefinitionInstance != null) {
                            if (localName.equals("abstractNumId")) {
                                String abstractNumIdStr = attributes.getValue(WordDocumentParser.wNS, "val");
                                try {
                                    Integer abstractNumId = new Integer(abstractNumIdStr);
                                    parentContext.numberingDefinitionInstance.setAbstractNumbering((AbstractNumberingDefinition)WordDocumentParser.this.doc.abstractNumberingDefinitions.get(abstractNumId));
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        } else if (parentContext.numberingLevelDefinition != null) {
                            if (localName.equals("start")) {
                                try {
                                    parentContext.numberingLevelDefinition.start = Integer.parseInt(attributes.getValue(WordDocumentParser.wNS, "val"));
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            } else if (localName.equals("lvlRestart")) {
                                try {
                                    parentContext.numberingLevelDefinition.lvlRestart = Integer.parseInt(attributes.getValue(WordDocumentParser.wNS, "val"));
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            } else if (localName.equals("numFmt")) {
                                parentContext.numberingLevelDefinition.numFmt = attributes.getValue(WordDocumentParser.wNS, "val");
                            } else if (localName.equals("lvlText")) {
                                parentContext.numberingLevelDefinition.lvlText = attributes.getValue(WordDocumentParser.wNS, "val");
                            } else if (localName.equals("lvlJc")) {
                                parentContext.numberingLevelDefinition.lvlJc = attributes.getValue(WordDocumentParser.wNS, "val");
                            }
                        } else if (parentContext.borderProp != null) {
                            if (localName.equals("top") || localName.equals("bottom") || localName.equals("left") || localName.equals("right") || localName.equals("insideH") || localName.equals("insideV")) {
                                BorderSide side = WordDocumentParser.this.parseBorderSide(attributes);
                                if (localName.equals("top")) {
                                    parentContext.borderProp.put("border-top", side);
                                } else if (localName.equals("bottom")) {
                                    parentContext.borderProp.put("border-bottom", side);
                                } else if (localName.equals("left")) {
                                    parentContext.borderProp.put("border-left", side);
                                } else if (localName.equals("right")) {
                                    parentContext.borderProp.put("border-right", side);
                                } else if (localName.equals("insideH")) {
                                    parentContext.borderProp.put("border-insideH", side);
                                } else if (localName.equals("insideV")) {
                                    parentContext.borderProp.put("border-insideV", side);
                                }
                            }
                        } else if (parentContext.properties != null) {
                            BaseProperties prop = parentContext.properties;
                            if (localName.equals("rStyle") || localName.equals("pStyle")) {
                                String val = attributes.getValue(WordDocumentParser.wNS, "val");
                                if (val != null) {
                                    Style style = WordDocumentParser.this.doc.getStyleById(val);
                                    if (prop instanceof ParagraphProperties && localName.equals("pStyle")) {
                                        ((ParagraphProperties)prop).paragraphStyle = style;
                                    } else if (prop instanceof RunProperties && localName.equals("rStyle")) {
                                        ((RunProperties)prop).runStyle = style;
                                    }
                                }
                            } else if (localName.equals("pBdr") || localName.equals("tblBorders")) {
                                newContext.borderProp = prop;
                            } else {
                                PropertyParser propertyParser;
                                if (localName.equals("spacing") && parentContext.properties instanceof RunProperties) {
                                    localName = "spacing-r";
                                }
                                if ((propertyParser = WordDocumentParser.getPropertyParser(localName)) != null) {
                                    propertyParser.parse(parentContext.properties, localName, attributes, WordDocumentParser.this);
                                }
                            }
                        } else if (localName.equals("rPrDefault")) {
                            newContext.parentStyle = WordDocumentParser.this.doc.docDefaultRunStyle;
                        } else if (localName.equals("pPrDefault")) {
                            newContext.parentStyle = WordDocumentParser.this.doc.docDefaultParagraphStyle;
                        } else {
                            Element p = WordDocumentParser.this.createWordElement(localName, attributes);
                            if (p != null) {
                                Element parent = parentContext.parentElement;
                                if (parent instanceof ContainerElement) {
                                    ((ContainerElement)parent).add(p);
                                }
                                if (WordDocumentParser.this.contextStack.size() == 1 && localName.equals("body")) {
                                    WordDocumentParser.this.doc.body = (BodyElement)p;
                                }
                                newContext.parentElement = p;
                                if (p instanceof EmbeddedObject) {
                                    newContext.embedded = (EmbeddedObject)((Object)p);
                                }
                            }
                        }
                    } else if (uri.equals(WordDocumentParser.cpNS) || uri.equals(WordDocumentParser.dcNS) || uri.equals(WordDocumentParser.dctNS)) {
                        if (WordDocumentParser.this.contextStack.size() == 1) {
                            newContext.item = new MetadataItem(uri, localName, null);
                        }
                    } else if (uri.equals(WordDocumentParser.vNS)) {
                        Element p;
                        Element parent = parentContext.parentElement;
                        VMLElement vmlp = null;
                        if (parent instanceof VMLElement) {
                            vmlp = (VMLElement)parent;
                        }
                        if ((p = VMLElementFactory.createVMLElement(vmlp, WordDocumentParser.this.vmldefs, localName, attributes)) != null) {
                            if (parent instanceof ContainerElement) {
                                ((ContainerElement)parent).add(p);
                            }
                            newContext.parentElement = p;
                        }
                    } else if (uri.equals(WordDocumentParser.rPkNS)) {
                        if (localName.equals("Relationship")) {
                            String id = attributes.getValue("Id");
                            String type = attributes.getValue("Type");
                            String target = attributes.getValue("Target");
                            String targetMode = attributes.getValue("TargetMode");
                            if (id != null) {
                                WordDocumentParser.this.rels.put(id, new Relationship(type, target, targetMode));
                            }
                            if (type.equals(WordDocumentParser.numberingRel)) {
                                if (WordDocumentParser.this.numberingName == null) {
                                    WordDocumentParser.this.numberingName = target;
                                }
                            } else if (type.equals(WordDocumentParser.stylesRel)) {
                                if (WordDocumentParser.this.stylesName == null) {
                                    WordDocumentParser.this.stylesName = target;
                                }
                            } else if (type.equals(WordDocumentParser.fontsRel)) {
                                if (WordDocumentParser.this.fontsName == null) {
                                    WordDocumentParser.this.fontsName = target;
                                }
                            } else if (type.equals(WordDocumentParser.themeRel)) {
                                if (WordDocumentParser.this.themeName == null) {
                                    WordDocumentParser.this.themeName = target;
                                }
                            } else if (type.equals(WordDocumentParser.footnotesRel) && WordDocumentParser.this.footnotesName == null) {
                                WordDocumentParser.this.footnotesName = target;
                            }
                        }
                    } else {
                        if (uri.equals(WordDocumentParser.aNS)) {
                            if (localName.equals("majorFont")) {
                                newContext.state = "majorFont";
                            } else if (localName.equals("minorFont")) {
                                newContext.state = "minorFont";
                            } else if (localName.equals("latin")) {
                                String typeface = attributes.getValue("typeface");
                                if (parentContext.state == "majorFont") {
                                    WordDocumentParser.this.majorFontName = typeface;
                                } else if (parentContext.state == "minorFont") {
                                    WordDocumentParser.this.minorFontName = typeface;
                                }
                            }
                        }
                        if (parentContext.embedded != null) {
                            newContext.embedded = parentContext.embedded.newChild(this, uri, localName, attributes);
                        }
                    }
                }
            }
            WordDocumentParser.this.contextStack.push(newContext);
        }

        public String getPictureURL(String resId) {
            Relationship rel = (Relationship)WordDocumentParser.this.rels.get(resId);
            if (rel != null && rel.type.equals(WordDocumentParser.imageRel)) {
                return String.valueOf(this.xrefPrefix) + rel.target;
            }
            return null;
        }
    }
}

