/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.office.word;

import com.adobe.dp.office.word.BodyElement;
import com.adobe.dp.office.word.NumberingDefinitionInstance;
import com.adobe.dp.office.word.Style;
import com.adobe.dp.office.word.WordDocumentParser;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class WordDocument {
    Hashtable stylesById;
    BodyElement body;
    BodyElement footnotes;
    Style docDefaultParagraphStyle;
    Style docDefaultRunStyle;
    Style defaultParagraphStyle;
    Style defaultRunStyle;
    Vector metadata = new Vector();
    Hashtable abstractNumberingDefinitions = new Hashtable();
    Hashtable numberingDefinitions = new Hashtable();
    static Hashtable mediaTypeBySuffix = new Hashtable();

    static {
        mediaTypeBySuffix.put("jpeg", "image/jpeg");
        mediaTypeBySuffix.put("wmf", "image/x-wmf");
        mediaTypeBySuffix.put("png", "image/png");
        mediaTypeBySuffix.put("gif", "image/gif");
    }

    WordDocument() {
    }

    public WordDocument(File file) throws IOException {
        WordDocumentParser parser = new WordDocumentParser(file);
        parser.doc = this;
        parser.parseInternal();
    }

    public String getResourceMediaType(String name) {
        String suffix;
        String type;
        int index = name.lastIndexOf(46);
        if (index > 0 && (type = (String)mediaTypeBySuffix.get(suffix = name.substring(index + 1))) != null) {
            return type;
        }
        return "application/octet-stream";
    }

    public NumberingDefinitionInstance getNumberingDefinition(Integer numId) {
        return (NumberingDefinitionInstance)this.numberingDefinitions.get(numId);
    }

    public BodyElement getBody() {
        return this.body;
    }

    public BodyElement getFootnotes() {
        return this.footnotes;
    }

    public Iterator metadata() {
        return this.metadata.iterator();
    }

    public Style getStyleById(String styleId) {
        return (Style)this.stylesById.get(styleId);
    }

    public Style getDocumentDefaultParagraphStyle() {
        return this.docDefaultParagraphStyle;
    }

    public Style getDocumentDefaultRunStyle() {
        return this.docDefaultRunStyle;
    }

    public Style getDefaultParagraphStyle() {
        return this.defaultParagraphStyle;
    }

    public Style getDefaultRunStyle() {
        return this.defaultRunStyle;
    }
}

