/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.office.rtf;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class RTFStyle {
    String name;
    RTFStyle parent;
    private Hashtable storage;
    private boolean clone;
    private boolean locked;

    public RTFStyle cloneStyle() {
        RTFStyle s = new RTFStyle();
        s.parent = this.parent;
        s.storage = this.storage;
        s.name = this.name;
        s.clone = this.storage != null;
        return s;
    }

    public Object get(String prop) {
        if (this.storage == null) {
            return null;
        }
        return this.storage.get(prop);
    }

    void put(String prop, Object val) {
        if (this.locked) {
            throw new IllegalStateException("locked");
        }
        if (this.storage == null) {
            this.storage = new Hashtable();
        } else if (this.clone) {
            this.clone = false;
            this.name = null;
            this.storage = (Hashtable)this.storage.clone();
        }
        this.storage.put(prop, val);
    }

    void remove(String prop) {
        if (this.locked) {
            throw new IllegalStateException("locked");
        }
        if (this.storage == null || this.storage.get(prop) == null) {
            return;
        }
        if (this.clone) {
            this.clone = false;
            this.name = null;
            this.storage = (Hashtable)this.storage.clone();
        }
        this.storage.remove(prop);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void lock() {
        this.locked = true;
    }

    public boolean isEmpty() {
        return this.storage == null || this.storage.isEmpty();
    }

    public Iterator properties() {
        if (this.parent != null) {
            throw new IllegalStateException("needs to be collapsed to iterate");
        }
        return this.storage.keySet().iterator();
    }

    public static RTFStyle collapse(RTFStyle[] styles, Set propSet) {
        RTFStyle rs = new RTFStyle();
        int i = 0;
        while (i < styles.length) {
            RTFStyle s = styles[i];
            while (s != null) {
                if (s.storage != null) {
                    Iterator keys = s.storage.keySet().iterator();
                    while (keys.hasNext()) {
                        String k = (String)keys.next();
                        if (!propSet.contains(k) || rs.get(k) != null) continue;
                        Object v = s.storage.get(k);
                        rs.put(k, v);
                    }
                }
                s = s.parent;
            }
            ++i;
        }
        return rs;
    }

    public RTFStyle collapse(Set propSet) {
        RTFStyle[] s = new RTFStyle[]{this};
        return RTFStyle.collapse(s, propSet);
    }

    public int hashCode() {
        return (this.isEmpty() ? 0 : this.storage.hashCode()) + (this.parent == null ? 0 : this.parent.hashCode());
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass() == this.getClass()) {
            RTFStyle prop = (RTFStyle)other;
            if (this.parent == null ? prop.parent != null : !this.parent.equals(prop.parent)) {
                return false;
            }
            if (this.isEmpty()) {
                return prop.isEmpty();
            }
            return this.storage.equals(prop.storage);
        }
        return false;
    }
}

