/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.office.rtf;

import com.adobe.dp.office.rtf.RTFControl;
import com.adobe.dp.office.rtf.RTFControlType;
import com.adobe.dp.office.rtf.RTFDocumentParser;

public class RTFEncodingControlType
extends RTFControlType {
    private String encoding;

    public RTFEncodingControlType(String name, String encoding) {
        super(name);
        this.encoding = encoding;
    }

    public static String getEncoding(int pg) {
        switch (pg) {
            case 1024: 
            case 1033: 
            case 4105: {
                return "Cp1252";
            }
        }
        String encoding = "Cp" + pg;
        return encoding;
    }

    public static String getCharsetEncoding(int cs) {
        String encoding;
        switch (cs) {
            case 161: {
                encoding = "Cp1253";
                break;
            }
            case 162: {
                encoding = "Cp1254";
                break;
            }
            case 163: {
                encoding = "Cp1258";
                break;
            }
            case 177: {
                encoding = "Cp1255";
                break;
            }
            case 178: {
                encoding = "Cp1256";
                break;
            }
            case 186: {
                encoding = "Cp1257";
                break;
            }
            case 204: {
                encoding = "Cp1251";
                break;
            }
            case 222: {
                encoding = "Cp874";
                break;
            }
            case 238: {
                encoding = "Cp1250";
                break;
            }
            case 254: {
                encoding = "Cp437";
                break;
            }
            default: {
                encoding = null;
            }
        }
        return encoding;
    }

    public boolean parseTimeExec(RTFControl ctrl, RTFDocumentParser parser) {
        String encoding = this.encoding != null ? this.encoding : RTFEncodingControlType.getEncoding(ctrl.getParam());
        parser.setEncoding(encoding);
        return true;
    }
}

