/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.office.rtf;

import com.adobe.dp.office.rtf.RTFColor;
import com.adobe.dp.office.rtf.RTFControl;
import com.adobe.dp.office.rtf.RTFControlType;
import com.adobe.dp.office.rtf.RTFControlWithParam;
import com.adobe.dp.office.rtf.RTFDocument;
import com.adobe.dp.office.rtf.RTFFont;
import com.adobe.dp.office.rtf.RTFGroup;
import com.adobe.dp.office.rtf.RTFStyle;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class RTFDocumentParser {
    InputStream in;
    RTFDocument doc;
    int start;
    int stop;
    boolean eof;
    byte[] buffer = new byte[4096];
    static final int MAX_WORD_LEN = 128;
    Level curr;
    Stack levels;
    StringBuffer sbuf;
    ByteArrayOutputStream bbuf;
    Hashtable fonts;
    Hashtable paragraphStyles;
    Hashtable characterStyles;

    public RTFDocumentParser(File docFile) throws IOException {
        this.in = new FileInputStream(docFile);
    }

    public RTFDocumentParser(InputStream in) throws IOException {
        this.in = in;
    }

    public RTFDocument parse() throws IOException {
        this.doc = new RTFDocument();
        this.parseInternal();
        return this.doc;
    }

    void fillAtLeast(int count) throws IOException {
        if (this.buffer.length - this.start < count) {
            this.stop -= this.start;
            System.arraycopy(this.buffer, this.start, this.buffer, 0, this.stop);
            this.start = 0;
        }
        while (this.stop - this.start < count) {
            int r = this.in.read(this.buffer, this.stop, this.buffer.length - this.stop);
            if (r <= 0) {
                this.eof = true;
                return;
            }
            this.stop += r;
        }
        return;
    }

    void flushText0() {
        if (this.bbuf.size() > 0) {
            String text;
            try {
                text = this.bbuf.toString(this.curr.encoding);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                text = "???";
            }
            this.sbuf.append(text);
            this.bbuf.reset();
        }
    }

    void processHexChar() {
        char[] h = new char[]{(char)this.buffer[this.start++], (char)this.buffer[this.start++]};
        String hs = new String(h);
        this.injectByte((byte)Integer.parseInt(hs, 16));
    }

    public void injectByte(byte b) {
        this.bbuf.write(b);
    }

    public void injectText(String text) {
        this.flushText0();
        this.sbuf.append(text);
    }

    private void flushText() {
        this.flushText0();
        if (this.sbuf.length() > 0) {
            this.curr.list.add(this.sbuf.toString());
            this.sbuf.setLength(0);
        }
    }

    public void injectControl(RTFControl control) {
        this.flushText();
        this.curr.list.add(control);
    }

    public void setEncoding(String encoding) {
        if (!this.curr.encoding.equals(encoding)) {
            this.flushText0();
            this.curr.encoding = encoding;
        }
    }

    public void setSkipCount(int n) {
        this.curr.skipCount = n;
    }

    public void addFont(int index, RTFFont font) {
        this.fonts.put(new Integer(index), font);
    }

    public RTFFont getFont(int index) {
        return (RTFFont)this.fonts.get(new Integer(index));
    }

    public void setColorTable(RTFColor[] colors) {
        this.doc.colorTable = colors;
    }

    public void addParagraphStyle(int index, RTFStyle style) {
        this.paragraphStyles.put(new Integer(index), style);
    }

    public RTFStyle getParagraphStyle(int index) {
        return (RTFStyle)this.paragraphStyles.get(new Integer(index));
    }

    public void addCharacterStyle(int index, RTFStyle style) {
        this.characterStyles.put(new Integer(index), style);
    }

    public RTFStyle getCharacterStyle(int index) {
        return (RTFStyle)this.characterStyles.get(new Integer(index));
    }

    void parseInternal() throws IOException {
        this.start = 0;
        this.stop = 0;
        this.eof = false;
        this.levels = new Stack();
        this.curr = new Level();
        this.bbuf = new ByteArrayOutputStream();
        this.sbuf = new StringBuffer();
        this.fonts = new Hashtable();
        this.doc.fonts = this.fonts;
        this.paragraphStyles = new Hashtable();
        this.doc.paragraphStyles = this.paragraphStyles;
        this.characterStyles = new Hashtable();
        this.doc.characterStyles = this.characterStyles;
        StringBuffer cbuf = new StringBuffer();
        while (true) {
            int count;
            this.fillAtLeast(128);
            if (this.start == this.stop && this.eof) break;
            byte c = this.buffer[this.start];
            if (c == 10 || c == 13) {
                ++this.start;
                continue;
            }
            if (c == 123) {
                this.flushText();
                this.levels.push(this.curr);
                this.curr = new Level(this.curr);
                ++this.start;
                continue;
            }
            if (c == 125) {
                this.flushText();
                Object[] arr = new Object[this.curr.list.size()];
                this.curr.list.copyInto(arr);
                this.curr = (Level)this.levels.pop();
                RTFGroup group = new RTFGroup(arr);
                RTFControl control = group.getHead();
                if (control == null || !control.getType().parseTimeGroupExec(group, this)) {
                    this.curr.list.add(group);
                }
                ++this.start;
                continue;
            }
            if (c == 92) {
                RTFControl ctrl;
                RTFControlType type;
                if (this.curr.skipCount > 0) {
                    --this.curr.skipCount;
                }
                boolean optional = false;
                ++this.start;
                c = this.buffer[this.start];
                if (c == 42) {
                    optional = true;
                    ++this.start;
                    if (this.buffer[this.start] != 92) continue;
                    ++this.start;
                    c = this.buffer[this.start];
                }
                if (97 <= c && c <= 122 || 65 <= c && c <= 90) {
                    cbuf.setLength(0);
                    cbuf.append((char)c);
                    ++this.start;
                    while (this.start < this.stop) {
                        c = this.buffer[this.start];
                        if ((97 > c || c > 122) && (65 > c || c > 90)) break;
                        cbuf.append((char)c);
                        ++this.start;
                    }
                    type = RTFControlType.getControlTypeByName(cbuf.toString());
                    if (c == 32) {
                        ++this.start;
                        ctrl = new RTFControl(type, optional);
                    } else if (c == 45 || 48 <= c && c <= 57) {
                        int param = 0;
                        int sign = 1;
                        if (c == 45) {
                            ++this.start;
                            sign = -1;
                        }
                        while (this.start < this.stop) {
                            c = this.buffer[this.start];
                            if (48 > c || c > 57) {
                                if (c != 32) break;
                                ++this.start;
                                break;
                            }
                            ++this.start;
                            param = param * 10 + (c - 48);
                        }
                        ctrl = new RTFControlWithParam(type, optional, sign * param);
                    } else {
                        ctrl = new RTFControl(type, optional);
                    }
                } else {
                    type = RTFControlType.getControlTypeByName(Character.toString((char)c));
                    ++this.start;
                    ctrl = new RTFControl(type, optional);
                }
                if (ctrl.parseTimeExec(this)) continue;
                this.injectControl(ctrl);
                continue;
            }
            int i = this.start++;
            while (this.start < this.stop) {
                c = this.buffer[this.start];
                if (c == 92 || c == 123 || c == 125 || c == 13 || c == 10) break;
                ++this.start;
            }
            if (this.curr.skipCount < (count = this.start - i)) {
                this.curr.skipCount = 0;
                this.bbuf.write(this.buffer, i += this.curr.skipCount, count -= this.curr.skipCount);
                continue;
            }
            this.curr.skipCount -= count;
        }
        if (this.curr.list.size() >= 0) {
            this.doc.root = (RTFGroup)this.curr.list.get(0);
        }
    }

    static class Level {
        Vector list = new Vector();
        String encoding;
        int skipCount = 0;

        Level() {
            this.encoding = "Cp1252";
        }

        Level(Level prev) {
            this.encoding = prev.encoding;
            this.skipCount = prev.skipCount;
        }
    }
}

