/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.office.metafile;

import com.adobe.dp.office.metafile.GDIBitmap;
import com.adobe.dp.office.metafile.GDIBrush;
import com.adobe.dp.office.metafile.GDIFont;
import com.adobe.dp.office.metafile.GDIObject;
import com.adobe.dp.office.metafile.GDIPen;
import com.adobe.dp.office.metafile.GDISurface;
import com.adobe.dp.office.metafile.MetafileParser;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class WMFParser
extends MetafileParser {
    public static final int META_MAGIC = -1698247209;
    public static final int META_MAGIC1 = 589825;
    public static final int META_MAGIC2 = 589826;
    private static final int META_SAVEDC = 30;
    private static final int META_SETBKMODE = 258;
    private static final int META_SETMAPMODE = 259;
    private static final int META_SETROP2 = 260;
    private static final int META_SETRELABS = 261;
    private static final int META_SETPOLYFILLMODE = 262;
    private static final int META_RESTOREDC = 295;
    private static final int META_SELECTOBJECT = 301;
    private static final int META_SETTEXTALIGN = 302;
    private static final int META_DELETEOBJECT = 496;
    private static final int META_SETBKCOLOR = 513;
    private static final int META_SETTEXTCOLOR = 521;
    private static final int META_SETWINDOWORG = 523;
    private static final int META_SETWINDOWEXT = 524;
    private static final int META_LINETO = 531;
    private static final int META_MOVETO = 532;
    private static final int META_CREATEPENINDIRECT = 762;
    private static final int META_CREATEFONTINDIRECT = 763;
    private static final int META_CREATEBRUSHINDIRECT = 764;
    private static final int META_POLYGON = 804;
    private static final int META_POLYLINE = 805;
    private static final int META_ELLIPSE = 1048;
    private static final int META_RECTANGLE = 1051;
    private static final int META_POLYPOLYGON = 1336;
    private static final int META_EXTTEXTOUT = 2610;
    private static final int META_DIBSTRETCHBLT = 2881;
    private static final int META_STRETCHDIB = 3907;

    public WMFParser(InputStream in, GDISurface handler) throws IOException {
        super(in, handler);
        this.readFileHeader();
    }

    private int readRecordHeader() throws IOException {
        int remainsInRecord = this.readInt();
        int opcode = this.readShort() & 0xFFFF;
        this.setRemainsShorts(remainsInRecord - 3);
        return opcode;
    }

    private void readFileHeader() throws IOException {
        int magic = this.readInt();
        if (magic == -1698247209) {
            this.readShort();
            short left = this.readShort();
            short top = this.readShort();
            short right = this.readShort();
            short bottom = this.readShort();
            this.handler.setBounds(left, top, right, bottom);
            this.skipShorts(13);
        } else if (magic == 589825 || magic == 589826) {
            this.skipShorts(7);
        } else {
            throw new IOException("Invalid file format");
        }
    }

    public void readAll() throws IOException {
        while (this.readNext()) {
        }
        this.close();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean readNext() throws IOException {
        try {
            int opcode = this.readRecordHeader();
            switch (opcode) {
                case 0: {
                    return false;
                }
                case 30: {
                    this.handler.saveDC();
                    break;
                }
                case 295: {
                    this.handler.restoreDC();
                    break;
                }
                case 3907: {
                    this.skipShorts(3);
                    short srcHeight = this.readShort();
                    short srcWidth = this.readShort();
                    short srcY = this.readShort();
                    short srcX = this.readShort();
                    short destHeight = this.readShort();
                    short destWidth = this.readShort();
                    short destY = this.readShort();
                    short destX = this.readShort();
                    GDIBitmap bitmap = this.readDIB();
                    this.handler.stretchDIB(bitmap, destX, destY, destWidth, destHeight, srcX, srcY, srcWidth, srcHeight);
                    break;
                }
                case 2881: {
                    this.readInt();
                    short srcY = this.readShort();
                    short srcX = this.readShort();
                    short srcHeight = this.readShort();
                    short srcWidth = this.readShort();
                    short destHeight = this.readShort();
                    short destWidth = this.readShort();
                    short destY = this.readShort();
                    short destX = this.readShort();
                    GDIBitmap bitmap = this.readDIB();
                    this.handler.stretchDIB(bitmap, destX, destY, destWidth, destHeight, srcX, srcY, srcWidth, srcHeight);
                    break;
                }
                case 259: {
                    if (this.remainsBytes() <= 0) {
                        throw new IOException("Problem in SETMAPMODE");
                    }
                    short mode = this.readShort();
                    this.handler.setMapMode(mode);
                    break;
                }
                case 260: {
                    if (this.remainsBytes() <= 0) {
                        throw new IOException("Problem in SETROP2");
                    }
                    short mode = this.readShort();
                    this.handler.setROP2(mode);
                    break;
                }
                case 262: {
                    if (this.remainsBytes() <= 0) {
                        throw new IOException("Problem in SETPOLYFILLMODE");
                    }
                    short mode = this.readShort();
                    this.handler.setPolyFillMode(mode);
                    break;
                }
                case 258: {
                    if (this.remainsBytes() <= 0) {
                        throw new IOException("Problem in SETBKMODE");
                    }
                    short mode = this.readShort();
                    this.handler.setBkMode(mode);
                    break;
                }
                case 302: {
                    if (this.remainsBytes() <= 0) {
                        throw new IOException("Problem in SETTEXTALIGN");
                    }
                    short mode = this.readShort();
                    this.handler.setTextAlign(mode);
                    break;
                }
                case 301: {
                    if (this.remainsBytes() <= 0) {
                        throw new IOException("Problem in SELECTOBJECT");
                    }
                    short handle = this.readShort();
                    GDIObject gdi = (GDIObject)this.objects.get(handle);
                    this.handler.selectObject(gdi);
                    break;
                }
                case 496: {
                    if (this.remainsBytes() <= 0) {
                        throw new IOException("Problem in DELETEOBJECT");
                    }
                    short handle = this.readShort();
                    GDIObject gdi = (GDIObject)this.objects.get(handle);
                    this.handler.deleteObject(gdi);
                    gdi.dispose();
                    this.objects.set(handle, null);
                    break;
                }
                case 524: {
                    if (this.remainsShorts() < 2) {
                        throw new IOException("Problem in SETWINDOWEXT");
                    }
                    short h = this.readShort();
                    short w = this.readShort();
                    this.handler.setWindowExt(w, h);
                    break;
                }
                case 523: {
                    if (this.remainsShorts() < 2) {
                        throw new IOException("Problem in SETWINDOWORG");
                    }
                    short y = this.readShort();
                    short x = this.readShort();
                    this.handler.setWindowOrg(x, y);
                    break;
                }
                case 513: {
                    if (this.remainsShorts() < 2) {
                        throw new IOException("Problem in SETBKCOLOR");
                    }
                    this.handler.setBkColor(this.readRGB());
                    break;
                }
                case 521: {
                    if (this.remainsShorts() < 2) {
                        throw new IOException("Problem in SETTEXTCOLOR");
                    }
                    this.handler.setTextColor(this.readRGB());
                    break;
                }
                case 762: {
                    short widthY;
                    if (this.remainsShorts() < 5) {
                        throw new IOException("Problem in CREATEPENINDIRECT");
                    }
                    short style = this.readShort();
                    short widthX = this.readShort();
                    short width = widthX > (widthY = this.readShort()) ? widthX : widthY;
                    int rgb = this.readRGB();
                    GDIPen pen = this.handler.createPenIndirect(style, width, rgb);
                    this.storeObject(pen, 0);
                    break;
                }
                case 764: {
                    if (this.remainsShorts() < 4) {
                        throw new IOException("Problem in CREATEBRUSHINDIRECT");
                    }
                    short style = this.readShort();
                    int rgb = this.readRGB();
                    short hatch = this.readShort();
                    GDIBrush brush = this.handler.createBrushIndirect(style, rgb, hatch);
                    this.storeObject(brush, 0);
                    break;
                }
                case 763: {
                    if (this.remainsShorts() < 10) {
                        throw new IOException("Problem in CREATEFONTINDIRECT");
                    }
                    short fontHeight = this.readShort();
                    short width = this.readShort();
                    short esc = this.readShort();
                    short orientation = this.readShort();
                    short weight = this.readShort();
                    int dl = 2 * this.remainsShorts();
                    byte[] data = new byte[dl];
                    this.readBytes(data);
                    int l = 8;
                    while (l < dl && data[l] != 0) {
                        ++l;
                    }
                    String name = new String(data, 8, l - 8);
                    boolean italic = data[0] != 0;
                    boolean underline = data[1] != 0;
                    boolean strikeout = data[2] != 0;
                    int charset = data[3] & 0xFF;
                    int quality = data[6] & 0xFF;
                    int pitchAndFamily = data[7] & 0xFF;
                    GDIFont font = this.handler.createFontIndirect(fontHeight, width, esc, orientation, weight, name, italic, underline, strikeout, charset, quality, pitchAndFamily);
                    this.storeObject(font, 0);
                    break;
                }
                case 2610: {
                    if (this.remainsShorts() < 4) {
                        throw new IOException("Problem in EXTTEXTOUT");
                    }
                    short y = this.readShort();
                    short x = this.readShort();
                    short count = this.readShort();
                    short flags = this.readShort();
                    int[] clipRect = null;
                    int[] adj = null;
                    if ((flags & 4) != 0) {
                        clipRect = new int[]{this.readShort(), this.readShort(), this.readShort(), this.readShort()};
                    }
                    byte[] data = new byte[2 * this.remainsShorts()];
                    this.readBytes(data);
                    String text = new String(data, 0, (int)count);
                    this.handler.extTextOut(x, y, text, flags, clipRect, adj);
                    break;
                }
                case 532: {
                    if (this.remainsShorts() < 2) {
                        throw new IOException("Problem in MOVETO");
                    }
                    short y = this.readShort();
                    short x = this.readShort();
                    this.handler.moveTo(x, y);
                    break;
                }
                case 531: {
                    if (this.remainsShorts() < 2) {
                        throw new IOException("Problem in LINETO");
                    }
                    short y = this.readShort();
                    short x = this.readShort();
                    this.handler.lineTo(x, y);
                    break;
                }
                case 1051: {
                    if (this.remainsShorts() < 4) {
                        throw new IOException("Problem in RECTANGLE");
                    }
                    short bottom = this.readShort();
                    short right = this.readShort();
                    short top = this.readShort();
                    short left = this.readShort();
                    this.handler.rectangle(left, top, right, bottom);
                    break;
                }
                case 1048: {
                    if (this.remainsShorts() < 4) {
                        throw new IOException("Problem in ELLIPSE");
                    }
                    short bottom = this.readShort();
                    short right = this.readShort();
                    short top = this.readShort();
                    short left = this.readShort();
                    this.handler.ellipse(left, top, right, bottom);
                    break;
                }
                case 804: {
                    if (this.remainsShorts() < 2) {
                        throw new IOException("Problem in POLYGON");
                    }
                    int count = this.readShort() * 2;
                    int[] points = new int[count];
                    int i = 0;
                    while (i < count) {
                        points[i] = this.readShort();
                        ++i;
                    }
                    this.handler.polygon(points, 0, count);
                    break;
                }
                case 805: {
                    if (this.remainsShorts() < 2) {
                        throw new IOException("Problem in POLYLINE");
                    }
                    int count = this.readShort() * 2;
                    int[] points = new int[count];
                    int i = 0;
                    while (i < count) {
                        points[i] = this.readShort();
                        ++i;
                    }
                    this.handler.polyline(points, 0, count);
                    break;
                }
                case 1336: {
                    if (this.remainsShorts() < 2) {
                        throw new IOException("Problem in POLYPOLYLINE");
                    }
                    int polyCount = this.readShort();
                    int[] pointCounts = new int[polyCount];
                    int total = 0;
                    int i = 0;
                    while (i < polyCount) {
                        short n = this.readShort();
                        total += n;
                        pointCounts[i] = n;
                        ++i;
                    }
                    int[] points = new int[total *= 2];
                    int i2 = 0;
                    while (i2 < total) {
                        points[i2] = this.readShort();
                        ++i2;
                    }
                    this.handler.polyPolygon(pointCounts, points);
                    break;
                }
                default: {
                    System.out.println("UNKNOWN " + Integer.toHexString(opcode) + " " + this.remainsShorts());
                }
            }
            this.finishRecord();
            return true;
        }
        catch (EOFException e) {
            return false;
        }
    }
}

