/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.office.metafile;

import com.adobe.dp.office.conv.PNGWriter;

public class GDIBitmap {
    int biWidth;
    int biHeight;
    int biBitsPixel;
    int biCompression;
    byte[] bits;
    int[] colors;

    public GDIBitmap(int biWidth, int biHeight, int biBitsPixel, int biCompression, byte[] bits, int[] colors) {
        this.biWidth = biWidth;
        this.biHeight = biHeight;
        this.biBitsPixel = biBitsPixel;
        this.biCompression = biCompression;
        this.bits = bits;
        this.colors = colors;
    }

    public int getWidth() {
        return this.biWidth;
    }

    public int getHeight() {
        return this.biHeight;
    }

    public int getBitsPerPixel() {
        return this.biBitsPixel;
    }

    public String toString() {
        return "[GDIBitmap " + this.biWidth + " " + this.biHeight + " " + this.biBitsPixel + "]";
    }

    public void saveAsPNG(PNGWriter writer) {
        if (this.biCompression != 0) {
            throw new RuntimeException("not supported yet: comp=" + this.biCompression);
        }
        if (this.biBitsPixel == 24 || this.biBitsPixel == 8) {
            int height;
            int increment;
            int offset;
            int byteWidth = this.biWidth * 3;
            int stride = 4 * ((this.biWidth * this.biBitsPixel + 31) / 32);
            byte[] scanline = new byte[byteWidth];
            if (this.biHeight > 0) {
                offset = stride * (this.biHeight - 1);
                increment = -stride;
                height = this.biHeight;
            } else {
                offset = 0;
                increment = stride;
                height = -this.biHeight;
            }
            int j = 0;
            while (j < height) {
                if (this.biBitsPixel == 24) {
                    int i = 0;
                    while (i < byteWidth) {
                        scanline[i] = this.bits[offset + i + 2];
                        scanline[i + 1] = this.bits[offset + i + 1];
                        scanline[i + 2] = this.bits[offset + i];
                        i += 3;
                    }
                } else {
                    int si = 0;
                    int i = 0;
                    while (i < this.biWidth) {
                        int color = this.colors[this.bits[offset + i] & 0xFF];
                        scanline[si++] = (byte)(color >> 16);
                        scanline[si++] = (byte)(color >> 8);
                        scanline[si++] = (byte)color;
                        ++i;
                    }
                }
                writer.writeScanline(scanline, 0, byteWidth);
                offset += increment;
                ++j;
            }
            return;
        }
        if (this.biBitsPixel == 1) {
            int height;
            int increment;
            int offset;
            int[] nArray = new int[2];
            nArray[1] = 0xFFFFFF;
            int[] clrs = nArray;
            if (this.colors != null) {
                clrs = this.colors;
            }
            int byteWidth = this.biWidth * 3;
            int stride = 4 * ((this.biWidth + 31) / 32);
            byte[] scanline = new byte[byteWidth];
            if (this.biHeight > 0) {
                offset = stride * (this.biHeight - 1);
                increment = -stride;
                height = this.biHeight;
            } else {
                offset = 0;
                increment = stride;
                height = -this.biHeight;
            }
            int j = 0;
            while (j < height) {
                int si = 0;
                int i = 0;
                while (i < this.biWidth) {
                    int color = clrs[this.bits[offset + i / 8] >> 7 - (i & 7) & 1];
                    scanline[si++] = (byte)(color >> 16);
                    scanline[si++] = (byte)(color >> 8);
                    scanline[si++] = (byte)color;
                    ++i;
                }
                writer.writeScanline(scanline, 0, byteWidth);
                offset += increment;
                ++j;
            }
            return;
        }
        throw new RuntimeException("not supported yet: bpp=" + this.biBitsPixel);
    }
}

