/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.office.metafile;

import com.adobe.dp.office.metafile.GDIBitmap;
import com.adobe.dp.office.metafile.GDIBrush;
import com.adobe.dp.office.metafile.GDIObject;
import com.adobe.dp.office.metafile.GDIPen;
import com.adobe.dp.office.metafile.GDISurface;
import com.adobe.dp.office.metafile.MetafileParser;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class EMFParser
extends MetafileParser {
    private static final int ENHMETA_SIGNATURE = 1179469088;
    private static final int EMR_HEADER = 1;
    private static final int EMR_POLYBEZIER = 2;
    private static final int EMR_POLYGON = 3;
    private static final int EMR_POLYLINE = 4;
    private static final int EMR_POLYBEZIERTO = 5;
    private static final int EMR_POLYLINETO = 6;
    private static final int EMR_POLYPOLYLINE = 7;
    private static final int EMR_POLYPOLYGON = 8;
    private static final int EMR_SETWINDOWEXTEX = 9;
    private static final int EMR_SETWINDOWORGEX = 10;
    private static final int EMR_SETVIEWPORTEXTEX = 11;
    private static final int EMR_SETVIEWPORTORGEX = 12;
    private static final int EMR_SETBRUSHORGEX = 13;
    private static final int EMR_EOF = 14;
    private static final int EMR_SETPIXELV = 15;
    private static final int EMR_SETMAPPERFLAGS = 16;
    private static final int EMR_SETMAPMODE = 17;
    private static final int EMR_SETBKMODE = 18;
    private static final int EMR_SETPOLYFILLMODE = 19;
    private static final int EMR_SETROP2 = 20;
    private static final int EMR_SETSTRETCHBLTMODE = 21;
    private static final int EMR_SETTEXTALIGN = 22;
    private static final int EMR_SETCOLORADJUSTMENT = 23;
    private static final int EMR_SETTEXTCOLOR = 24;
    private static final int EMR_SETBKCOLOR = 25;
    private static final int EMR_OFFSETCLIPRGN = 26;
    private static final int EMR_MOVETOEX = 27;
    private static final int EMR_SETMETARGN = 28;
    private static final int EMR_EXCLUDECLIPRECT = 29;
    private static final int EMR_INTERSECTCLIPRECT = 30;
    private static final int EMR_SCALEVIEWPORTEXTEX = 31;
    private static final int EMR_SCALEWINDOWEXTEX = 32;
    private static final int EMR_SAVEDC = 33;
    private static final int EMR_RESTOREDC = 34;
    private static final int EMR_SETWORLDTRANSFORM = 35;
    private static final int EMR_MODIFYWORLDTRANSFORM = 36;
    private static final int EMR_SELECTOBJECT = 37;
    private static final int EMR_CREATEPEN = 38;
    private static final int EMR_CREATEBRUSHINDIRECT = 39;
    private static final int EMR_DELETEOBJECT = 40;
    private static final int EMR_ANGLEARC = 41;
    private static final int EMR_ELLIPSE = 42;
    private static final int EMR_RECTANGLE = 43;
    private static final int EMR_ROUNDRECT = 44;
    private static final int EMR_ARC = 45;
    private static final int EMR_CHORD = 46;
    private static final int EMR_PIE = 47;
    private static final int EMR_SELECTPALETTE = 48;
    private static final int EMR_CREATEPALETTE = 49;
    private static final int EMR_SETPALETTEENTRIES = 50;
    private static final int EMR_RESIZEPALETTE = 51;
    private static final int EMR_REALIZEPALETTE = 52;
    private static final int EMR_EXTFLOODFILL = 53;
    private static final int EMR_LINETO = 54;
    private static final int EMR_ARCTO = 55;
    private static final int EMR_POLYDRAW = 56;
    private static final int EMR_SETARCDIRECTION = 57;
    private static final int EMR_SETMITERLIMIT = 58;
    private static final int EMR_BEGINPATH = 59;
    private static final int EMR_ENDPATH = 60;
    private static final int EMR_CLOSEFIGURE = 61;
    private static final int EMR_FILLPATH = 62;
    private static final int EMR_STROKEANDFILLPATH = 63;
    private static final int EMR_STROKEPATH = 64;
    private static final int EMR_FLATTENPATH = 65;
    private static final int EMR_WIDENPATH = 66;
    private static final int EMR_SELECTCLIPPATH = 67;
    private static final int EMR_ABORTPATH = 68;
    private static final int EMR_GDICOMMENT = 70;
    private static final int EMR_FILLRGN = 71;
    private static final int EMR_FRAMERGN = 72;
    private static final int EMR_INVERTRGN = 73;
    private static final int EMR_PAINTRGN = 74;
    private static final int EMR_EXTSELECTCLIPRGN = 75;
    private static final int EMR_BITBLT = 76;
    private static final int EMR_STRETCHBLT = 77;
    private static final int EMR_MASKBLT = 78;
    private static final int EMR_PLGBLT = 79;
    private static final int EMR_SETDIBITSTODEVICE = 80;
    private static final int EMR_STRETCHDIBITS = 81;
    private static final int EMR_EXTCREATEFONTINDIRECTW = 82;
    private static final int EMR_EXTTEXTOUTA = 83;
    private static final int EMR_EXTTEXTOUTW = 84;
    private static final int EMR_POLYBEZIER16 = 85;
    private static final int EMR_POLYGON16 = 86;
    private static final int EMR_POLYLINE16 = 87;
    private static final int EMR_POLYBEZIERTO16 = 88;
    private static final int EMR_POLYLINETO16 = 89;
    private static final int EMR_POLYPOLYLINE16 = 90;
    private static final int EMR_POLYPOLYGON16 = 91;
    private static final int EMR_POLYDRAW16 = 92;
    private static final int EMR_CREATEMONOBRUSH = 93;
    private static final int EMR_CREATEDIBPATTERNBRUSHPT = 94;
    private static final int EMR_EXTCREATEPEN = 95;
    private static final int EMR_POLYTEXTOUTA = 96;
    private static final int EMR_POLYTEXTOUTW = 97;
    private static final int EMR_SETICMMODE = 98;
    private static final int EMR_CREATECOLORSPACE = 99;
    private static final int EMR_SETCOLORSPACE = 100;
    private static final int EMR_DELETECOLORSPACE = 101;
    private static final int EMR_GLSRECORD = 102;
    private static final int EMR_GLSBOUNDEDRECORD = 103;
    private static final int EMR_PIXELFORMAT = 104;
    private static final int EMR_COLORCORRECTPALETTE = 111;
    private static final int EMR_SETICMPROFILEA = 112;
    private static final int EMR_SETICMPROFILEW = 113;
    private static final int EMR_ALPHABLEND = 114;
    private static final int EMR_SETLAYOUT = 115;
    private static final int EMR_TRANSPARENTBLT = 116;
    private static final int EMR_GRADIENTFILL = 118;
    private static final int EMR_COLORMATCHTOTARGETW = 121;
    private static final int EMR_CREATECOLORSPACEW = 122;
    private static final int GDICOMMENT_BEGINGROUP = 2;
    private static final int GDICOMMENT_ENDGROUP = 3;
    private static final int GDICOMMENT_UNICODE_STRING = 64;
    private static final int GDICOMMENT_UNICODE_END = 128;
    private static final int GDICOMMENT_WINDOWS_METAFILE = -2147483647;
    private static final int GDICOMMENT_IDENTIFIER = 1128875079;
    private static final int GDICOMMENT_EMFPLUS = 726027589;

    public EMFParser(InputStream in, GDISurface handler) throws IOException {
        super(in, handler);
        this.readFileHeader();
    }

    private void readFileHeader() throws IOException {
        int iType = this.readInt();
        if (iType != 1) {
            throw new IOException("corrupted header");
        }
        int nSize = this.readInt();
        this.setRemainsBytes(nSize - 8);
        int boundsLeft = this.readInt();
        int boundsTop = this.readInt();
        int boundsRight = this.readInt();
        int boundsBottom = this.readInt();
        this.skipInts(4);
        int dSignature = this.readInt();
        if (dSignature != 1179469088) {
            throw new IOException("corrupted header signature");
        }
        int nVersion = this.readInt();
        if (nVersion != 65536) {
            throw new IOException("unsupported version");
        }
        this.finishRecord();
        this.handler.setBounds(boundsLeft, boundsTop, boundsRight, boundsBottom);
    }

    private void readGDIComment() throws IOException {
        int len = this.readInt();
        if (len < 8) {
            byte[] arr = new byte[len];
            this.readBytes(arr);
            this.handler.comment(arr, 0, arr.length);
        } else {
            int id = this.readInt();
            if (id == 1128875079) {
                int commType = this.readInt();
                switch (commType) {
                    case 2: {
                        int boundsLeft = this.readInt();
                        int boundsTop = this.readInt();
                        int boundsRight = this.readInt();
                        int boundsBottom = this.readInt();
                        int uChars = this.readInt();
                        StringBuffer desc = new StringBuffer();
                        while (uChars > 0) {
                            --uChars;
                            desc.append((char)this.readShort());
                        }
                        this.handler.commentBeginGroup(boundsLeft, boundsTop, boundsRight, boundsBottom, desc.toString());
                        break;
                    }
                    case 3: {
                        this.handler.commentEndGroup();
                        break;
                    }
                    case -2147483647: {
                        int version = this.readInt();
                        this.readInt();
                        int flags = this.readInt();
                        if (flags != 0) {
                            throw new IOException("GDICOMMENT_WINDOWS_METAFILE: flags not zero");
                        }
                        int mfLen = this.readInt();
                        byte[] mfBytes = new byte[mfLen];
                        this.readBytes(mfBytes);
                        this.handler.commentMetafile(version, mfBytes, 0, mfLen);
                        break;
                    }
                    default: {
                        byte[] d = new byte[len - 4];
                        this.readBytes(d);
                        this.handler.commentGDIC(commType, d, 0, len);
                        break;
                    }
                }
            } else if (id == 726027589) {
                byte[] d = new byte[len - 4];
                this.readBytes(d);
                this.handler.commentEMFPlus(d, 0, len);
            } else {
                byte[] arr = new byte[len];
                arr[0] = (byte)id;
                arr[1] = (byte)(id >> 8);
                arr[2] = (byte)(id >> 16);
                arr[3] = (byte)(id >> 24);
                this.readBytes(arr, 4, len - 4);
                this.handler.comment(arr, 0, arr.length);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean readNext() throws IOException {
        try {
            int type = this.readInt();
            int size = this.readInt();
            this.setRemainsBytes(size - 8);
            block1 : switch (type) {
                case 1: {
                    throw new IOException("unexpected header record");
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                case 9: {
                    int width = this.readInt();
                    int height = this.readInt();
                    this.handler.setWindowExt(width, height);
                    break;
                }
                case 10: {
                    int x = this.readInt();
                    int y = this.readInt();
                    this.handler.setWindowOrg(x, y);
                    break;
                }
                case 11: {
                    int width = this.readInt();
                    int height = this.readInt();
                    this.handler.setViewportExt(width, height);
                    break;
                }
                case 12: {
                    int x = this.readInt();
                    int y = this.readInt();
                    this.handler.setViewportExt(x, y);
                    break;
                }
                case 13: {
                    break;
                }
                case 14: {
                    this.finishRecord();
                    return false;
                }
                case 15: 
                case 16: {
                    break;
                }
                case 17: {
                    int mode = this.readInt();
                    this.handler.setMapMode(mode);
                    break;
                }
                case 18: {
                    int mode = this.readInt();
                    this.handler.setBkMode(mode);
                    break;
                }
                case 19: 
                case 20: 
                case 21: {
                    break;
                }
                case 22: {
                    int textAlign = this.readInt();
                    this.handler.setTextAlign(textAlign);
                }
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: {
                    break;
                }
                case 33: {
                    this.handler.saveDC();
                    break;
                }
                case 34: {
                    this.handler.restoreDC();
                    break;
                }
                case 35: 
                case 36: {
                    break;
                }
                case 37: {
                    int index = this.readInt();
                    GDIObject gdi = (GDIObject)this.objects.get(index);
                    this.handler.selectObject(gdi);
                    break;
                }
                case 38: {
                    break;
                }
                case 39: {
                    int index = this.readInt();
                    int style = this.readInt();
                    int color = this.readRGB();
                    int hatch = this.readInt();
                    GDIBrush brush = this.handler.createBrushIndirect(style, color, hatch);
                    this.storeObject(brush, index);
                    break;
                }
                case 40: {
                    int index = this.readInt();
                    GDIObject gdi = (GDIObject)this.objects.get(index);
                    this.objects.set(index, null);
                    this.handler.deleteObject(gdi);
                    gdi.dispose();
                }
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    break;
                }
                case 58: {
                    int miterLimit = this.readInt();
                    this.handler.setMiterLimit(miterLimit);
                }
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: {
                    break;
                }
                case 70: {
                    this.readGDIComment();
                    break;
                }
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: {
                    break;
                }
                case 81: {
                    this.readInt();
                    this.readInt();
                    this.readInt();
                    this.readInt();
                    int xDest = this.readInt();
                    int yDest = this.readInt();
                    int xSrc = this.readInt();
                    int ySrc = this.readInt();
                    int cxSrc = this.readInt();
                    int cySrc = this.readInt();
                    int offBmiSrc = this.readInt();
                    this.readInt();
                    int offBitsSrc = this.readInt();
                    this.readInt();
                    this.readInt();
                    this.readInt();
                    int cxDest = this.readInt();
                    int cyDest = this.readInt();
                    this.skipBytes(offBmiSrc - 80);
                    GDIBitmap bitmap = this.readDIB(offBitsSrc - 80);
                    this.handler.stretchDIB(bitmap, xDest, yDest, cxDest, cyDest, xSrc, ySrc, cxSrc, cySrc);
                    break;
                }
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: {
                    break;
                }
                case 90: 
                case 91: {
                    this.readInt();
                    this.readInt();
                    this.readInt();
                    this.readInt();
                    int nPolys = this.readInt();
                    int[] lens = new int[nPolys];
                    int total = 0;
                    int i = 0;
                    while (true) {
                        int len;
                        if (i >= nPolys) {
                            int totalPts = this.readInt();
                            if (totalPts >= total) break;
                            throw new IOException("invalid POLYPOLYXXX record");
                        }
                        lens[i] = len = this.readInt();
                        total += len;
                        ++i;
                    }
                    int[] points = new int[total *= 2];
                    int i2 = 0;
                    while (true) {
                        if (i2 >= total) {
                            if (type != 90) break;
                            this.handler.polyPolyline(lens, points);
                            break block1;
                        }
                        points[i2] = this.readShort();
                        ++i2;
                    }
                    this.handler.polyPolygon(lens, points);
                    break;
                }
                case 92: 
                case 93: 
                case 94: {
                    break;
                }
                case 95: {
                    int index = this.readInt();
                    this.readInt();
                    this.readInt();
                    this.readInt();
                    this.readInt();
                    int style = this.readInt();
                    int width = this.readInt();
                    this.readInt();
                    int color = this.readRGB();
                    this.readInt();
                    this.readInt();
                    GDIPen pen = this.handler.extCreatePen(style, width, color);
                    this.storeObject(pen, index);
                    break;
                }
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 118: 
                case 121: 
                case 122: {
                    break;
                }
                default: {
                    throw new IOException("unknown command");
                }
            }
            this.finishRecord();
            return true;
        }
        catch (EOFException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void readAll() throws IOException {
        while (this.readNext()) {
        }
        this.close();
    }
}

